package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.scp.application.facade.vo.param.app.*;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.*;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.item.ScpCateItemService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.app.ScpStoreItemConvert;
import com.elitesland.scp.domain.convert.authority.AppItmItemConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.item.ScpStoreItemDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingItemDomainService;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.domain.service.minOrder.ScpMinOrderSettingItemDomainService;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingItemDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiSysUDCService;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.CollectRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemScpBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class AppItemActivityrServiceImpl implements AppItemActivityService {

    private final RmiItemService rmiItemService;
    private final CartRedisUtil cartRedisUtil;
    private final CollectRedisUtil collectRedisUtil;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final ScpCacheService scpCacheService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ScpWhNetRelationService scpWhNetRelationService;
    private final ScpCateItemService scpCateItemService;
    private final ScpMinOrderSettingItemDomainService scpMinOrderSettingItemDomainService;
    private final ScpsmanInfoRepo scpsmanInfoRepo;
    private final RmiSysUDCService rmiSysUDCService;
    private final ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService;
    private final ScpPurLimitSettingItemDomainService scpPurLimitSettingItemDomainService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final ScpAllocSettingItemDomainService scpAllocSettingItemDomainService;
    private final TaskExecutor taskExecutor;

    @Override
    @SysCodeProc
    public PagingVO<AppItemActivityRespVO> query(AppItemActivityParamVO paramVO) throws ExecutionException,
            InterruptedException {
        // 常定功能先返回空20240729
        return new PagingVO<>();
    }

    @Override
    public PagingVO<AppItmItemPageVO> itemPage(AppItemPageParamVO paramVO) {
        //根据单据类型查询绑定的商品分类
        if (StrUtil.isNotBlank(paramVO.getBusinessType())) {
            List<String> itemTypes = scpOrderSettingDomainService.findItemCatesByBusinessType(paramVO.getBusinessType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            paramVO.setItemTypes(itemTypes);
        }
        if (StrUtil.isBlank(paramVO.getBrand())) {
            return new PagingVO<>();
        }
        Long count = scpCateItemRepoProc.countAppItemSpu(paramVO);
        if (count == 0) {
            return new PagingVO<>();
        }
        List<AppItmItemPageVO> itemList = scpCateItemRepoProc.pageAppItemSpu(paramVO);
        // 商品信息查询,图片信息，同SPU下其他SKU信息
        this.itemMessageImageAndDetailsQuery(itemList, paramVO.getStoreCode(), paramVO.getBusinessType(), paramVO.getOuCode());
        //商品价格和库存查询
        this.getPriceAndStock(paramVO.getBusinessType(), itemList, paramVO.getStoreCode(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        return new PagingVO<>(count, itemList);
    }

    @Override
    public PagingVO<AppItmItemPageVO> skuItemPage(AppItemPageParamVO paramVO) {
        AddressParamVO addressParam = paramVO.getAddressParam();
        if (addressParam == null) {
            addressParam = cartRedisUtil.getAddr();
            paramVO.setAddressParam(addressParam);
        }
        if (ScpUdcEnum.BUSINESS_TYPE_50.getValueCode().equals(paramVO.getBusinessType()) && addressParam == null) {
            log.error("装修类业务，没有获取甲指乙采类商品订单的收货人地址");
            return PagingVO.<AppItmItemPageVO>builder()
                    .total(0L)
                    .records(Collections.emptyList())
                    .build();
        }
        return getAppItmItemPageVOPagingVO(paramVO);
    }
    /**
     * 获取SKU商品列表分页数据
     * <p>
     * 该方法根据传入的查询参数，获取SKU商品的分页列表。主要处理逻辑包括：
     * 1. 根据业务类型获取配送类型
     * 2. 查询商品基本信息和分页数据
     * 3. 获取当前登录用户及订货账号信息
     * 4. 过滤可售、可见、上下架的商品
     * 5. 查询商品详情、图片、价格和库存信息
     * 6. 处理预售商品标识
     * 7. 异步查询强配、起订、限购等营销活动信息
     * 8. 设置商品的各类营销活动属性
     * 9. 过滤无价格的商品数据
     * 10. 按库存情况排序返回结果
     *
     * @param paramVO 查询参数对象，包含业务类型、门店编码等查询条件
     * @return 分页结果对象，包含商品列表和总数
     * @throws BusinessException 当登录用户或订货账号查询异常时抛出
     */
    private PagingVO<AppItmItemPageVO> getAppItmItemPageVOPagingVO(AppItemPageParamVO paramVO) {
        //根据业务类型查询绑定的商品分类
        if (StrUtil.isNotBlank(paramVO.getBusinessType())) {
            // 通过业务类型，获取配送类型
            List<String> deliveryTypes = scpOrderSettingDomainService.findDeliveryTypeByBusinessType(paramVO.getBusinessType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            paramVO.setDeliveryTypes(deliveryTypes);
        }
//        if (StrUtil.isBlank(paramVO.getBrand())) {
//            return new PagingVO<>();
//        }

        Long count = scpCateItemRepoProc.countAppItemAndWhNetSku(paramVO);
        if (count == 0) {
            return new PagingVO<>();
        }
        List<AppItmItemPageVO> itemList = scpCateItemRepoProc.pageAppItemAndWhNetSku(paramVO);

        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("当前登录人查询异常");
        }
        // 查询订货账号类型
        ScpsmanInfoDO byLoginAccount = scpsmanInfoRepo.findByLoginAccount(currentUserDTO.getDetail().getUsername());
        log.info("当前登录人订货账号:{}", JSONUtil.toJsonStr(byLoginAccount));
        if (byLoginAccount == null) {
            throw new BusinessException("当前登录人订货账号查询异常");
        }
        String scpManType = byLoginAccount.getScpsmanType();

        // 设置门店的订货日历筛选(8月18客户确认，不需要筛选门店日历)
//        List<AppItmItemPageVO> itemList = setStoreDemandCalendar(paramVO, originItemList, scpManType);

        List<String> itemCodeList = itemList.stream().map(AppItmItemPageVO::getItemCode).collect(Collectors.toList());
        // 获取可用商品,通过可售，可见，上下架配置过滤
        List<String> usefulItemCodeList = getUsefulItemCodeList(paramVO, itemCodeList, scpManType);
        // 过滤可售，可见，上下架
        itemList = itemList.stream().filter(item -> usefulItemCodeList.contains(item.getItemCode())).collect(Collectors.toList());

        // 商品信息查询,图片信息，同SPU下其他SKU信息
        this.itemMessageImageAndDetailsQuery(itemList, paramVO.getStoreCode(), paramVO.getBusinessType(), paramVO.getOuCode());
        //商品价格和库存查询
        if (ScpUdcEnum.BUSINESS_TYPE_50.getValueCode().equals(paramVO.getBusinessType())){

            this.getPurPriceAndStock(paramVO.getBusinessType(), itemList, paramVO.getStoreCode(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(),paramVO.getAddressParam());
        }else {
            this.getPriceAndStock(paramVO.getBusinessType(), itemList, paramVO.getStoreCode(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        }
        // 设置预售筛选
        List<String> preSaleItemCodeList = scpCateItemService.getPreSaleItemList(itemCodeList);
        log.info("小程序预售商品{}", JSONUtil.toJsonStr(preSaleItemCodeList));

        // 查询强配活动
        CompletableFuture<Map<String, ScpAllocSettingItemRespVO>> allocSettingMapFuture = CompletableFuture.supplyAsync(() -> {
            List<ScpAllocSettingItemRespVO> allocSettingItemList = scpAllocSettingItemDomainService.getEnableAllocSettingItemByStoreCode(paramVO.getStoreCode(), paramVO.getBusinessType());
            if (CollUtil.isNotEmpty(allocSettingItemList)) {
                return allocSettingItemList.stream().collect(Collectors.toMap(ScpAllocSettingItemRespVO::getItemCode, Function.identity(), (k1, k2) -> k1));
            } else {
                return new HashMap<>();
            }
        }, taskExecutor);

        //设置起订活动
        CompletableFuture<Map<Long, BigDecimal>> minOrderMapFuture = CompletableFuture.supplyAsync(() -> {
            List<ScpMinOrderSettingItemRespVO> minOrderSettingItemRespVOList = scpMinOrderSettingItemDomainService.getEnableMinOrderSettingItemByStoreCode(paramVO.getStoreCode(), paramVO.getDeliveryTypes());
            if (CollUtil.isNotEmpty(minOrderSettingItemRespVOList)) {
                return minOrderSettingItemRespVOList.stream().collect(Collectors.toMap(ScpMinOrderSettingItemRespVO::getItemId, ScpMinOrderSettingItemRespVO::getMinNum, (k1, k2) -> k1));
            } else {
                return new HashMap<>();
            }
        }, taskExecutor);

        // 设置限购活动
        CompletableFuture<Map<Long, BigDecimal>> purLimitMapFuture = CompletableFuture.supplyAsync(() -> {
            List<ScpPurLimitSettingItemRespVO> purLimitSettingItemByStoreCode = scpPurLimitSettingItemDomainService.getEnablePurLimitSettingItemByStoreCode(paramVO.getStoreCode(), paramVO.getDeliveryTypes());
            return purLimitSettingItemByStoreCode.stream().collect(Collectors.toMap(ScpPurLimitSettingItemRespVO::getItemId, ScpPurLimitSettingItemRespVO::getMinNum, (k1, k2) -> k1));
        }, taskExecutor);

        CompletableFuture<Map<Long, BigDecimal>> longBigDecimalMapFuture = purLimitMapFuture.thenComposeAsync(purLimitMap -> {
            if (!CollUtil.isEmpty(purLimitMap)) {
                return CompletableFuture.supplyAsync(() -> {
                    Map<Long, BigDecimal> longBigDecimalMap = scpDemandOrderRepoProc.countAllocatedOrderItemByItemCodes(new ArrayList<>(purLimitMap.keySet()), paramVO.getStoreCode(), LocalDateTime.now());
                    log.info("限购查询结果：{}", longBigDecimalMap);
                    return longBigDecimalMap;
                }, taskExecutor);
            } else {
                return CompletableFuture.completedFuture(new HashMap<>());
            }
        }, taskExecutor);

        Map<String, ScpAllocSettingItemRespVO> allocSettingMap;
        // 设置起订活动
        Map<Long, BigDecimal> minOrderMap;
        Map<Long, BigDecimal> purLimitMap;
        Map<Long, BigDecimal> longBigDecimalMap;
        try {
            allocSettingMap = allocSettingMapFuture.get();
            minOrderMap = minOrderMapFuture.get();
            purLimitMap = purLimitMapFuture.get();
            longBigDecimalMap = longBigDecimalMapFuture.get();
        } catch (InterruptedException | ExecutionException e) {
            log.error("小程序商品查询异常:{}", e.getMessage(), e);
            throw new BusinessException(e.getMessage());
        }

        Map<String, String> itemType2 = rmiSysUDCService.getCodeMap("yst-supp", "ITEM_TYPE2");

        // 无库存的数据
        List<AppItmItemPageVO> noAvalQtyList = new ArrayList<>();

        // 有库存的数据
        List<AppItmItemPageVO> haveAvalQtyList = new ArrayList<>();

        // 过滤数据
        for (AppItmItemPageVO item : itemList) {
            if (preSaleItemCodeList.contains(item.getItemCode())) {
                item.setPreSaleStatus(true);
            }
            // 最小起订量
            BigDecimal moq = minOrderMap.get(item.getItemId());
            item.setMoq(moq);

            // 强配限制
            ScpAllocSettingItemRespVO scpAllocSettingItemRespVO = allocSettingMap.get(item.getItemCode());
            item.setAllocLimitFlag(scpAllocSettingItemRespVO != null);

            // 设置限购活动
            Long itemId = item.getItemId();
            BigDecimal purLimitQty = purLimitMap.get(itemId);
            BigDecimal useQty = longBigDecimalMap.get(itemId);
            BigDecimal canUseQty = calculateCanUseQty(purLimitQty, useQty);
            if (canUseQty != null) {
                item.setPurLimitQty(canUseQty);
            }

            // 设置配送类型
            Optional.ofNullable(itemType2.get(item.getItemType2())).ifPresent(item::setItemType2Name);


            // 过滤掉没有价格的数据
            List<AppItmItemPageVO> details = item.getDetails();
            if (CollUtil.isNotEmpty(details)) {
                details.removeIf(detail -> detail.getPrice() == null);
            }
            if (details == null || details.isEmpty()) {
                continue;
            }

            AtomicReference<BigDecimal> avalQty = new AtomicReference<>(null);
            List<AppItmItemPageVO> collect = details.stream().peek(detail -> {
                // 最小起订量
                detail.setMoq(moq);
                // 强配限制
                item.setAllocLimitFlag(scpAllocSettingItemRespVO != null);
                // 设置限购活动
                if (canUseQty != null) {
                    detail.setPurLimitQty(canUseQty);
                }
                // 预售商品
                if (preSaleItemCodeList.contains(item.getItemCode())) {
                    detail.setPreSaleStatus(true);
                }
                // 设置配送类型
                Optional.ofNullable(itemType2.get(detail.getItemType2())).ifPresent(detail::setItemType2Name);

                // 设置第一个非空库存值
                if (detail.getAvalQty() != null && avalQty.get() == null) {
                    avalQty.set(detail.getAvalQty());
                }
            }).toList();
            item.setAvalQty(avalQty.get());
            item.setDetails(collect);

            // 不是直送并且没库存的数据
            if (!ScpConstant.PUR_TRN_DELIVERY_TYPES.contains(item.getItemType2()) && Objects.equals(item.getAvalQty(), BigDecimal.ZERO)) {
                noAvalQtyList.add(item);
            } else {
                haveAvalQtyList.add(item);
            }
        }

        // 排序，没库存的放最后
        List<AppItmItemPageVO> processedItems = haveAvalQtyList.stream()
                .filter(Objects::nonNull) // 过滤掉null对象
                .sorted(Comparator.comparing(AppItmItemPageVO::getAvalQty,
                        Comparator.nullsLast(Comparator.reverseOrder())))
                .collect(Collectors.toList());
        if (CollUtil.isNotEmpty(noAvalQtyList)) {
            processedItems.addAll(noAvalQtyList.stream().filter(Objects::nonNull).toList());
        }

        return new PagingVO<>(count, processedItems);
    }

//    private PagingVO<AppItmItemPageVO> getAppDboItmItemPageVOPagingVO(AppItemPageParamVO paramVO) {
//        //根据业务类型查询绑定的商品分类
//        if (StrUtil.isNotBlank(paramVO.getBusinessType())) {
//            // 通过业务类型，获取配送类型
//            List<String> deliveryTypes = scpOrderSettingDomainService.findDeliveryTypeByBusinessType(paramVO.getBusinessType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
//            paramVO.setDeliveryTypes(deliveryTypes);
//        }
////        if (StrUtil.isBlank(paramVO.getBrand())) {
////            return new PagingVO<>();
////        }
//
//        Long count = scpCateItemRepoProc.countAppItemAndWhNetSku(paramVO);
//        if (count == 0) {
//            return new PagingVO<>();
//        }
//        List<AppItmItemPageVO> itemList = scpCateItemRepoProc.pageAppItemAndWhNetSku(paramVO);
//
//        //查询当前登录用户
//        CurrentUserDTO currentUserDTO = UserService.currentUser();
//        if (currentUserDTO == null) {
//            throw new BusinessException("当前登录人查询异常");
//        }
//        // 查询订货账号类型
//        ScpsmanInfoDO byLoginAccount = scpsmanInfoRepo.findByLoginAccount(currentUserDTO.getDetail().getUsername());
//        log.info("当前登录人订货账号:{}", JSONUtil.toJsonStr(byLoginAccount));
//        if (byLoginAccount == null) {
//            throw new BusinessException("当前登录人订货账号查询异常");
//        }
//        String scpManType = byLoginAccount.getScpsmanType();
//
//        // 设置门店的订货日历筛选(8月18客户确认，不需要筛选门店日历)
////        List<AppItmItemPageVO> itemList = setStoreDemandCalendar(paramVO, originItemList, scpManType);
//
//        List<String> itemCodeList = itemList.stream().map(AppItmItemPageVO::getItemCode).collect(Collectors.toList());
//        // 获取可用商品,通过可售，可见，上下架配置过滤
//        List<String> usefulItemCodeList = getUsefulItemCodeList(paramVO, itemCodeList, scpManType);
//        // 过滤可售，可见，上下架
//        itemList = itemList.stream().filter(item -> usefulItemCodeList.contains(item.getItemCode())).collect(Collectors.toList());
//
//        // 商品信息查询,图片信息，同SPU下其他SKU信息
//        this.itemMessageImageAndDetailsQuery(itemList, paramVO.getStoreCode(), paramVO.getBusinessType(), paramVO.getOuCode());
//        //商品价格和库存查询
//        this.getPurPriceAndStock(paramVO.getBusinessType(), itemList, paramVO.getStoreCode(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
//
//        // 设置预售筛选
//        List<String> preSaleItemCodeList = scpCateItemService.getPreSaleItemList(itemCodeList);
//        log.info("小程序预售商品{}", JSONUtil.toJsonStr(preSaleItemCodeList));
//
//        // 查询强配活动
//        CompletableFuture<Map<String, ScpAllocSettingItemRespVO>> allocSettingMapFuture = CompletableFuture.supplyAsync(() -> {
//            List<ScpAllocSettingItemRespVO> allocSettingItemList = scpAllocSettingItemDomainService.getEnableAllocSettingItemByStoreCode(paramVO.getStoreCode(), paramVO.getBusinessType());
//            if (CollUtil.isNotEmpty(allocSettingItemList)) {
//                return allocSettingItemList.stream().collect(Collectors.toMap(ScpAllocSettingItemRespVO::getItemCode, Function.identity(), (k1, k2) -> k1));
//            } else {
//                return new HashMap<>();
//            }
//        }, taskExecutor);
//
//        //设置起订活动
//        CompletableFuture<Map<Long, BigDecimal>> minOrderMapFuture = CompletableFuture.supplyAsync(() -> {
//            List<ScpMinOrderSettingItemRespVO> minOrderSettingItemRespVOList = scpMinOrderSettingItemDomainService.getEnableMinOrderSettingItemByStoreCode(paramVO.getStoreCode(), paramVO.getDeliveryTypes());
//            if (CollUtil.isNotEmpty(minOrderSettingItemRespVOList)) {
//                return minOrderSettingItemRespVOList.stream().collect(Collectors.toMap(ScpMinOrderSettingItemRespVO::getItemId, ScpMinOrderSettingItemRespVO::getMinNum, (k1, k2) -> k1));
//            } else {
//                return new HashMap<>();
//            }
//        }, taskExecutor);
//
//        // 设置限购活动
//        CompletableFuture<Map<Long, BigDecimal>> purLimitMapFuture = CompletableFuture.supplyAsync(() -> {
//            List<ScpPurLimitSettingItemRespVO> purLimitSettingItemByStoreCode = scpPurLimitSettingItemDomainService.getEnablePurLimitSettingItemByStoreCode(paramVO.getStoreCode(), paramVO.getDeliveryTypes());
//            return purLimitSettingItemByStoreCode.stream().collect(Collectors.toMap(ScpPurLimitSettingItemRespVO::getItemId, ScpPurLimitSettingItemRespVO::getMinNum, (k1, k2) -> k1));
//        }, taskExecutor);
//
//        CompletableFuture<Map<Long, BigDecimal>> longBigDecimalMapFuture = purLimitMapFuture.thenComposeAsync(purLimitMap -> {
//            if (!CollUtil.isEmpty(purLimitMap)) {
//                return CompletableFuture.supplyAsync(() -> {
//                    Map<Long, BigDecimal> longBigDecimalMap = scpDemandOrderRepoProc.countAllocatedOrderItemByItemCodes(new ArrayList<>(purLimitMap.keySet()), paramVO.getStoreCode(), LocalDateTime.now());
//                    log.info("限购查询结果：{}", longBigDecimalMap);
//                    return longBigDecimalMap;
//                }, taskExecutor);
//            } else {
//                return CompletableFuture.completedFuture(new HashMap<>());
//            }
//        }, taskExecutor);
//
//        Map<String, ScpAllocSettingItemRespVO> allocSettingMap;
//        // 设置起订活动
//        Map<Long, BigDecimal> minOrderMap;
//        Map<Long, BigDecimal> purLimitMap;
//        Map<Long, BigDecimal> longBigDecimalMap;
//        try {
//            allocSettingMap = allocSettingMapFuture.get();
//            minOrderMap = minOrderMapFuture.get();
//            purLimitMap = purLimitMapFuture.get();
//            longBigDecimalMap = longBigDecimalMapFuture.get();
//        } catch (InterruptedException | ExecutionException e) {
//            log.error("小程序商品查询异常:{}", e.getMessage(), e);
//            throw new BusinessException(e.getMessage());
//        }
//
//        Map<String, String> itemType2 = rmiSysUDCService.getCodeMap("yst-supp", "ITEM_TYPE2");
//
//        // 无库存的数据
//        List<AppItmItemPageVO> noAvalQtyList = new ArrayList<>();
//
//        // 有库存的数据
//        List<AppItmItemPageVO> haveAvalQtyList = new ArrayList<>();
//
//        // 过滤数据
//        for (AppItmItemPageVO item : itemList) {
//            if (preSaleItemCodeList.contains(item.getItemCode())) {
//                item.setPreSaleStatus(true);
//            }
//            // 最小起订量
//            BigDecimal moq = minOrderMap.get(item.getItemId());
//            item.setMoq(moq);
//
//            // 强配限制
//            ScpAllocSettingItemRespVO scpAllocSettingItemRespVO = allocSettingMap.get(item.getItemCode());
//            item.setAllocLimitFlag(scpAllocSettingItemRespVO != null);
//
//            // 设置限购活动
//            Long itemId = item.getItemId();
//            BigDecimal purLimitQty = purLimitMap.get(itemId);
//            BigDecimal useQty = longBigDecimalMap.get(itemId);
//            BigDecimal canUseQty = calculateCanUseQty(purLimitQty, useQty);
//            if (canUseQty != null) {
//                item.setPurLimitQty(canUseQty);
//            }
//
//            // 设置配送类型
//            Optional.ofNullable(itemType2.get(item.getItemType2())).ifPresent(item::setItemType2Name);
//
//
//            // 过滤掉没有价格的数据
//            List<AppItmItemPageVO> details = item.getDetails();
//            if (CollUtil.isNotEmpty(details)) {
//                details.removeIf(detail -> detail.getPrice() == null);
//            }
//            if (details == null || details.isEmpty()) {
//                continue;
//            }
//
//            AtomicReference<BigDecimal> avalQty = new AtomicReference<>(null);
//            List<AppItmItemPageVO> collect = details.stream().peek(detail -> {
//                // 最小起订量
//                detail.setMoq(moq);
//                // 强配限制
//                item.setAllocLimitFlag(scpAllocSettingItemRespVO != null);
//                // 设置限购活动
//                if (canUseQty != null) {
//                    detail.setPurLimitQty(canUseQty);
//                }
//                // 预售商品
//                if (preSaleItemCodeList.contains(item.getItemCode())) {
//                    detail.setPreSaleStatus(true);
//                }
//                // 设置配送类型
//                Optional.ofNullable(itemType2.get(detail.getItemType2())).ifPresent(detail::setItemType2Name);
//
//                // 设置第一个非空库存值
//                if (detail.getAvalQty() != null && avalQty.get() == null) {
//                    avalQty.set(detail.getAvalQty());
//                }
//            }).toList();
//            item.setAvalQty(avalQty.get());
//            item.setDetails(collect);
//
//            // 不是直送并且没库存的数据
//            if (!ScpConstant.PUR_TRN_DELIVERY_TYPES.contains(item.getItemType2()) && Objects.equals(item.getAvalQty(), BigDecimal.ZERO)) {
//                noAvalQtyList.add(item);
//            } else {
//                haveAvalQtyList.add(item);
//            }
//        }
//
//        // 排序，没库存的放最后
//        List<AppItmItemPageVO> processedItems = haveAvalQtyList.stream()
//                .filter(Objects::nonNull) // 过滤掉null对象
//                .sorted(Comparator.comparing(AppItmItemPageVO::getAvalQty,
//                        Comparator.nullsLast(Comparator.reverseOrder())))
//                .collect(Collectors.toList());
//        if (CollUtil.isNotEmpty(noAvalQtyList)) {
//            processedItems.addAll(noAvalQtyList.stream().filter(Objects::nonNull).toList());
//        }
//
//        return new PagingVO<>(count, processedItems);
//    }


    private BigDecimal calculateCanUseQty(BigDecimal purLimitQty, BigDecimal useQty) {
        if (purLimitQty != null) {
            BigDecimal subtract = purLimitQty.subtract(useQty == null ? BigDecimal.ZERO : useQty);
            return BigDecimal.ZERO.compareTo(subtract) >= 0 ? BigDecimal.ZERO : subtract;
        }
        return null;
    }

    private List<AppItmItemPageVO> setStoreDemandCalendar(AppItemPageParamVO paramVO, List<AppItmItemPageVO> itemList, String scpManType) {
        // 订货日历筛选 只有店员和店长会被限制
        List<AppItmItemPageVO> result = new ArrayList<>();
        String invisibleAccount = SysUtils.getInvisibleAccount();
        if (StrUtil.isNotBlank(scpManType) && StrUtil.isNotBlank(invisibleAccount)) {
            List<String> invisibleAccountList = Arrays.stream(invisibleAccount.split(",")).collect(Collectors.toList());
            log.info("不可见账号:{},当前账号:{}", JSONUtil.toJsonStr(invisibleAccountList), scpManType);
            // 当前用户的订货账号类型是否包含在配置里
            if (invisibleAccountList.contains(scpManType)) {
                // 订货日历筛选
                Map<String, List<AppItmItemPageVO>> deliveryTypeAndItemMap = itemList.stream().collect(Collectors.groupingBy(AppItmItemPageVO::getItemType2));
                Map<String, Boolean> canDeliveryMap = storeDemandCalendarDomainService.isCanDelivery(paramVO.getStoreCode(), null, new ArrayList<>(deliveryTypeAndItemMap.keySet()));
                log.info("小程序可配送商品的配送类型:{}", JSONUtil.toJsonStr(canDeliveryMap));
                for (Map.Entry<String, List<AppItmItemPageVO>> entry : deliveryTypeAndItemMap.entrySet()) {
                    String deliveryType = entry.getKey();
                    List<AppItmItemPageVO> itemList1 = entry.getValue();
                    if (canDeliveryMap.get(deliveryType) == null || canDeliveryMap.get(deliveryType)) {
                        result.addAll(itemList1);
                    }
                }
            } else {
                result = itemList;
            }
        } else {
            result = itemList;
        }
        return result;
    }

    /**
     * 获取可用商品,通过可售，可见，上下架配置过滤
     *
     * @param paramVO
     * @param itemCodeList
     * @return
     */
    private List<String> getUsefulItemCodeList(AppItemPageParamVO paramVO, List<String> itemCodeList, String scpManType) {
        List<String> usefulItemCodeList;
        String invisibleAccount = SysUtils.getInvisibleAccount();
        if (StrUtil.isNotBlank(scpManType) && StrUtil.isNotBlank(invisibleAccount)) {
            // 不可见账号
            List<String> invisibleAccountList = Arrays.stream(invisibleAccount.split(",")).collect(Collectors.toList());
            log.info("不可见账号:{},当前账号:{}", JSONUtil.toJsonStr(invisibleAccountList), scpManType);
            // 当前用户的订货账号类型是否包含在配置里
            if (invisibleAccountList.contains(scpManType)) {
                // 需要过滤可见设置,看不见配置可见的数据
                usefulItemCodeList = scpCateItemService.getVisibleAndSaleAndUpItemList(itemCodeList, paramVO.getStoreCode());
            } else {
                // 不需要过滤可见
                usefulItemCodeList = scpCateItemService.getSaleAndUpItemList(itemCodeList, paramVO.getStoreCode());
            }
        } else {
            // 不需要过滤可见
            usefulItemCodeList = scpCateItemService.getSaleAndUpItemList(itemCodeList, paramVO.getStoreCode());
        }
        log.info("小程序可售可见上下架商品{}", JSONUtil.toJsonStr(usefulItemCodeList));
        return usefulItemCodeList;
    }

    @Override
    public PagingVO<AppItmItemPageVO> commonItemPage(CommonItemPageParamVO paramVO) {
        if (StrUtil.isBlank(paramVO.getBrand())) {
            return new PagingVO<>();
        }
        Long count = scpCateItemRepoProc.countCommonItemSpu(paramVO);
        if (count == 0) {
            return new PagingVO<>();
        }
        List<AppItmItemPageVO> itemList = scpCateItemRepoProc.pageCommonItemSpu(paramVO);
        // 商品信息查询,图片信息，同SPU下其他SKU信息
        this.itemMessageImageAndDetailsQuery(itemList, null, null, null);
        return new PagingVO<>(count, itemList);
    }

    /**
     * 商品价格查询
     *
     * @param businessType 业务类型
     * @param itemList     商品列表
     * @param storeCode    门店编码
     * @param type         类型
     */
    @Override
    public void getPriceAndStock(String businessType, List<AppItmItemPageVO> itemList, String storeCode, String type) {
        processPriceAndStock(businessType, itemList, storeCode, type, null, false);
    }

    @Override
    public void getPurPriceAndStock(String businessType, List<AppItmItemPageVO> itemList, String storeCode, String type, AddressParamVO addressParam) {
        processPriceAndStock(businessType, itemList, storeCode, type, addressParam, true);
    }

    /**
     * 统一处理商品价格和库存查询
     *
     * @param businessType 业务类型
     * @param itemList     商品列表
     * @param storeCode    门店编码
     * @param type         类型
     * @param addressParam 地址参数（用于采购价格查询）
     * @param isPurPrice   是否为采购价格查询
     */
    private void processPriceAndStock(String businessType, List<AppItmItemPageVO> itemList, String storeCode,
                                      String type, AddressParamVO addressParam, boolean isPurPrice) {
        // 构建价格查询参数
        List<AppItemActivityItemPriceParamVO> priceParams = buildPriceParams(itemList, storeCode);

        // 查询库存信息
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<>(new HashMap<>());

        // 获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByBusinessType(businessType, type);

        log.info("小程序上架的商品{}", JSONUtil.toJsonStr(priceParams));

        // 根据是否采购价格调用不同方法获取价格和库存
        Map<String, AppItemPriceRespVO> priceMap;
        if (isPurPrice) {
            priceMap = commonPriceService.getPurPriceAndStockDetails(priceParams, storeCode, orderSetting, type, stockMapRef,addressParam);
        } else {
            priceMap = commonPriceService.getNewPriceAndStockDetails(priceParams, storeCode, orderSetting, type, stockMapRef);
        }

        Map<String, BigDecimal> stockMap = stockMapRef.get();
        log.info("小程序上架商品库存{}", JSONUtil.toJsonStr(stockMap));

        // 设置商品价格和库存信息
        setItemPriceAndStock(itemList, priceMap, stockMap);
    }

    /**
     * 构建价格查询参数
     *
     * @param itemList     商品列表
     * @param storeCode    门店编码
     * @param addressParam 地址参数
     * @return 价格查询参数列表
     */
    private List<AppItemActivityItemPriceParamVO> buildPriceParams(List<AppItmItemPageVO> itemList,
                                                                   String storeCode) {
        List<AppItemActivityItemPriceParamVO> priceParams = new ArrayList<>();

        for (AppItmItemPageVO item : itemList) {
            List<AppItmItemPageVO> details = item.getDetails();
            if (CollUtil.isEmpty(details)) {
                continue;
            }

            for (AppItmItemPageVO detail : details) {
                AppItemActivityItemPriceParamVO param = new AppItemActivityItemPriceParamVO();
                param.setStoreCode(storeCode);
                param.setItemCode(detail.getItemCode());
                param.setItemCateCode(detail.getItemCateCode());
                param.setUom(detail.getUom());
                param.setDeliveryType(detail.getItemType2());
                param.setItemId(detail.getItemId());
                param.setItemType2(detail.getItemType2());
                param.setCombineItemFlag(detail.getCombineItemFlag());
                param.setCombineItemCode(detail.getCombineItemCode());
                param.setActivityCode(detail.getActivityCode());

                priceParams.add(param);
            }
        }

        return priceParams;
    }

    /**
     * 设置商品价格和库存信息
     *
     * @param itemList   商品列表
     * @param priceMap   价格映射
     * @param stockMap   库存映射
     */
    private void setItemPriceAndStock(List<AppItmItemPageVO> itemList,
                                      Map<String, AppItemPriceRespVO> priceMap,
                                      Map<String, BigDecimal> stockMap) {
        for (AppItmItemPageVO item : itemList) {
            List<AppItmItemPageVO> details = item.getDetails();
            if (CollUtil.isEmpty(details)) {
                continue;
            }

            for (AppItmItemPageVO detail : details) {
                String itemKey = SysUtils.getItemKey(detail.getCombineItemCode(), detail.getItemCode());
                AppItemPriceRespVO priceResp = priceMap.get(itemKey);

                // 处理组合商品
                if (detail.getCombineItemFlag()) {
                    detail.setPrice(detail.getPrice());
                    detail.setSalePrice(detail.getPrice());
                    detail.setPurPrice(detail.getPurPrice());
                    detail.setCostPrice(detail.getPrice());
                }

                // 设置价格信息
                if (priceResp != null) {
                    detail.setPrice(priceResp.getPrice());
                    detail.setSuppId(priceResp.getSuppId());
                    detail.setSuppCode(priceResp.getSuppCode());
                    detail.setSuppName(priceResp.getSuppName());
                    detail.setCostPrice(priceResp.getCostPrice());
                    detail.setPurPrice(priceResp.getPurPrice());
                    detail.setIsProjFeeCharged(priceResp.getIsProjFeeCharged());
                    detail.setOefPrice(priceResp.getOefPrice());
                    detail.setMefPrice(priceResp.getMefPrice());
                    detail.setTefPrice(priceResp.getTefPrice());
                    detail.setSalePrice(priceResp.getSalePrice());
                    detail.setTefFeeOuCode(priceResp.getTefFeeOuCode());
                    detail.setTefFeeOuName(priceResp.getTefFeeOuName());
                    detail.setOefFeeOuCode(priceResp.getOefFeeOuCode());
                    detail.setOefFeeOuName(priceResp.getOefFeeOuName());
                    detail.setMefFeeOuCode(priceResp.getMefFeeOuCode());
                    detail.setMefFeeOuName(priceResp.getMefFeeOuName());
                }

                // 设置库存信息
                BigDecimal stockQty = stockMap.get(detail.getItemCode());
                detail.setAvalQty(stockQty != null ? stockQty : BigDecimal.ZERO);
            }
        }
    }

    private static List<AppItmItemPageVO> mergeObjectsAndDetails(List<AppItmItemPageVO> outerList) {
        List<AppItmItemPageVO> mergedList = new ArrayList<>();

        for (AppItmItemPageVO outerObject : outerList) {
            // 添加外部对象到合并列表
            mergedList.add(outerObject);

            // 获取并遍历当前外部对象的 detail 列表
            List<AppItmItemPageVO> detailList = outerObject.getDetails();
            if (detailList != null) {
                for (AppItmItemPageVO detailObject : detailList) {
                    // 将 detail 列表中的每个对象添加到合并列表
                    mergedList.add(detailObject);
                }
            }
        }
        return mergedList;
    }

    @Override
    public AppItmSpuRespVO findIdOne(AppItemSpecParamVO paramVO) {
        ScpStoreItemParamVO scpStoreItemParamVO = new ScpStoreItemParamVO();
        scpStoreItemParamVO.setSpuId(paramVO.getSpuId());
        scpStoreItemParamVO.setOuCode(paramVO.getOuCode());
        List<ScpStoreItemDO> itemDOS = scpCacheService.getItem(scpStoreItemParamVO);
        if (CollUtil.isEmpty(itemDOS)) {
            throw new BusinessException("未查询到商品");
        }
        // 商品SKU图片
        List<ItmItemAttachmentRpcDTO> skuAttachmentList = itemDOS.stream().filter(row -> CollUtil.isNotEmpty(row.getSkuAttachmentList())).flatMap(item -> item.getSkuAttachmentList().stream()).collect(Collectors.toList());
        AppItmSpuRespVO appItmSpuRespVO = ScpStoreItemConvert.INSTANCE.doToRespVo(itemDOS.get(0));
        appItmSpuRespVO.setSkuAttchmentList(skuAttachmentList);
        appItmSpuRespVO.setSpuAttchmentList(itemDOS.get(0).getSpuAttachmentList());
        // 获取当前登录人信息
        Long currentUserId = UserService.currentUserId();
        appItmSpuRespVO.setCollectFlag(collectRedisUtil.existsSpuInUser(paramVO.getStoreCode(), currentUserId, paramVO.getItemCode()));
        return appItmSpuRespVO;
    }

    @Override
    public AppItemSpecRespVO specQuery(AppItemSpecParamVO paramVO) {
        ScpStoreItemParamVO scpStoreItemParamVO = new ScpStoreItemParamVO();
        scpStoreItemParamVO.setSpuId(paramVO.getSpuId());
        scpStoreItemParamVO.setOuCode(paramVO.getOuCode());
        List<ScpStoreItemDO> itemDOS = scpCacheService.getItem(scpStoreItemParamVO);
        if (CollUtil.isEmpty(itemDOS)) {
            throw new BusinessException("未查询到商品");
        }
        //商品价格查询
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByBusinessType(paramVO.getBusinessType(),
                ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List<AppItemActivityItemPriceParamVO> priceParamVOS = itemDOS.stream().map(row -> {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(row.getItemCode());
            priceParamVO.setItemId(row.getItemId());
            priceParamVO.setItemCateCode(row.getItemCateCode());
            priceParamVO.setUom(row.getUom());
            priceParamVO.setItemType2(row.getItemType2());
            return priceParamVO;
        }).collect(Collectors.toList());
        Long currentUserId = UserService.currentUserId();
        Map<String, AppItemPriceRespVO> priceMap = commonPriceService.getNewPriceAndStockDetails(priceParamVOS, paramVO.getStoreCode(), orderSetting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        List<AppItmSkuRespVO> skuRespVOList = itemDOS.stream().map(row -> {
            AppItmSkuRespVO appItmSkuRespVO = ScpStoreItemConvert.INSTANCE.doToSkuRespVo(row);
            AppItemPriceRespVO priceRespVO = priceMap.get(row.getItemCode());
            if (priceRespVO != null) {
                appItmSkuRespVO.setPrice(priceRespVO.getPrice());
                appItmSkuRespVO.setSuppId(priceRespVO.getSuppId());
                appItmSkuRespVO.setSuppCode(priceRespVO.getSuppCode());
                appItmSkuRespVO.setStoreCode(priceRespVO.getStoreCode());
                appItmSkuRespVO.setCostPrice(priceRespVO.getCostPrice());
                appItmSkuRespVO.setPurPrice(priceRespVO.getPurPrice());
                appItmSkuRespVO.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
                appItmSkuRespVO.setTefPrice(priceRespVO.getTefPrice());
                appItmSkuRespVO.setMefPrice(priceRespVO.getMefPrice());
                appItmSkuRespVO.setOefPrice(priceRespVO.getOefPrice());
                appItmSkuRespVO.setSalePrice(priceRespVO.getSalePrice());
                appItmSkuRespVO.setTefFeeOuCode(priceRespVO.getTefFeeOuCode());
                appItmSkuRespVO.setTefFeeOuName(priceRespVO.getTefFeeOuName());
                appItmSkuRespVO.setOefFeeOuCode(priceRespVO.getOefFeeOuCode());
                appItmSkuRespVO.setOefFeeOuName(priceRespVO.getOefFeeOuName());
                appItmSkuRespVO.setMefFeeOuCode(priceRespVO.getMefFeeOuCode());
                appItmSkuRespVO.setMefFeeOuName(priceRespVO.getMefFeeOuName());
            }
            ScpStoreCartDO storeCartItem = cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(null, row.getItemCode()), paramVO.getStoreCode(), paramVO.getDocType(), currentUserId);
            if (storeCartItem != null) {
                appItmSkuRespVO.setQty(storeCartItem.getQty());
            } else {
                appItmSkuRespVO.setQty(BigDecimal.ZERO);
            }
            return appItmSkuRespVO;
        }).collect(Collectors.toList());
        //封装返回
        AppItemSpecRespVO result = new AppItemSpecRespVO();
        //获取skuRespVOList 最大价格和最小价格
        result.setMaxPrice(skuRespVOList.stream().map(AppItmSkuRespVO::getPrice).filter(Objects::nonNull).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO));
        result.setMinPrice(skuRespVOList.stream().map(AppItmSkuRespVO::getPrice).filter(Objects::nonNull).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO));
        result.setSkuRespVOList(skuRespVOList);
        return result;
    }

    /**
     * 商品信息查询,图片信息，同SPU下其他SKU信息
     *
     * @param collect
     */
    @Override
    public void itemMessageImageAndDetailsQuery(List<AppItmItemPageVO> collect, String storeCode, String cartType, String ouCode) {
        Long currentUserId = UserService.currentUserId();
        List<Long> spuIdList = new ArrayList<>();
        Map<String, String> itemCodeAndItemType2Map = new HashMap<>();
        for (AppItmItemPageVO appItmItemPageVO : collect) {
            Optional.ofNullable(appItmItemPageVO.getSpuId()).ifPresent(spuIdList::add);
            itemCodeAndItemType2Map.put(appItmItemPageVO.getItemCode(), appItmItemPageVO.getItemType2());
        }
        List<String> itemCodeList = scpCateItemRepoProc.pageItemCodesByParam(spuIdList);
        //查询采购车商品信息
        ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
        param.setItemCodes(itemCodeList);
        param.setBusinessBuCode(ouCode);
        List<ItmItemScpBaseRpcDTO> itemRpcDtoByParam = rmiItemService.findItemScpBaseRpcDtoByParam(param);
        Map<Long, List<ItmItemScpBaseRpcDTO>> groupData =
                itemRpcDtoByParam.stream().collect(Collectors.groupingBy(ItmItemScpBaseRpcDTO::getSpuId));

        //减少遍历次数和查找逻辑，以提高性能
        Iterator<AppItmItemPageVO> iterator = collect.iterator();
        while (iterator.hasNext()) {
            AppItmItemPageVO t = iterator.next();
            List<ItmItemScpBaseRpcDTO> itemScpBaseRpcDTOS = groupData.get(t.getSpuId());
            ItmItemScpBaseRpcDTO itmItemRpcDTO = itemScpBaseRpcDTOS.get(0);
            String itemStatus2 = itmItemRpcDTO.getItemStatus2();

            // 如果状态为禁用，则从集合中删除此元素
            if ("DISABLE".equals(itemStatus2)) {
                iterator.remove(); // 使用迭代器安全删除
                continue; // 跳过后续处理
            }

            t.setItemName(itmItemRpcDTO.getItemName());
            t.setUom(itmItemRpcDTO.getUom2());
            t.setUomName(itmItemRpcDTO.getUom2Name());
            t.setItemType(itmItemRpcDTO.getItemType());
            t.setItemTypeName(itmItemRpcDTO.getItemTypeName());
            if (t.getItemType2() == null) {
                t.setItemType2(itmItemRpcDTO.getItemType2());
                t.setItemType2Name(itmItemRpcDTO.getItemType2Name());
            }
            t.setBrand(itmItemRpcDTO.getBrand());
            t.setBrandName(itmItemRpcDTO.getBrandName());
            t.setItemAttr2(itmItemRpcDTO.getItemAttr2());
            t.setSpec(itmItemRpcDTO.getSpec());
            t.setItemCateCode(itmItemRpcDTO.getItemCateCode());
            t.setItemCateName(itmItemRpcDTO.getItemCateFullName());
            t.setSpuId(itmItemRpcDTO.getSpuId());
            t.setSpuCode(itmItemRpcDTO.getSpuCode());
            t.setSpuName(itmItemRpcDTO.getSpuName());
            t.setUom2(itmItemRpcDTO.getUom());
            t.setUom2Name(itmItemRpcDTO.getUomName());
            t.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
            t.setUomRatio(itmItemRpcDTO.getUomRatio2());
            t.setItemAttrName(StrUtil.isBlank(itmItemRpcDTO.getItemAttrName()) ? itmItemRpcDTO.getSpec() : itmItemRpcDTO.getItemAttrName());
            t.setAnotherName(itmItemRpcDTO.getAnotherName());
            t.setReceiveUom(itmItemRpcDTO.getReceiveUom());
            t.setReceiveUomRatio(itmItemRpcDTO.getReceiveUomRatio());
            t.setReceiveUomName(itmItemRpcDTO.getReceiveUomName());
            //图片信息
            t.setItemImageList(AppItmItemConvert.INSTANCE.attachmentRpcDtoToProviderDtoList(itmItemRpcDTO.getSpuAttchmentList()));
            //设置同一个SPU下其他SKU信息
            t.setDetails(getDetails(CollectionUtils.isNotEmpty(itmItemRpcDTO.getSubItems()) ? itmItemRpcDTO.getSubItems() : itemScpBaseRpcDTOS,
                    storeCode,
                    cartType,
                    currentUserId,
                    itmItemRpcDTO,
                    itemCodeAndItemType2Map));
            t.setCombineItemFlag(CollectionUtils.isNotEmpty(itmItemRpcDTO.getSubItems()));
            if (Boolean.TRUE.equals(t.getCombineItemFlag())) {
                AppItmItemPageVO subItem = t.getDetails().get(0);
                if (subItem.getQty() != null && subItem.getCombineQty() != null) {
                    t.setQty(subItem.getQty().divide(subItem.getCombineQty(), 2, RoundingMode.HALF_UP));
                }
                t.setCollectFlag(collectRedisUtil.existsSkuInUser(storeCode, currentUserId, SysUtils.getItemKey(subItem.getCombineItemCode(), subItem.getItemCode()), subItem.getItemId()));
            } else {
                t.setCollectFlag(collectRedisUtil.existsSkuInUser(storeCode, currentUserId, SysUtils.getItemKey(t.getCombineItemCode(), t.getItemCode()), t.getItemId()));
            }
        }
    }

    @SysCodeProc
    private List<AppItmItemPageVO> getDetails(List<ItmItemScpBaseRpcDTO> source,
                                              String storeCode,
                                              String cartType,
                                              Long currentUserId,
                                              ItmItemScpBaseRpcDTO parentItem,
                                              Map<String, String> itemCodeAndItemType2Map) {
        return source.stream().map(
                itmItemRpcDTO -> {
                    AppItmItemPageVO t = new AppItmItemPageVO();
                    t.setItemName(itmItemRpcDTO.getItemName());
                    t.setUom(itmItemRpcDTO.getUom2());
                    t.setUomName(itmItemRpcDTO.getUom2Name());
                    t.setItemType(itmItemRpcDTO.getItemType());
                    t.setItemTypeName(itmItemRpcDTO.getItemTypeName());
                    String s = itemCodeAndItemType2Map.get(itmItemRpcDTO.getItemCode());
                    if (s != null) {
                        t.setItemType2(s);
                    } else {
                        t.setItemType2(itmItemRpcDTO.getItemType2());
                        t.setItemType2Name(itmItemRpcDTO.getItemType2Name());
                    }
                    t.setBrand(itmItemRpcDTO.getBrand());
                    t.setBrandName(itmItemRpcDTO.getBrandName());
                    t.setItemAttr2(itmItemRpcDTO.getItemAttr2());
                    t.setSpec(itmItemRpcDTO.getSpec());
                    t.setItemCateCode(itmItemRpcDTO.getItemCateCode());
                    t.setItemCateName(itmItemRpcDTO.getItemCateFullName());
                    t.setSpuId(itmItemRpcDTO.getSpuId());
                    t.setSpuCode(itmItemRpcDTO.getSpuCode());
                    t.setSpuName(itmItemRpcDTO.getSpuName());
                    if (StrUtil.isNotBlank(cartType)) {
                        ScpStoreCartDO storeCartItem;
                        if (itmItemRpcDTO.getBomPid() != null) {
                            storeCartItem = cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(parentItem.getItemCode(), itmItemRpcDTO.getItemCode()), storeCode, cartType, currentUserId);
                        } else {
                            storeCartItem = cartRedisUtil.getStoreCartItem(itmItemRpcDTO.getItemCode(), storeCode, cartType, currentUserId);
                        }
                        if (storeCartItem != null) {
                            t.setQty(storeCartItem.getQty());
                        } else {
                            t.setQty(BigDecimal.ZERO);
                        }
                    }
                    t.setItemAttrName(StrUtil.isBlank(itmItemRpcDTO.getItemAttrName()) ? itmItemRpcDTO.getSpec() : itmItemRpcDTO.getItemAttrName());
                    t.setAnotherName(itmItemRpcDTO.getAnotherName());
                    //图片信息
                    t.setItemImageList(AppItmItemConvert.INSTANCE.attachmentRpcDtoToProviderDtoList(itmItemRpcDTO.getSpuAttchmentList()));
                    t.setItemId(itmItemRpcDTO.getId());
                    t.setItemCode(itmItemRpcDTO.getItemCode());
                    t.setUom2(itmItemRpcDTO.getUom());
                    t.setUom2Name(itmItemRpcDTO.getUomName());
                    t.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
                    t.setUomRatio(itmItemRpcDTO.getUomRatio2());
                    t.setReceiveUom(itmItemRpcDTO.getReceiveUom());
                    t.setReceiveUomRatio(itmItemRpcDTO.getReceiveUomRatio());
                    t.setReceiveUomName(itmItemRpcDTO.getReceiveUomName());
                    t.setMoq(itmItemRpcDTO.getMoq());
                    t.setPrice(itmItemRpcDTO.getPrice());
                    t.setCombineQty(itmItemRpcDTO.getBomQty());
                    if (itmItemRpcDTO.getBomPid() != null) {
                        t.setCombineItemFlag(Boolean.TRUE);
                        t.setCombineItemCode(parentItem.getItemCode());
                        t.setCombineItemName(parentItem.getItemName());
                    } else {
                        t.setCombineItemFlag(Boolean.FALSE);
                    }
                    return t;
                }
        ).collect(Collectors.toList());
    }

}
