package com.elitesland.scp.application.service.cart;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.threadpool.ThreadPoolAutoConfiguration;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcDTO;
import com.elitesland.inv.dto.invstk.InvWhItemTotalStkRpcParam;
import com.elitesland.inv.enums.InvDeter2TypeEnum;
import com.elitesland.sale.api.vo.resp.MktDiscountGiftRpcBatchParam;
import com.elitesland.sale.api.vo.resp.crm.GiftRpcDTO;
import com.elitesland.sale.api.vo.resp.crm.MktDiscountGiftRpcDTO;
import com.elitesland.sale.service.MktDiscountGiftRpcService;
import com.elitesland.scp.application.facade.vo.cart.*;
import com.elitesland.scp.application.facade.vo.param.app.AddressParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderParamVO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandSetParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItmItemPageVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandSetSelectRespVO;
import com.elitesland.scp.application.facade.vo.resp.purLimit.ScpPurLimitSettingItemRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSubmitVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSubmitVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.app.AppDemandOrderService;
import com.elitesland.scp.application.service.app.AppItemActivityService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.order.ScpDemandOrderService;
import com.elitesland.scp.application.service.order.ScpDemandOrderSetService;
import com.elitesland.scp.application.service.serviceconfig.ScpServiceConfigService;
import com.elitesland.scp.application.service.supalloc.ScpSupplyAllocationService;
import com.elitesland.scp.application.service.whnet.ScpWhNetRelationService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.authority.AppItmItemConvert;
import com.elitesland.scp.domain.convert.cart.ScpStoreCartConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingItemDomainService;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.domain.service.minOrder.ScpMinOrderSettingItemDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.domain.service.purLimit.ScpPurLimitSettingItemDomainService;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.supalloc.ScpSupplyAllocationRpcDTO;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import com.elitesland.scp.infr.repo.item.ScpCateItemRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepo;
import com.elitesland.scp.rmi.*;
import com.elitesland.scp.utils.BeanUtils;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.CollectRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.*;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import com.elitesland.support.provider.item.param.ItmItemScpBaseRpcParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;
import io.seata.common.util.CollectionUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Auther: ryan.xu
 * @Date: 2024/7/28
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScpStoreCartServiceImpl implements ScpStoreCartService {
    @Autowired
    @Qualifier(ThreadPoolAutoConfiguration.BEAN_NAME)
    private TaskExecutor taskExecutor;
    private final CartRedisUtil cartRedisUtil;
    private final CollectRedisUtil collectRedisUtil;
    private final RmiItemService rmiItemService;
    private final RmiPriceRpcService rmiPriceRpcService;
    private final ScpSupplyAllocationService scpSupplyAllocationService;
    private final ScpWhNetRelationService scpWhNetRelationService;
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final CommonPriceService commonPriceService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final RmiInvStkRpcService rmiInvStkRpcService;
    private final ScpAllocSettingItemDomainService scpAllocSettingItemDomainService;
    private final ScpPurLimitSettingItemDomainService scpPurLimitSettingItemDomainService;
    private final ScpDemandOrderSetService scpDemandOrderSetService;
//    private final AppDemandOrderService appDemandOrderService;
    private final ScpDemandOrderService scpDemandOrderService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final MktDiscountGiftRpcService  mktDiscountGiftRpcService;
    private final ItmItemRpcService itmItemRpcService;
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpServiceConfigService scpServiceConfigService;
    private final RmiSysUDCService rmiSysUDCService;
    private final AppItemActivityService appItemActivityService;
    private final ScpStoreDemandCalendarDomainService storeDemandCalendarDomainService;
    private final ScpCateItemRepoProc scpCateItemRepoProc;
    private final ScpsmanInfoRepo scpsmanInfoRepo;
    private final ScpMinOrderSettingItemDomainService scpMinOrderSettingItemDomainService;




    @Override
    @SysCodeProc
    public List<CartDetailRespVO> detail(CartDetailParamVO paramVO) {
        //门店编码
        String storeCode = paramVO.getDemandWhStCode();
        //购物车类型
        String cartType = paramVO.getCartType();

        //查询当前登录用户
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("当前登录人查询异常");
        }
        Long currentUserId = currentUserDTO.getUserId();

        // 查询订货账号类型
        ScpsmanInfoDO byLoginAccount = scpsmanInfoRepo.findByLoginAccount(currentUserDTO.getDetail().getUsername());
        log.info("当前登录人订货账号:{}", JSONUtil.toJsonStr(byLoginAccount));
        if (byLoginAccount == null) {
            throw new BusinessException("当前登录人订货账号查询异常");
        }
        String scpManType = byLoginAccount.getScpsmanType();

        // 获取购物车信息
        List<ScpStoreCartDO> cartDOS = cartRedisUtil.getStoreCartItems(storeCode, cartType, currentUserId);
        log.info("购物车商品数量：{}", JSON.toJSONString(cartDOS));
        if (CollUtil.isEmpty(cartDOS)) {
            return new ArrayList<>();
        }

        List<Long> itemIdList = cartDOS.stream().map(ScpStoreCartDO::getItemId).distinct().collect(Collectors.toList());
        AppItemPageParamVO appItemPageParamVO = new AppItemPageParamVO();
        appItemPageParamVO.setItemIds(itemIdList);
        appItemPageParamVO.setStoreCode(storeCode);
        List<AppItmItemPageVO> simpleItem = scpCateItemRepoProc.pageAppItemAndWhNetSku(appItemPageParamVO);

        List<Long> notExistItemId = new ArrayList<>();
        if (CollUtil.isNotEmpty(simpleItem)) {
            List<Long> existItemIdList = simpleItem.stream().map(AppItmItemPageVO::getItemId).toList();
            for (Long itemId : itemIdList) {
                if (!existItemIdList.contains(itemId)) {
                    notExistItemId.add(itemId);
                }
            }
        } else{
            notExistItemId.addAll(itemIdList);
        }
        if (CollUtil.isNotEmpty(notExistItemId)) {
            List<ItmItemSimpleRpcDTO> simpleItem2 = itmItemRpcService.findSimpleItem(notExistItemId);
            if (CollUtil.isNotEmpty(simpleItem2)) {
                List<AppItmItemPageVO> notExistItemList = simpleItem2.stream().map(itmItemSimpleRpcDTO -> {
                    AppItmItemPageVO appItmItemPageVO = new AppItmItemPageVO();
                    appItmItemPageVO.setItemId(itmItemSimpleRpcDTO.getId());
                    appItmItemPageVO.setItemCode(itmItemSimpleRpcDTO.getItemCode());
                    appItmItemPageVO.setItemType2(itmItemSimpleRpcDTO.getItemType2());
                    return appItmItemPageVO;
                }).toList();
                simpleItem.addAll(notExistItemList);
            }
        }

        Map<Long, AppItmItemPageVO> simpleItemMap = simpleItem.stream().collect(Collectors.toMap(AppItmItemPageVO::getItemId, Function.identity(), (old, item) -> item));

        //获取业务类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByBusinessType(cartType, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());

        List<AppItmItemPageVO> originItemList = new ArrayList<>();
        List<AppItemActivityItemPriceParamVO> priceParamVOS = new ArrayList<>();
        for (ScpStoreCartDO cartDO : cartDOS) {
            AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
            priceParamVO.setItemCode(cartDO.getItemCode());
            priceParamVO.setItemId(cartDO.getItemId());
            priceParamVO.setItemCateCode(cartDO.getItemCateCode());
            priceParamVO.setUom(cartDO.getUom());
            priceParamVO.setCombineItemCode(cartDO.getCombineItemCode());
            priceParamVO.setCombineItemFlag(cartDO.getCombineItemFlag());
            priceParamVO.setItemType2(simpleItemMap.get(cartDO.getItemId()).getItemType2());
            priceParamVO.setActivityCode(cartDO.getActivityCode());
            priceParamVOS.add(priceParamVO);

            AppItmItemPageVO item = new AppItmItemPageVO();
            item.setItemId(cartDO.getItemId());
            item.setItemCode(cartDO.getItemCode());
            item.setItemType2(simpleItemMap.get(cartDO.getItemId()).getItemType2());
            originItemList.add(item);
        }

        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<>(new HashMap<>());
        Map<String, AppItemPriceRespVO> priceMap = new HashMap<>();
        if (CollectionUtil.isNotEmpty(priceParamVOS)) {
            if (ScpUdcEnum.BUSINESS_TYPE_50.getValueCode().equals(paramVO.getCartType())){
                AddressParamVO addressParam = paramVO.getAddressParam();
                if (addressParam == null) {
                    addressParam = cartRedisUtil.getAddr();
                }
                priceMap = commonPriceService.getPurPriceAndStockDetails(priceParamVOS, storeCode, orderSetting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), stockMapRef, addressParam);
            }else {
                priceMap = commonPriceService.getNewPriceAndStockDetails(priceParamVOS, storeCode, orderSetting, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), stockMapRef);
            }
        }

        // 配送类型
        Map<String, String> itemType2 = rmiSysUDCService.getCodeMap("yst-supp", "ITEM_TYPE2");

        // 配送日历限制商品映射获取
        Map<String, Boolean> calendarLimitMap = setStoreDemandCalendarLimit(storeCode, originItemList, scpManType);

        //封装返回
        List<CartDetailRespVO> resultList = new ArrayList<>();
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        Map<String, List<ScpStoreCartDO>> spuMap = cartDOS.stream().collect(Collectors.groupingBy(c -> SysUtils.getItemKey(c.getCombineItemCode(), c.getItemCode(), c.getActivityCode())));
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : spuMap.entrySet()) {
            CartDetailRespVO vo = new CartDetailRespVO();
            List<ScpStoreCartDO> storeCartDOS = entry.getValue();
            // SPU信息赋值
            ScpStoreCartDO storeCartDO = storeCartDOS.get(0);
            vo.setSpuId(storeCartDO.getSpuId());
            vo.setSpuCode(storeCartDO.getSpuCode());
            vo.setSpuName(storeCartDO.getSpuName());
            vo.setSpec(storeCartDO.getSpec());
            vo.setUrl(storeCartDO.getUrl());
            vo.setAnotherName(storeCartDO.getAnotherName());
            vo.setCombineItemCode(storeCartDO.getCombineItemCode());
            vo.setCombineItemName(storeCartDO.getCombineItemName());
            vo.setCombineItemFlag(storeCartDO.getCombineItemFlag());
            vo.setCollectFlag(collectRedisUtil.existsSpuInUser(storeCode, currentUserId, SysUtils.getItemKey(storeCartDO.getCombineItemCode(), storeCartDO.getItemCode())));
            vo.setActivityCode(storeCartDO.getActivityCode());
            vo.setActivityId(storeCartDO.getActivityId());

            // 是否允许打折
            vo.setAllowDiscount(orderSetting.getAllowDiscount());
            // SKU商品信息赋值
            List<CartDetailRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<>();
            for (ScpStoreCartDO scpCartDO : storeCartDOS) {
                CartDetailRespVO.ItemSpecObjectVO detailVo = new CartDetailRespVO.ItemSpecObjectVO();
                detailVo.setUom(scpCartDO.getUom());
                detailVo.setUomName(scpCartDO.getUomName());
                detailVo.setItemId(scpCartDO.getItemId());
                detailVo.setItemCode(scpCartDO.getItemCode());
                detailVo.setItemName(scpCartDO.getItemName());
                detailVo.setItemType2(scpCartDO.getItemType2());
                // 设置配送类型
                Optional.ofNullable(itemType2.get(scpCartDO.getItemType2())).ifPresent(detailVo::setItemType2Name);

                // 门店日历过滤
                Boolean calendarLimit = calendarLimitMap.get(scpCartDO.getItemCode());
                detailVo.setCalendarLimit(calendarLimit != null && calendarLimit);

                // 获取价格
                AppItemPriceRespVO priceRespVO = priceMap.get(SysUtils.getItemKey(scpCartDO.getCombineItemCode(), scpCartDO.getItemCode()));
                if (priceRespVO != null && scpCartDO.getSettlementPrice() == null) {
                    detailVo.setSuppCode(priceRespVO.getSuppCode());
                    detailVo.setSuppName(priceRespVO.getSuppName());
                    detailVo.setSuppId(priceRespVO.getSuppId());
                    detailVo.setItemPrice(priceRespVO.getPrice());
                    detailVo.setPrice(priceRespVO.getPrice());
                    detailVo.setCostPrice(priceRespVO.getCostPrice());
                    detailVo.setPurPrice(priceRespVO.getPurPrice());
                    detailVo.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
                    detailVo.setStoreCode(priceRespVO.getStoreCode());
                    detailVo.setTefPrice(priceRespVO.getTefPrice());
                    detailVo.setMefPrice(priceRespVO.getMefPrice());
                    detailVo.setOefPrice(priceRespVO.getOefPrice());
                    detailVo.setSalePrice(priceRespVO.getSalePrice());
                    detailVo.setTefFeeOuCode(priceRespVO.getTefFeeOuCode());
                    detailVo.setTefFeeOuName(priceRespVO.getTefFeeOuName());
                    detailVo.setMefFeeOuCode(priceRespVO.getMefFeeOuCode());
                    detailVo.setMefFeeOuName(priceRespVO.getMefFeeOuName());
                    detailVo.setOefFeeOuCode(priceRespVO.getOefFeeOuCode());
                    detailVo.setOefFeeOuName(priceRespVO.getOefFeeOuName());
                    vo.setCombineQty(priceRespVO.getCombineQty());
                } else {
                    detailVo.setSuppCode(scpCartDO.getSuppCode());
                    detailVo.setSuppName(scpCartDO.getSuppName());
                    detailVo.setSuppId(scpCartDO.getSuppId());
                    detailVo.setItemPrice(scpCartDO.getPrice());
                    detailVo.setCostPrice(scpCartDO.getCostPrice());
                    detailVo.setPurPrice(scpCartDO.getPurPrice());
                    detailVo.setIsProjFeeCharged(scpCartDO.getIsProjFeeCharged());
                    detailVo.setStoreCode(scpCartDO.getStoreCode());
                    detailVo.setTefPrice(scpCartDO.getTefPrice());
                    detailVo.setMefPrice(scpCartDO.getMefPrice());
                    detailVo.setOefPrice(scpCartDO.getOefPrice());
                    detailVo.setSalePrice(scpCartDO.getSalePrice());
                    detailVo.setSettlementPrice(scpCartDO.getSettlementPrice());
                    detailVo.setSettlementSalePrice(scpCartDO.getSettlementSalePrice());
                    detailVo.setDiscount(scpCartDO.getDiscount());
                    detailVo.setDiscountType(scpCartDO.getDiscountType());
                    detailVo.setDiscountTypeName(scpCartDO.getDiscountTypeName());
                    detailVo.setTefFeeOuCode(scpCartDO.getTefFeeOuCode());
                    detailVo.setTefFeeOuName(scpCartDO.getTefFeeOuName());
                    detailVo.setMefFeeOuCode(scpCartDO.getMefFeeOuCode());
                    detailVo.setMefFeeOuName(scpCartDO.getMefFeeOuName());
                    detailVo.setOefFeeOuCode(scpCartDO.getOefFeeOuCode());
                    detailVo.setOefFeeOuName(scpCartDO.getOefFeeOuName());
                }
                detailVo.setQty(SysUtils.processQtyScale(scpCartDO.getQty()));
                if (calendarLimit != null && calendarLimit) {
                    detailVo.setStatus(0);
                } else {
                    detailVo.setStatus(scpCartDO.getSelectedStatus());
                }
                detailVo.setUom2(scpCartDO.getUom2());
                detailVo.setUom2Name(scpCartDO.getUom2Name());
                detailVo.setDecimalPlaces(scpCartDO.getDecimalPlaces());
                detailVo.setUomRatio(scpCartDO.getUomRatio());
                detailVo.setItemAttrName(scpCartDO.getItemAttrName());
                detailVo.setPreSaleStatus(scpCartDO.getPreSaleStatus());
                // 查询库存信息,获取不到则为0
                detailVo.setAvalQty(stockMap.getOrDefault(scpCartDO.getItemCode(), BigDecimal.ZERO));
                detailVo.setMoq(scpCartDO.getMoq());
                itemSpecObjectVOS.add(detailVo);
            }
            vo.setItemSpecObjectVOS(itemSpecObjectVOS);
            boolean allSelected = itemSpecObjectVOS.stream()
                    .allMatch(item -> item.getStatus() != null && item.getStatus().equals(1));
            vo.setStatus(allSelected ? 1 : 0);
            // 小计金额
            BigDecimal totalAmt = itemSpecObjectVOS.stream().filter(item -> ObjectUtil.isNotNull(item.getItemPrice())).map(CartDetailRespVO.ItemSpecObjectVO::getTotalAmt).filter(Objects::nonNull)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            vo.setTotalAmt(totalAmt);
            resultList.add(vo);
        }
        //刷新购物车信息（价格、是否被门店订货日历限制）
        refreshCartPrice(paramVO, currentUserId, cartDOS, priceMap, calendarLimitMap);

        // 组合商品处理
        List<CartDetailRespVO> itemResultList = resultList.stream().filter(d -> StringUtils.isBlank(d.getCombineItemCode())).collect(Collectors.toList());
        Map<String, List<CartDetailRespVO>> subItemMap = resultList.stream().filter(d -> StringUtils.isNotBlank(d.getCombineItemCode())).collect(Collectors.groupingBy(CartDetailRespVO::getCombineItemCode));
        if (!subItemMap.isEmpty()) {
            subItemMap.forEach((k, v) -> {
                CartDetailRespVO combineOrderDRespVO = new CartDetailRespVO();
                CartDetailRespVO subSpu = v.get(0);
                CartDetailRespVO.ItemSpecObjectVO subItem = subSpu.getItemSpecObjectVOS().get(0);
                combineOrderDRespVO.setCombineItemCode(k);
                combineOrderDRespVO.setCombineItemName(subSpu.getCombineItemName());
                combineOrderDRespVO.setStatus(subSpu.getStatus());
                combineOrderDRespVO.setActivityCode(subSpu.getActivityCode());
                combineOrderDRespVO.setActivityId(subSpu.getActivityId());
                combineOrderDRespVO.setSubItemList(v);
                CartDetailRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartDetailRespVO.ItemSpecObjectVO();
                itemSpecObjectVO.setItemCode(combineOrderDRespVO.getCombineItemCode());
                itemSpecObjectVO.setItemName(combineOrderDRespVO.getCombineItemName());
                if (subSpu.getCombineQty() != null) {
                    itemSpecObjectVO.setQty(subItem.getQty().divide(subSpu.getCombineQty(), 2, RoundingMode.HALF_UP));
                }
                itemSpecObjectVO.setMoq(subItem.getMoq());
                combineOrderDRespVO.setItemSpecObjectVOS(List.of(itemSpecObjectVO));
                itemResultList.add(combineOrderDRespVO);
            });
        }
        if(CollectionUtils.isNotEmpty(itemResultList)){
            List<Long> spuIds = itemResultList.stream().map(CartDetailRespVO::getSpuId)
                    .filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<ItmItemAttachmentProviderDTO> skuImgByItemIds = itmItemRpcService.findSkuImgByItemIds(spuIds);
            if(CollectionUtils.isNotEmpty(skuImgByItemIds)){
                Map<Long, List<ItmItemAttachmentProviderDTO>> listMap = skuImgByItemIds.stream().collect(Collectors.groupingBy(ItmItemAttachmentProviderDTO::getItemId));
                itemResultList.forEach(d -> {
                    if(CollectionUtils.isNotEmpty(listMap.get(d.getSpuId()))){
                        d.setFileCode(listMap.get(d.getSpuId()).get(0).getFileCode());
                    }
                });
            }
        }
        return itemResultList;
    }

    /**
     * 刷新购物车价格
     *
     * @param paramVO
     * @param currentUserId
     * @param cartDOS
     * @param priceMap
     */
    private void refreshCartPrice(CartDetailParamVO paramVO, Long currentUserId, List<ScpStoreCartDO> cartDOS, Map<String, AppItemPriceRespVO> priceMap, Map<String, Boolean> calendarLimitMap) {
        var storeCartOps = cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        for (ScpStoreCartDO cartDO : cartDOS) {
            AppItemPriceRespVO priceRespVO = priceMap.get(SysUtils.getItemKey(cartDO.getCombineItemCode(), cartDO.getItemCode()));
            if (priceRespVO != null) {
                cartDO.setItemPrice(priceRespVO.getPrice());
                cartDO.setStoreCode(priceRespVO.getStoreCode());
                cartDO.setSuppId(priceRespVO.getSuppId());
                cartDO.setSuppCode(priceRespVO.getSuppCode());
                cartDO.setSuppName(priceRespVO.getSuppName());
                cartDO.setCostPrice(priceRespVO.getCostPrice());
                cartDO.setPurPrice(priceRespVO.getPurPrice());
                cartDO.setTefPrice(priceRespVO.getTefPrice());
                cartDO.setOefPrice(priceRespVO.getOefPrice());
                cartDO.setMefPrice(priceRespVO.getMefPrice());
                cartDO.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
            }

            // 门店日历过滤
            Boolean calendarLimit = calendarLimitMap.get(cartDO.getItemCode());
            if (calendarLimit != null && calendarLimit) {
                // 被限制则不可选中
                cartDO.setSelectedStatus(0);
            }
            storeCartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, cartDO.getCombineItemCode(), cartDO.getItemCode(), cartDO.getActivityCode()), JSONUtil.toJsonStr(cartDO));
        }
    }

    @Override
    public Map<String, Integer> getCartCount(StoreCartQueryParamVO param) {
        Map<String, Integer> result = new HashMap<>();
        Long currentUserId = UserService.currentUserId();
        List<ScpOrderSettingRespVO> enabledSettings = scpOrderSettingDomainService.findEnabledSetting();
        for (ScpOrderSettingRespVO setting : enabledSettings) {
            List<ScpStoreCartDO> cartDOS = cartRedisUtil.getStoreCartItems(param.getDemandWhStCode(), setting.getBusinessType(), currentUserId);
            result.put(setting.getBusinessType(), CollUtil.isNotEmpty(cartDOS) ? cartDOS.size() : 0);
        }
        result.values().stream().reduce(Integer::sum).ifPresent(total -> result.put("total", total));
        return result;
    }

    @Override
    public Map<Long, BigDecimal> saveCart(StoreCartSaveVO cartSaveVO) {
        Long currentUserId = UserService.currentUserId();
        // 要操作的购物车信息
        var cartOps = cartRedisUtil.getStoreCartOps(cartSaveVO.getDemandWhStCode(), cartSaveVO.getCartType(), currentUserId);
        saveOrUpdateCart(cartSaveVO, cartOps);
        Map<Long, BigDecimal> result = new HashMap<>();
        result.put(cartSaveVO.getItemId(), cartSaveVO.getQty());
        return result;
    }

    @Override
    public Map<Long, BigDecimal> saveAllocCart(StoreCartAllocSaveVO cartSaveVO) {
        //获取当前用户信息
        Long currentUserId = UserService.currentUserId();

        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByBusinessType(cartSaveVO.getBusinessType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        if (orderSetting == null) {
            throw new BusinessException("请先配置或启用单据类型:" + cartSaveVO.getBusinessType());
        }

        // 要操作的购物车信息
        var cartOps = cartRedisUtil.getStoreCartOps(cartSaveVO.getDemandWhStCode(), cartSaveVO.getCartType(), currentUserId);
        //查询强配商品
        List<ScpStoreCartDO> dataList = new ArrayList<>();

        // 先清楚原来的所有强配
        Set<Object> keys1 = cartOps.keys();
        if (keys1 != null) {
            Set<String> keys = keys1.stream().map(Object::toString).collect(Collectors.toSet());
            List<String> skuKeys = keys.stream().filter(key -> key.endsWith("ALLOC")).toList();
            if (!skuKeys.isEmpty()) {
                cartOps.delete(skuKeys.toArray());
            }
        }
        addAllocSettingItem(currentUserId, cartSaveVO.getDemandWhStCode(), orderSetting, dataList);
        Map<Long, BigDecimal> result = new HashMap<>();
        if (CollUtil.isNotEmpty(dataList)) {
            // 编辑购物车商品
            log.info("添加强配购物车商品:{}", JSONUtil.toJsonStr(dataList));
            for (ScpStoreCartDO storeCartDO : dataList) {
                String redisKey = SysUtils.generateRedisKey(ScpConstant.SKU,
                        storeCartDO.getCombineItemCode(),
                        storeCartDO.getItemCode(),
                        storeCartDO.getActivityCode());
                Object o = cartOps.get(redisKey);
                if (o != null) {
                    log.info("购物车强配已存在该商品:{}", redisKey);
                    continue;
                }
                //添加购物车默认选中
                storeCartDO.setSelectedStatus(1);
                storeCartDO.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                // 购物车保存
                log.info("添加购物车商品的key:{}", redisKey);
                cartOps.put(redisKey, JSON.toJSONString(storeCartDO));
                result.put(storeCartDO.getItemId(), storeCartDO.getQty());
            }
        }
        return result;
    }

    @Override
    public void batchSaveCart(String storeCode, String cartType, List<StoreCartSaveVO> cartSaveVOS) {
        Long currentUserId = UserService.currentUserId();
        // 要操作的购物车信息
        var cartOps = cartRedisUtil.getStoreCartOps(storeCode, cartType, currentUserId);
        cartSaveVOS.forEach(cartSaveVO -> {
            saveOrUpdateCart(cartSaveVO, cartOps);
        });
    }

    @Override
    public void deleteItem(CartDeleteItemParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        for (CartDeleteItemParamVO.ItemSpecObjectVO vo : paramVO.getItemSpecObjectVOS()) {
            for (String itemKey : vo.getItemKeys()) {
                // 清空redis缓存
                var cartOps = cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
                cartOps.delete(SysUtils.generateRedisKey(ScpConstant.SKU, itemKey));
            }
        }
    }

    @Override
    public CartDataSummaryRespVO dataSummary(CartDataSummaryParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();

        List<ScpStoreCartDO> scpCartDOS;
        if (paramVO.getCheckSelectedStatusFlag() == null || paramVO.getCheckSelectedStatusFlag()) {
            scpCartDOS = cartRedisUtil.getCheckedShoppingCartItems(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        } else {
            scpCartDOS = cartRedisUtil.getStoreCartItems(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        }

        if (CollUtil.isEmpty(scpCartDOS)) {
            return new CartDataSummaryRespVO().setItemTypeNum(0).setQtyTotal(BigDecimal.ZERO).setAmtTotal(BigDecimal.ZERO);
        }
        Map<String, List<ScpStoreCartDO>> spuMap =
                scpCartDOS.stream().collect(Collectors.groupingBy(ScpStoreCartDO::getSpuCode));

        CartDataSummaryRespVO resultVo = new CartDataSummaryRespVO();
        resultVo.setItemTypeNum(spuMap.size());
        // 数量
        BigDecimal qty = scpCartDOS.stream()
                .map(ScpStoreCartDO::getQty)
                .filter(Objects::nonNull) // 过滤掉qty为空的数据
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        //金额
        BigDecimal totalAmt = scpCartDOS.stream().filter(v -> v.getItemPrice() != null || v.getSettlementPrice() != null).map(v -> {
                    if (v.getSettlementPrice() != null) {
                        return v.getTotalSettlementAmt();
                    } else {
                        return v.getTotalAmt();
                    }
                }).filter(Objects::nonNull)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        resultVo.setQtyTotal(SysUtils.processQtyScale(qty));
        resultVo.setAmtTotal(SysUtils.processAmtScale(totalAmt));
        return resultVo;
    }

    @Override
    public void changeSelectedStatus(CartChangeSelectedStatusParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        String demandWhStCode = paramVO.getDemandWhStCode();
        for (CartChangeSelectedStatusParamVO.ItemSpecObjectVO vo :
                paramVO.getItemSpecObjectVOS()) {
            for (CartChangeSelectedStatusParamVO.InnerItemSpecObjectVO item :
                    vo.getInnerItemSpecObjectVOS()) {
                if (item.getItemId() == null) {
                    throw new BusinessException("商品ID不能为空");
                }
                //查询购物车里面的商品
                ScpStoreCartDO cartItem = cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode()), demandWhStCode, paramVO.getCartType(), currentUserId);
                if (cartItem == null) {
                    log.error("购物车中不存在此物料：{},请刷新购物车重试", item.getItemId());
                    continue;
                }
                //修改商品选中状态
                cartItem.setSelectedStatus(item.getStatus());
                //序列化存入redis中
                String redisValue = JSON.toJSONString(cartItem);
                var cartOps = cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
                cartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, item.getCombineItemCode(), item.getItemCode()), redisValue);
            }
        }
    }

    private void getPrice(AppItmItemPageVO appItemPriceRespVO, ScpStoreCartDO storeCartDO) {
        if (appItemPriceRespVO != null) {
            storeCartDO.setPrice(appItemPriceRespVO.getPrice());
            storeCartDO.setItemPrice(appItemPriceRespVO.getPrice());
            storeCartDO.setSuppId(appItemPriceRespVO.getSuppId());
            storeCartDO.setSuppCode(appItemPriceRespVO.getSuppCode());
            storeCartDO.setSuppName(appItemPriceRespVO.getSuppName());
            storeCartDO.setCostPrice(appItemPriceRespVO.getCostPrice());
            storeCartDO.setPurPrice(appItemPriceRespVO.getPurPrice());
            storeCartDO.setIsProjFeeCharged(appItemPriceRespVO.getIsProjFeeCharged());
            storeCartDO.setOefPrice(appItemPriceRespVO.getOefPrice());
            storeCartDO.setMefPrice(appItemPriceRespVO.getMefPrice());
            storeCartDO.setTefPrice(appItemPriceRespVO.getTefPrice());
            storeCartDO.setSalePrice(appItemPriceRespVO.getSalePrice());
            storeCartDO.setTefFeeOuCode(appItemPriceRespVO.getTefFeeOuCode());
            storeCartDO.setTefFeeOuName(appItemPriceRespVO.getTefFeeOuName());
            storeCartDO.setOefFeeOuCode(appItemPriceRespVO.getOefFeeOuCode());
            storeCartDO.setOefFeeOuName(appItemPriceRespVO.getOefFeeOuName());
            storeCartDO.setMefFeeOuCode(appItemPriceRespVO.getMefFeeOuCode());
            storeCartDO.setMefFeeOuName(appItemPriceRespVO.getMefFeeOuName());
        }
    }

    @Override
    public void updateCount(CartCountParamVO cartCountParamVO) {
        Long currentUserId = UserService.currentUserId();
        var cartOps = cartRedisUtil.getStoreCartOps(cartCountParamVO.getDemandWhStCode(), cartCountParamVO.getCartType(), currentUserId);
        for (CartCountParamVO.ItemSpecObjectVO vo : cartCountParamVO.getItemSpecObjectVOS()) {
            for (CartCountParamVO.InnerItemSpecObjectVO itemSpecObjectVO : vo.getInnerItemSpecObjectVOS()) {
                if (itemSpecObjectVO.getItemId() == null) {
                    throw new BusinessException("商品ID不能为空");
                }
                // 购物车有此商品，修改数量即可
                String product = (String) cartOps.get(SysUtils.generateRedisKey(ScpConstant.SKU, itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()));
                if (product == null) {
                    log.error("购物车中不存在此物料：{},请刷新购物车重试", itemSpecObjectVO.getItemId());
                    continue;
                }
                // 添加商品数量=0时，删除采购车商品
                if (itemSpecObjectVO.getQty().compareTo(BigDecimal.ZERO) == 0) {
                    cartOps.delete(SysUtils.generateRedisKey(ScpConstant.SKU, itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()));
                } else {
                    var storeCartDO = JSON.parseObject(product, ScpStoreCartDO.class);
                    storeCartDO.setQty(itemSpecObjectVO.getQty());
                    String cartItemJson = JSON.toJSONString(storeCartDO);
                    // 购物车保存
                    cartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()), cartItemJson);
                }
            }
        }
    }

    @Override
    public void updatePrice(CartPriceParamVO cartCountParamVO) {
        Long currentUserId = UserService.currentUserId();
        OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
        baseRpcParam.setStoreCodeList(List.of(cartCountParamVO.getDemandWhStCode()));
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStoreRpcService.findSimpleStoreByParam(baseRpcParam).computeData().get(0);
        Map<String, ScpServiceConfigRespVO> configRespVOMap = null;
        boolean isServiceCharge = false;
        if (Boolean.TRUE.equals(orgStoreBaseRpcDTO.getDeliveryChargeFlag()) || Boolean.TRUE.equals(orgStoreBaseRpcDTO.getWhChargeFlag())) {
            isServiceCharge = true;
            //查询服务费
            configRespVOMap = scpServiceConfigService.findServiceConfigGroupByStore(orgStoreBaseRpcDTO.getStoreCode(),
                    orgStoreBaseRpcDTO.getRegion(), orgStoreBaseRpcDTO.getStoreLevel());
        }

        var cartOps = cartRedisUtil.getStoreCartOps(cartCountParamVO.getDemandWhStCode(), cartCountParamVO.getCartType(), currentUserId);
        for (CartPriceParamVO.ItemSpecObjectVO vo : cartCountParamVO.getItemSpecObjectVOS()) {
            for (CartPriceParamVO.InnerItemSpecObjectVO itemSpecObjectVO : vo.getInnerItemSpecObjectVOS()) {
                if (itemSpecObjectVO.getItemId() == null) {
                    throw new BusinessException("商品ID不能为空");
                }
                if (itemSpecObjectVO.getSettlementPrice() == null) {
                    throw new BusinessException("折后单价不能为空");
                }
                if (itemSpecObjectVO.getPrice() == null) {
                    throw new BusinessException("原单价不能为空");
                }
                if (itemSpecObjectVO.getPrice().subtract(itemSpecObjectVO.getSettlementPrice()).compareTo(BigDecimal.ONE) < 0) {
                    throw new BusinessException("折后单价应低于原单价，且折扣差额需大于1元");
                }

                String product = (String) cartOps.get(SysUtils.generateRedisKey(ScpConstant.SKU, itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()));
                // 购物车是否有此商品
                if (product == null) {
                    log.error("购物车中不存在此物料：{},请刷新购物车重试", itemSpecObjectVO.getItemId());
                    continue;
                }
                var cartItem = JSON.parseObject(product, ScpStoreCartDO.class);

                // 设置结算单价
                cartItem.setSettlementPrice(itemSpecObjectVO.getSettlementPrice());
                // 设置打折方式
                cartItem.setDiscountType(itemSpecObjectVO.getDiscountType());
                cartItem.setDiscountTypeName(itemSpecObjectVO.getDiscountTypeName());
                // 设置折扣比例
                cartItem.setDiscount(itemSpecObjectVO.getDiscount());
                Integer pricePlace = SysUtils.getAppPricePlace();
                // 通过结算价格，计算结算货款价格（货款单价 / 1 + 三个比例）
                if (itemSpecObjectVO.getSettlementPrice().compareTo(itemSpecObjectVO.getPrice()) != 0 && isServiceCharge && configRespVOMap != null) {
                    // 计算改价的商品，重新计算项目费用 settlementPrice
                    if (configRespVOMap.get("TECH") != null) {
                        cartItem.setTefFeeOuCode(configRespVOMap.get("TECH").getOuCode());
                    }
                    if (configRespVOMap.get("MARKET") != null) {
                        cartItem.setMefFeeOuCode(configRespVOMap.get("MARKET").getOuCode());
                    }
                    if (configRespVOMap.get("OPERATE") != null) {
                        cartItem.setOefFeeOuCode(configRespVOMap.get("OPERATE").getOuCode());
                    }

                    //服务费
                    BigDecimal tefRatio = configRespVOMap.get("TECH") == null ? BigDecimal.ZERO : configRespVOMap.get("TECH").getFeePercentage().multiply(new BigDecimal("0.01"));
                    BigDecimal mefRatio = configRespVOMap.get("MARKET") == null ? BigDecimal.ZERO : configRespVOMap.get("MARKET").getFeePercentage().multiply(new BigDecimal("0.01"));
                    BigDecimal oefRatio = configRespVOMap.get("OPERATE") == null ? BigDecimal.ZERO : configRespVOMap.get("OPERATE").getFeePercentage().multiply(new BigDecimal("0.01"));

                    // 结算货款单价
                    BigDecimal settlementSalePrice = itemSpecObjectVO.getSettlementPrice().divide(BigDecimal.ONE.add(tefRatio).add(mefRatio).add(oefRatio), pricePlace, RoundingMode.HALF_UP);
                    cartItem.setSettlementSalePrice(settlementSalePrice);
                    // 重新计算
                    cartItem.setTefPrice(settlementSalePrice.multiply(tefRatio).setScale(pricePlace, RoundingMode.HALF_UP));
                    cartItem.setMefPrice(settlementSalePrice.multiply(mefRatio).setScale(pricePlace, RoundingMode.HALF_UP));
//                            cartItem.setOefPrice(settlementSalePrice.multiply(oefRatio).setScale(2, RoundingMode.HALF_UP));
                    // 通过倒减法，计算运营费
                    cartItem.setOefPrice(cartItem.getSettlementPrice().subtract(cartItem.getSettlementSalePrice()).subtract(cartItem.getTefPrice()).subtract(cartItem.getMefPrice()));
                }

                // 购物车保存
                //序列化存入redis中
                String redisValue = JSON.toJSONString(cartItem);
                cartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, itemSpecObjectVO.getCombineItemCode(), itemSpecObjectVO.getItemCode()), redisValue);
            }
        }
    }

    @Override
    public OrderCheckRespVO order(OrderCheckParamVO paramVO) {
        OrderCheckRespVO resultVO = new OrderCheckRespVO();
        List<CartToOrderSuccessRespVO> successList = new ArrayList<>();
        List<CartToOrderFailRespVO> failList = new ArrayList<>();

        //根据门店+商品去查：
        //1、仓网关系接口，匹配出仓库，则返回前端展示成仓+品；
        //2、如果1找不到的情况下，调供应商配额接口，匹配出供应商，则返回前端展示成供应商+品；
        //3、如果上面1和2都找不到的情况下，后端返回信息说匹配不到仓或供应商，前端要根据后端返回的错误在前端进行商品行的置灰，控制用户下不了单。
        String demandWhStCode = paramVO.getDemandWhStCode();
        OrgStoreBaseRpcDTO orgStore = rmiOrgStoreRpcService.getOrgStoreBase(demandWhStCode);
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByBusinessType(paramVO.getBusinessType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        if (orderSetting == null) {
            throw new BusinessException("请先配置或启用单据类型:" + paramVO.getBusinessType());
        }

        //获取当前用户信息
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> cartDataList = cartRedisUtil.getCheckedShoppingCartItems(paramVO.getDemandWhStCode(), paramVO.getBusinessType(), currentUserId);
        if (CollUtil.isEmpty(cartDataList)) {
            log.info("用户:{},购物车数据为空", currentUserId);
            return new OrderCheckRespVO();
        }

        // 查询订货账号类型
        ScpsmanInfoDO byLoginAccount = scpsmanInfoRepo.findByLoginAccount(currentUserDTO.getDetail().getUsername());
        log.info("当前登录人订货账号:{}", JSONUtil.toJsonStr(byLoginAccount));
        if (byLoginAccount == null) {
            throw new BusinessException("当前登录人订货账号查询异常");
        }
        String scpManType = byLoginAccount.getScpsmanType();

        // 查询是否有强配商品且并且未支付的订单，则不能下单
        // 只有门店自采需要校验
        String allocBusinessType = SysUtils.getAllocBusinessType();
        if (Objects.equals(paramVO.getBusinessType(), allocBusinessType)) {
            List<String> docCodeList = scpDemandOrderRepoProc.countAllocatedOrderByStoreCode(demandWhStCode);
            if (CollUtil.isNotEmpty(docCodeList)) {
                String docCodes = String.join(",", docCodeList);
                log.info("门店:{}存在未支付的强配订单:{}", demandWhStCode, docCodes);
                throw new BusinessException("有未支付强配订单，请先支付");
            }
        }

        List<ScpStoreCartDO> dataList;
        List<ScpStoreCartDO> allocItemList = new ArrayList<>();
        addAllocSettingItem(currentUserId, demandWhStCode, orderSetting, allocItemList);
        Map<String, ScpStoreCartDO> allocSettingMap = new HashMap<>();
        if (CollUtil.isNotEmpty(allocItemList)) {
            // 需要强配

            // 查询门店订货日历
            List<Long> itemIdList = allocItemList.stream().map(ScpStoreCartDO::getItemId).distinct().collect(Collectors.toList());
            AppItemPageParamVO appItemPageParamVO = new AppItemPageParamVO();
            appItemPageParamVO.setItemIds(itemIdList);
            appItemPageParamVO.setStoreCode(paramVO.getDemandWhStCode());
            List<AppItmItemPageVO> simpleItem = scpCateItemRepoProc.pageAppItemAndWhNetSku(appItemPageParamVO);
            Map<Long, AppItmItemPageVO> simpleItemMap = simpleItem.stream().collect(Collectors.toMap(AppItmItemPageVO::getItemId, Function.identity(), (old, item) -> item));
            List<AppItmItemPageVO> originItemList = new ArrayList<>();
            for (ScpStoreCartDO cartDO : allocItemList) {
                AppItmItemPageVO appItmItemPageVO = simpleItemMap.get(cartDO.getItemId());
                AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
                priceParamVO.setItemCode(cartDO.getItemCode());
                priceParamVO.setItemId(cartDO.getItemId());
                priceParamVO.setItemCateCode(cartDO.getItemCateCode());
                priceParamVO.setUom(cartDO.getUom());
                priceParamVO.setCombineItemCode(cartDO.getCombineItemCode());
                priceParamVO.setCombineItemFlag(cartDO.getCombineItemFlag());
                priceParamVO.setItemType2(appItmItemPageVO == null ? cartDO.getItemType2() : appItmItemPageVO.getItemType2());
                priceParamVO.setActivityCode(cartDO.getActivityCode());
                AppItmItemPageVO item = new AppItmItemPageVO();
                item.setItemId(cartDO.getItemId());
                item.setItemCode(cartDO.getItemCode());
                item.setItemType2(appItmItemPageVO == null ? cartDO.getItemType2() : appItmItemPageVO.getItemType2());
                originItemList.add(item);
            }

            // 设置门店的订货日历限制
            Map<String, Boolean> calendarLimitMap = setStoreDemandCalendarLimit(paramVO.getDemandWhStCode(), originItemList, scpManType);

            Set<String> paramItemInfo = new HashSet<>();
            // 一次遍历生成购物车强配商品key集合
            cartDataList.stream()
                    .filter(item -> item.getActivityCode() != null)
                    .forEach(item -> paramItemInfo.add(
                            SysUtils.generateRedisKey(ScpConstant.SKU, item.getCombineItemCode(), item.getItemCode(), item.getActivityCode())));

            // 一次遍历完成映射构建和验证
            for (ScpStoreCartDO item : allocItemList) {
                Boolean calendarLimit = calendarLimitMap.get(item.getItemCode());
                if (calendarLimit == null || calendarLimit) {
                    log.info("门店:{}商品:{}的强配被订货日历限制，不需要检验", demandWhStCode, item.getItemCode());
                    continue;
                }
                String key = SysUtils.generateRedisKey(ScpConstant.SKU, item.getCombineItemCode(), item.getItemCode(), item.getActivityCode());
                allocSettingMap.put(key, item);
                // 如果发现不匹配项，立即抛出异常
                if (!paramItemInfo.contains(key)) {
                    throw new BusinessException("缺少强配商品，请刷新购物车");
                }
            }
        }

        List<ScpStoreCartDO> allocItemInfo = cartDataList.stream().filter(item -> item.getActivityCode() != null).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(allocItemInfo)) {
            // 存在强配商品下单
            //查询强配商品，如果不需要强配则删除这个强配商品
            dataList = cartDataList.stream().filter(item -> {
                if (item.getActivityCode() != null) {
                    String key = SysUtils.generateRedisKey(ScpConstant.SKU, item.getCombineItemCode(), item.getItemCode(), item.getActivityCode());
                    ScpStoreCartDO scpAllocSettingItemRespVO = allocSettingMap.get(key);
                    if (scpAllocSettingItemRespVO == null) {
                        log.info("商品:{},活动:{},不存在或者不需要强配或者强配已满足", item.getItemCode(), item.getActivityCode());
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toList());
        } else {
            dataList = cartDataList;
        }

        //检验商品限购
        checkLimitPurchase(demandWhStCode, orderSetting, dataList);
        //检查商品起订
        checkMinOrderQty(demandWhStCode, orderSetting, dataList);
        //库存数量
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<>(new HashMap<>());
        //获取仓网供应关系
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = scpWhNetRelationService.findNewWhNetByParam(demandWhStCode, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), dataList);

        //获取供应商份额
        List<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<>();
        List<OrderConfirmRespVO> confirmRespVOS = new ArrayList<>();
        for (ScpStoreCartDO cartDO : dataList) {
            // 爷爷茶直接获取仓网关系数据
            confirmRespVOS.addAll(whnetStrategy(cartDO, orgStore, orderSetting.getWhnetFreightFlag(), whNetMap, priceParamList));
        }
        //构建拆分行map
        Map<String, List<OrderConfirmRespVO>> confirmMap = buildConfirmMap(confirmRespVOS);
        InvWhItemTotalStkRpcParam stockParam = buildStockParam(confirmRespVOS);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> getWhStockMap(stockParam, stockMapRef), taskExecutor);
        CompletableFuture<Map<String, List<ItmItemSpuBusinessRpcDTO>>> future3 = CompletableFuture.supplyAsync(() -> getItemMoq(orgStore.getOuCode(), dataList), taskExecutor);
        CompletableFuture.allOf(future2, future3).join();
        //构建价格行map
        Map<String, List<ItmItemSpuBusinessRpcDTO>> itemMoqMap = new HashMap<>();
        try {
            itemMoqMap = future3.get();
        } catch (Exception e) {
            log.info("查询价格和商品最小起订量报错：{}", e.getMessage(), e);
            throw new BusinessException("查询价格和商品最小起订量报错：" + e.toString());
        }
        //校验moq
        Map<String, List<ScpStoreCartDO>> itemMap = dataList.stream().collect(Collectors.groupingBy(ScpStoreCartDO::getSpuCode));
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : itemMap.entrySet()) {
            String spuCode = entry.getKey();
            List<ScpStoreCartDO> list = entry.getValue();
            if (!itemMoqMap.containsKey(spuCode)) {
                continue;
            }
            if (list.get(0).getActivityCode() != null) {
                continue;
            }
            ItmItemSpuBusinessRpcDTO itemInfo = itemMoqMap.get(spuCode).get(0);
            BigDecimal totalQty = list.stream().map(ScpStoreCartDO::getQty).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (itemInfo.getMoq() != null && totalQty.compareTo(itemInfo.getMoq()) < 0) {
                throw new BusinessException("商品：" + list.get(0).getItemName() + "小于最小起订量");
            }
        }

        Map<String, BigDecimal> stockMap = stockMapRef.get();
        //封装返回结果
        Map<String, List<ScpStoreCartDO>> spuCodeMap =
                dataList.stream().collect(Collectors.groupingBy(item -> SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode())));
        List<ScpDemandOrderDSaveVO> saveVOList = new ArrayList<>();
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<>(BigDecimal.ZERO);

        for (Map.Entry<String, List<ScpStoreCartDO>> entry : spuCodeMap.entrySet()) {
            ScpStoreCartDO first = entry.getValue().get(0);
            CartToOrderSuccessRespVO successVO = new CartToOrderSuccessRespVO();
            successVO.setSpuId(first.getSpuId());
            successVO.setSpuCode(first.getSpuCode());
            successVO.setSpuName(first.getSpuName());
            successVO.setAnotherName(first.getAnotherName());
            successVO.setSpec(first.getSpec());
            successVO.setUrl(first.getUrl());
            successVO.setCombineItemCode(first.getCombineItemCode());
            successVO.setCombineItemName(first.getCombineItemName());
            successVO.setCombineItemFlag(first.getCombineItemFlag());

            List<CartToOrderSuccessRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<>();
            for (ScpStoreCartDO scpCartDO : entry.getValue()) {
                String activityCode = scpCartDO.getActivityCode();

                List<OrderConfirmRespVO> confirmList = confirmMap.get(SysUtils.getItemKey(scpCartDO.getCombineItemCode(), scpCartDO.getItemCode()) + activityCode);
                if (CollUtil.isEmpty(confirmList)) {
                    //添加错误信息
                    CartToOrderFailRespVO failVO = new CartToOrderFailRespVO();
                    failVO.setItemCode(scpCartDO.getItemCode());
                    failVO.setItemName(scpCartDO.getItemName());
                    failVO.setMsg("匹配不到仓库或供应商");
                    failList.add(failVO);
                    continue;
                }
                List<CartToOrderSuccessRespVO.WhAllocObject> whAllocObjects = new ArrayList<>();
                for (OrderConfirmRespVO orderConfirmRespVO : confirmList) {
                    CartToOrderSuccessRespVO.WhAllocObject whAllocObject = new CartToOrderSuccessRespVO.WhAllocObject();

                    whAllocObject.setPrice(orderConfirmRespVO.getPrice());
                    whAllocObject.setSalePrice(orderConfirmRespVO.getSalePrice());
                    whAllocObject.setSettlementPrice(orderConfirmRespVO.getSettlementPrice());
                    whAllocObject.setSettlementSalePrice(orderConfirmRespVO.getSettlementSalePrice());


                    whAllocObject.setSuppId(orderConfirmRespVO.getSuppId());
                    whAllocObject.setSuppCode(orderConfirmRespVO.getSuppCode());
                    whAllocObject.setSuppName(orderConfirmRespVO.getSuppName());
                    whAllocObject.setTefPrice(orderConfirmRespVO.getTefPrice());
                    whAllocObject.setMefPrice(orderConfirmRespVO.getMefPrice());
                    whAllocObject.setOefPrice(orderConfirmRespVO.getOefPrice());
                    whAllocObject.setIsProjFeeCharged(orderConfirmRespVO.getIsProjFeeCharged());
                    whAllocObject.setTefFeeOuCode(orderConfirmRespVO.getTefFeeOuCode());
                    whAllocObject.setTefFeeOuName(orderConfirmRespVO.getTefFeeOuName());
                    whAllocObject.setOefFeeOuCode(orderConfirmRespVO.getOefFeeOuCode());
                    whAllocObject.setOefFeeOuName(orderConfirmRespVO.getOefFeeOuName());
                    whAllocObject.setMefFeeOuCode(orderConfirmRespVO.getMefFeeOuCode());
                    whAllocObject.setMefFeeOuName(orderConfirmRespVO.getMefFeeOuName());

                    whAllocObject.setRatio(orderConfirmRespVO.getRatio());
                    whAllocObject.setQty(orderConfirmRespVO.getAllocationDeQuantity());
                    whAllocObject.setOuId(orderConfirmRespVO.getOuId());
                    whAllocObject.setOuCode(orderConfirmRespVO.getOuCode());
                    whAllocObject.setOuName(orderConfirmRespVO.getOuName());
                    whAllocObject.setSupplyType(orderConfirmRespVO.getSupplyType());
                    whAllocObject.setSupplyWhCode(orderConfirmRespVO.getSuppWhCode());
                    whAllocObject.setSupplyWhId(orderConfirmRespVO.getSuppWhId());
                    whAllocObject.setSupplyWhName(orderConfirmRespVO.getSuppWhName());
                    whAllocObject.setFreightFlag(orderConfirmRespVO.getFreightFlag());
                    whAllocObject.setFreightRatio(orderConfirmRespVO.getFreightRatio());
                    whAllocObject.setSaleOuCode(orderConfirmRespVO.getSaleOuCode());
                    whAllocObject.setSaleOuName(orderConfirmRespVO.getSaleOuName());
                    whAllocObject.setSaleCustCode(orderConfirmRespVO.getSaleCustCode());
                    // 库存可供量
                    if (ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(whAllocObject.getSupplyType()) &&
                            ScpConstant.WH_DELIVERY_TYPES.contains(scpCartDO.getDeliveryType()) &&
                            (scpCartDO.getPreSaleStatus() == null || !scpCartDO.getPreSaleStatus())
                    ) {
                        if (stockMap != null && stockMap.containsKey(scpCartDO.getItemCode())) {
                            BigDecimal avalQty = stockMap.get(scpCartDO.getItemCode());
                            if (whAllocObject.getQty().compareTo(avalQty) > 0) {
                                if (StrUtil.isNotBlank(activityCode)) {
                                    continue;
                                } else {
                                    throw new BusinessException("商品【" + scpCartDO.getItemName() + "】库存可用量为:" + avalQty + ",库存不足");
                                }
                            }
                            whAllocObject.setAvalQty(avalQty);
                        } else {
                            if (StrUtil.isBlank(activityCode)) {
                                throw new BusinessException("商品【" + scpCartDO.getItemName() + "】库存不足");
                            } else {
                                continue;
                            }
                        }
                    }
                    whAllocObjects.add(whAllocObject);
                    //预下单订单明细
                    buildSimpleOrderItem(scpCartDO, orderConfirmRespVO, whAllocObject, saveVOList);
                }
                if (CollUtil.isEmpty(whAllocObjects)) {
                    continue;
                }
                CartToOrderSuccessRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartToOrderSuccessRespVO.ItemSpecObjectVO();
                itemSpecObjectVO.setItemId(scpCartDO.getItemId());
                itemSpecObjectVO.setItemCode(scpCartDO.getItemCode());
                itemSpecObjectVO.setItemName(scpCartDO.getItemName());
                itemSpecObjectVO.setDemandQuantity(scpCartDO.getQty());
                itemSpecObjectVO.setUom(scpCartDO.getUom());
                itemSpecObjectVO.setUomName(scpCartDO.getUomName());
                itemSpecObjectVO.setUom2(scpCartDO.getUom2());
                itemSpecObjectVO.setUom2Name(scpCartDO.getUom2Name());
                itemSpecObjectVO.setDecimalPlaces(scpCartDO.getDecimalPlaces());
                itemSpecObjectVO.setUomRatio(scpCartDO.getUomRatio());
                itemSpecObjectVO.setItemType(scpCartDO.getItemType());
                itemSpecObjectVO.setDeliveryType(scpCartDO.getDeliveryType());
                itemSpecObjectVO.setItemAttrName(scpCartDO.getItemAttrName());
                itemSpecObjectVO.setActivityCode(activityCode);
                itemSpecObjectVO.setActivityId(scpCartDO.getActivityId());
                itemSpecObjectVO.setPreSaleStatus(scpCartDO.getPreSaleStatus());
                itemSpecObjectVO.setDiscount(scpCartDO.getDiscount());
                itemSpecObjectVO.setMinNum(scpCartDO.getMinNum());
                BigDecimal totalAmt = whAllocObjects.stream().map(CartToOrderSuccessRespVO.WhAllocObject::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                itemSpecObjectVO.setTotalAmt(totalAmt);
                itemSpecObjectVO.setWhAllocObjects(whAllocObjects);
                itemSpecObjectVOS.add(itemSpecObjectVO);
                goodAmt.updateAndGet(v -> SysUtils.processAmtScale(v.add(totalAmt)));
            }
            if (CollUtil.isNotEmpty(itemSpecObjectVOS)) {
                successVO.setItemSpecObjectVOS(itemSpecObjectVOS);
                successList.add(successVO);
            }
        }
        //赠品处理
        if(CollectionUtils.isNotEmpty(successList)){
            Optional<CartToOrderSuccessRespVO.WhAllocObject> optional = successList.stream()
                    .flatMap(item -> item.getItemSpecObjectVOS().stream())
                    .flatMap(row -> row.getWhAllocObjects().stream())
                    .filter(d -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(d.getSupplyType()))
                    .findFirst();
            if(optional.isPresent()){
                buildGiftItem(orgStore, successList);
            }
        }
        //商品金额
        resultVO.setGoodAmt(goodAmt.get());
        resultVO.setSuccess(successList);
        resultVO.setFail(failList);
        resultVO.setAllFailed(successList.isEmpty());
        //汇总信息
        int itemTypeNum = 0;
        AtomicReference<BigDecimal> qtyTotal = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> amtTotal = new AtomicReference<>(BigDecimal.ZERO);
        for (CartToOrderSuccessRespVO order : successList) {
            for (CartToOrderSuccessRespVO.ItemSpecObjectVO item : order.getItemSpecObjectVOS()) {
                itemTypeNum = itemTypeNum + 1;
                qtyTotal.updateAndGet(v -> v.add(item.getDemandQuantity()));
                amtTotal.updateAndGet(v -> v.add(item.getTotalAmt()));
            }
        }
        resultVO.setItemTypeNum(itemTypeNum);
        resultVO.setAmtTotal(SysUtils.processAmtScale(amtTotal.get()));
        resultVO.setQtyTotal(qtyTotal.get());
        return resultVO;
    }

    private void checkMinOrderQty(String demandWhStCode, ScpOrderSettingRespVO orderSetting, List<ScpStoreCartDO> dataList) {
        List<String> itemTypes = StrUtil.split(orderSetting.getDeliveryType(), ",");
        List<ScpMinOrderSettingItemRespVO> minOrderSettingItemRespVOList = scpMinOrderSettingItemDomainService.getEnableMinOrderSettingItemByStoreCode(demandWhStCode, itemTypes);
        if (CollUtil.isEmpty(minOrderSettingItemRespVOList)) {
            return;
        }
        Map<Long, BigDecimal> purLimitMap = minOrderSettingItemRespVOList.stream().collect(Collectors.toMap(ScpMinOrderSettingItemRespVO::getItemId, ScpMinOrderSettingItemRespVO::getMinNum, (k1, k2) -> k1));
        log.info("起订查询结果：{}", purLimitMap);
        // 查询
        if (CollUtil.isNotEmpty(dataList)) {
            dataList.forEach(item -> {
                BigDecimal minNum = purLimitMap.get(item.getItemId());
                if (minNum != null && item.getQty().compareTo(minNum) < 0) {
                    throw new BusinessException("商品【" + item.getItemName() + "】起订数量为" + minNum);
                }
            });
        }
    }

    private void buildGiftItem(OrgStoreBaseRpcDTO orgStore, List<CartToOrderSuccessRespVO> successList) {
        List<String> saleOuCodes = scpWhNetRelationService.findSaleOuInfo(orgStore.getStoreCode());
        if(CollectionUtils.isEmpty(saleOuCodes)){
            return;
        }

        MktDiscountGiftRpcBatchParam giftRpcBatchParam = new MktDiscountGiftRpcBatchParam();
        giftRpcBatchParam.setOuCodes(saleOuCodes);
        giftRpcBatchParam.setType("0");
        giftRpcBatchParam.setCustCode(orgStore.getCustCode());
        List<MktDiscountGiftRpcBatchParam.ItemNumParam> itemNumParams = new ArrayList<>();
        for(CartToOrderSuccessRespVO cart: successList){
            List<CartToOrderSuccessRespVO.ItemSpecObjectVO> specObjectVOS = cart.getItemSpecObjectVOS();
            for(CartToOrderSuccessRespVO.ItemSpecObjectVO spec: specObjectVOS){
                BigDecimal totalQty = spec.getWhAllocObjects().stream().map(CartToOrderSuccessRespVO.WhAllocObject::getQty)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                MktDiscountGiftRpcBatchParam.ItemNumParam itemNumParam = new MktDiscountGiftRpcBatchParam.ItemNumParam();
                itemNumParam.setItemId(spec.getItemId());
                Long longValue = totalQty.longValue();
                itemNumParam.setNum(longValue);
                itemNumParams.add(itemNumParam);
            }
        }
        giftRpcBatchParam.setItems(itemNumParams);
        List<MktDiscountGiftRpcDTO> mktDiscountGiftRpcDTOS = mktDiscountGiftRpcService.queryAllItemGiftByParam(giftRpcBatchParam).computeData();
        if(CollectionUtils.isNotEmpty(mktDiscountGiftRpcDTOS)){
            mktDiscountGiftRpcDTOS = mktDiscountGiftRpcDTOS.stream()
                    .filter(d -> CollectionUtils.isNotEmpty(d.getGifts())).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(mktDiscountGiftRpcDTOS)) {
                Map<Long, List<GiftRpcDTO>> map = mktDiscountGiftRpcDTOS.stream()
                        .collect(Collectors.toMap(MktDiscountGiftRpcDTO::getItemId, MktDiscountGiftRpcDTO::getGifts));
                for(CartToOrderSuccessRespVO cart: successList){
                    List<CartToOrderSuccessRespVO.ItemSpecObjectVO> specObjectVOS = cart.getItemSpecObjectVOS();
                    for(CartToOrderSuccessRespVO.ItemSpecObjectVO spec: specObjectVOS){
                        List<GiftRpcDTO> giftRpcDTOS = map.get(spec.getItemId());
                        if(CollectionUtils.isNotEmpty(giftRpcDTOS)){
                            List<CartToOrderSuccessRespVO.GiftItemVO> itemVOS = giftRpcDTOS.stream().map(gift -> {
                                CartToOrderSuccessRespVO.GiftItemVO giftItemVO = new CartToOrderSuccessRespVO.GiftItemVO();
                                giftItemVO.setDiscountGiftItemId(gift.getItemId());
                                giftItemVO.setDiscountGiftItemCode(gift.getItemCode());
                                giftItemVO.setDiscountGiftItemName(gift.getItemName());
                                giftItemVO.setQty(new BigDecimal(gift.getRealNum()));
                                giftItemVO.setSpuCode(gift.getSpuCode());
                                giftItemVO.setSpuName(gift.getSpuName());
                                giftItemVO.setUrl(gift.getUrl());
                                return giftItemVO;
                            }).collect(Collectors.toList());
                            spec.setGiftItemVOS(itemVOS);
                        }
                    }
                }
            }
        }
    }

    @Override
    public AiOrderRespVO aiOrder(AIOrderCheckParamVO paramVO) {
        OrderCheckRespVO resultVO = new OrderCheckRespVO();
        List<CartToOrderSuccessRespVO> successList = new ArrayList<>();
        List<CartToOrderFailRespVO> failList = new ArrayList<>();

        //根据门店+商品去查：
        //1、仓网关系接口，匹配出仓库，则返回前端展示成仓+品；
        //2、如果1找不到的情况下，调供应商配额接口，匹配出供应商，则返回前端展示成供应商+品；
        //3、如果上面1和2都找不到的情况下，后端返回信息说匹配不到仓或供应商，前端要根据后端返回的错误在前端进行商品行的置灰，控制用户下不了单。
        String demandWhStCode = paramVO.getDemandWhStCode();
        OrgStoreBaseRpcDTO orgStore = rmiOrgStoreRpcService.getOrgStoreBase(demandWhStCode);
        //获取单据类型配置
        ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByBusinessType(paramVO.getBusinessType(), ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        if (orderSetting == null) {
            throw new BusinessException("请先配置或启用单据类型:" + paramVO.getBusinessType());
        }

        //获取当前用户信息
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> dataList = paramVO.getItems();
        if (CollUtil.isEmpty(dataList)) {
            throw new BusinessException("没有指定商品");
        }
        //查询强配商品
        addAllocSettingItem(currentUserId, demandWhStCode, orderSetting, dataList);
        //库存数量
        AtomicReference<Map<String, BigDecimal>> stockMapRef = new AtomicReference<>(new HashMap<>());
        List<String> itemCodes = dataList.stream().map(ScpStoreCartDO::getItemCode).collect(Collectors.toList());
        //获取仓网供应关系
        Map<String, List<ScpWhNetRelationRpcDTO>> whNetMap = scpWhNetRelationService.findNewWhNetByParam(demandWhStCode, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), dataList);
        //获取供应商份额
        Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap = scpSupplyAllocationService.findSupplyAllocationByParam(demandWhStCode, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode(), itemCodes);
        List<ItmPriPriceRpcDtoParam> priceParamList = new ArrayList<>();
        List<OrderConfirmRespVO> confirmRespVOS = new ArrayList<>();
        List<String> priorities = Arrays.asList(orderSetting.getFirstPriority(), orderSetting.getSecPriority());

        for (ScpStoreCartDO cartDO : dataList) {
            List<OrderConfirmRespVO> inConfirmList = new ArrayList<>();
            for (String priority : priorities) {
                if (ScpUdcEnum.ORDER_PRIORITY_SUPALLOC.getValueCode().equals(priority)) {
                    inConfirmList.addAll(suppAllocStrategy(cartDO, orgStore, orderSetting.getSuppFreightFlag(), supplyAllocationMap, priceParamList, stockMapRef));
                } else if (ScpUdcEnum.ORDER_PRIORITY_WHNET.getValueCode().equals(priority)) {
                    inConfirmList.addAll(whnetStrategy(cartDO, orgStore, orderSetting.getWhnetFreightFlag(), whNetMap, priceParamList));
                }
                if (!inConfirmList.isEmpty()) {
                    confirmRespVOS.addAll(inConfirmList);
                    break;
                }
            }
        }
        //构建拆分行map
        Map<String, List<OrderConfirmRespVO>> confirmMap = buildConfirmMap(confirmRespVOS);
        InvWhItemTotalStkRpcParam stockParam = buildStockParam(confirmRespVOS);
        CompletableFuture<List<PriPriceRpcDTO>> future1 = CompletableFuture.supplyAsync(() -> {
            if (CollUtil.isEmpty(priceParamList)) {
                return new ArrayList<>();
            } else {
                return rmiPriceRpcService.findPriceByParam(priceParamList);
            }
        }, taskExecutor);
        CompletableFuture<Void> future2 = CompletableFuture.runAsync(() -> getWhStockMap(stockParam, stockMapRef), taskExecutor);
        CompletableFuture<Map<String, List<ItmItemSpuBusinessRpcDTO>>> future3 = CompletableFuture.supplyAsync(() -> getItemMoq(orgStore.getOuCode(), dataList), taskExecutor);
        CompletableFuture.allOf(future1, future2, future3).join();
        //构建价格行map
        List<PriPriceRpcDTO> priceList = new ArrayList<>();
        Map<String, List<ItmItemSpuBusinessRpcDTO>> itemMoqMap = new HashMap<>();
        try {
            priceList = future1.get();
            itemMoqMap = future3.get();
        } catch (Exception e) {
            log.info("查询价格和商品最小起订量报错：{}", e);
            throw new BusinessException("查询价格和商品最小起订量报错：" + e.toString());
        }
        //校验moq
        Map<String, List<ScpStoreCartDO>> itemMap = dataList.stream().collect(Collectors.groupingBy(ScpStoreCartDO::getSpuCode));
        for (Map.Entry<String, List<ScpStoreCartDO>> entry : itemMap.entrySet()) {
            String spuCode = entry.getKey();
            List<ScpStoreCartDO> list = entry.getValue();
            if (!itemMoqMap.containsKey(spuCode)) {
                continue;
            }
            if (list.get(0).getActivityCode() != null) {
                continue;
            }
            ItmItemSpuBusinessRpcDTO itemInfo = itemMoqMap.get(spuCode).get(0);
            BigDecimal totalQty = list.stream().map(ScpStoreCartDO::getQty).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
            if (itemInfo.getMoq() != null && totalQty.compareTo(itemInfo.getMoq()) < 0) {
                throw new BusinessException("商品：" + list.get(0).getItemName() + "小于最小起订量");
            }
        }

        Map<String, List<PriPriceRpcDTO>> priceMap = buildPriceMap(priceList, priceParamList);
        Map<String, BigDecimal> stockMap = stockMapRef.get();
        //封装返回结果
        Map<String, List<ScpStoreCartDO>> spuCodeMap =
                dataList.stream().collect(Collectors.groupingBy(ScpStoreCartDO::getSpuCode));
        List<ScpDemandOrderDSaveVO> saveVOList = new ArrayList<>();
        AtomicReference<BigDecimal> goodAmt = new AtomicReference<>(BigDecimal.ZERO);

        for (Map.Entry<String, List<ScpStoreCartDO>> entry : spuCodeMap.entrySet()) {
            ScpStoreCartDO first = entry.getValue().get(0);
            CartToOrderSuccessRespVO successVO = new CartToOrderSuccessRespVO();
            successVO.setSpuId(first.getSpuId());
            successVO.setSpuCode(first.getSpuCode());
            successVO.setSpuName(first.getSpuName());
            successVO.setAnotherName(first.getAnotherName());
            successVO.setSpec(first.getSpec());
            successVO.setUrl(first.getUrl());

            List<CartToOrderSuccessRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<>();
            for (ScpStoreCartDO scpCartDO : entry.getValue()) {
                String itemCode = scpCartDO.getItemCode();
                String activityCode = scpCartDO.getActivityCode();

                List<OrderConfirmRespVO> confirmList = confirmMap.get(itemCode + activityCode);
                if (CollUtil.isEmpty(confirmList)) {
                    //添加错误信息
                    CartToOrderFailRespVO failVO = new CartToOrderFailRespVO();
                    failVO.setItemCode(scpCartDO.getItemCode());
                    failVO.setItemName(scpCartDO.getItemName());
                    failVO.setMsg("匹配不到仓库或供应商");
                    failList.add(failVO);
                    continue;
                }
                List<CartToOrderSuccessRespVO.WhAllocObject> whAllocObjects = new ArrayList<>();
                for (OrderConfirmRespVO orderConfirmRespVO : confirmList) {
                    CartToOrderSuccessRespVO.WhAllocObject whAllocObject = new CartToOrderSuccessRespVO.WhAllocObject();
                    //供应商份额分配，如果销售公司无值，属于同公司，不需要带出含税单价，此行无需支付；
                    String ouCode = orderConfirmRespVO.getSaleOuCode();
                    if (StrUtil.isBlank(ouCode)) {
                        whAllocObject.setItemPrice(BigDecimal.ZERO);
                    } else {
                        List<PriPriceRpcDTO> priceRpcDTOS = priceMap.get(orderConfirmRespVO.getItemCode() + "@" + ouCode);
                        if (CollUtil.isNotEmpty(priceRpcDTOS)) {
                            whAllocObject.setItemPrice(priceRpcDTOS.get(0).getPrice());
                        } else {
                            log.info("该商品无价格, 编码:{},名称:{}", itemCode, scpCartDO.getItemName());
                            //添加错误信息
                            CartToOrderFailRespVO failVO = new CartToOrderFailRespVO();
                            failVO.setItemCode(scpCartDO.getItemCode());
                            failVO.setItemName(scpCartDO.getItemName());
                            failVO.setMsg("该商品无价格");
                            failList.add(failVO);
                            continue;
                        }
                    }
                    whAllocObject.setRatio(orderConfirmRespVO.getRatio());
                    whAllocObject.setQty(orderConfirmRespVO.getAllocationDeQuantity());
                    whAllocObject.setOuId(orderConfirmRespVO.getOuId());
                    whAllocObject.setOuCode(orderConfirmRespVO.getOuCode());
                    whAllocObject.setOuName(orderConfirmRespVO.getOuName());
                    whAllocObject.setSupplyType(orderConfirmRespVO.getSupplyType());
                    whAllocObject.setSupplyWhCode(orderConfirmRespVO.getSuppWhCode());
                    whAllocObject.setSupplyWhId(orderConfirmRespVO.getSuppWhId());
                    whAllocObject.setSupplyWhName(orderConfirmRespVO.getSuppWhName());
                    whAllocObject.setFreightFlag(orderConfirmRespVO.getFreightFlag());
                    whAllocObject.setFreightRatio(orderConfirmRespVO.getFreightRatio());
                    whAllocObject.setSaleOuCode(orderConfirmRespVO.getSaleOuCode());
                    whAllocObject.setSaleOuName(orderConfirmRespVO.getSaleOuName());
                    whAllocObject.setSaleCustCode(orderConfirmRespVO.getSaleCustCode());
                    // 库存可供量
                    if (ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(whAllocObject.getSupplyType()) &&
                            (scpCartDO.getPreSaleStatus() == null || !scpCartDO.getPreSaleStatus())) {
                        if (stockMap != null && stockMap.containsKey(scpCartDO.getItemCode())) {
                            BigDecimal avalQty = stockMap.get(scpCartDO.getItemCode());
                            if (whAllocObject.getQty().compareTo(avalQty) > 0) {
                                if (StrUtil.isNotBlank(activityCode)) {
                                    continue;
                                } else {
                                    throw new BusinessException("商品【" + scpCartDO.getItemName() + "】库存可用量为:" + avalQty + ",库存不足");
                                }
                            }
                            whAllocObject.setAvalQty(avalQty);
                        } else {
                            if (StrUtil.isBlank(activityCode)) {
                                throw new BusinessException("商品【" + scpCartDO.getItemName() + "】库存不足");
                            } else {
                                continue;
                            }
                        }
                    }
                    whAllocObjects.add(whAllocObject);
                    //预下单订单明细
                    buildSimpleOrderItem(scpCartDO, orderConfirmRespVO, whAllocObject, saveVOList);
                }
                if (CollUtil.isEmpty(whAllocObjects)) {
                    continue;
                }
                CartToOrderSuccessRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartToOrderSuccessRespVO.ItemSpecObjectVO();
                itemSpecObjectVO.setItemId(scpCartDO.getItemId());
                itemSpecObjectVO.setItemCode(scpCartDO.getItemCode());
                itemSpecObjectVO.setItemName(scpCartDO.getItemName());
                itemSpecObjectVO.setDemandQuantity(scpCartDO.getQty());
                itemSpecObjectVO.setUom(scpCartDO.getUom());
                itemSpecObjectVO.setUomName(scpCartDO.getUomName());
                itemSpecObjectVO.setUom2(scpCartDO.getUom2());
                itemSpecObjectVO.setUom2Name(scpCartDO.getUom2Name());
                itemSpecObjectVO.setDecimalPlaces(scpCartDO.getDecimalPlaces());
                itemSpecObjectVO.setUomRatio(scpCartDO.getUomRatio());
                itemSpecObjectVO.setItemType(scpCartDO.getItemType());
                itemSpecObjectVO.setItemAttrName(scpCartDO.getItemAttrName());
                itemSpecObjectVO.setActivityCode(activityCode);
                itemSpecObjectVO.setActivityId(scpCartDO.getActivityId());
                itemSpecObjectVO.setPreSaleStatus(scpCartDO.getPreSaleStatus());
                itemSpecObjectVO.setMinNum(scpCartDO.getMinNum());
                BigDecimal totalAmt = whAllocObjects.stream().map(CartToOrderSuccessRespVO.WhAllocObject::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                itemSpecObjectVO.setTotalAmt(totalAmt);
                itemSpecObjectVO.setWhAllocObjects(whAllocObjects);
                itemSpecObjectVOS.add(itemSpecObjectVO);
                goodAmt.updateAndGet(v -> SysUtils.processAmtScale(v.add(totalAmt)));
            }
            if (CollUtil.isNotEmpty(itemSpecObjectVOS)) {
                successVO.setItemSpecObjectVOS(itemSpecObjectVOS);
                successList.add(successVO);
            }
        }
        // 运费计算
        if (CollUtil.isNotEmpty(saveVOList)) {
            buildFreightItem(saveVOList, resultVO, successList);
        }
        //商品金额
        resultVO.setGoodAmt(goodAmt.get());
        resultVO.setSuccess(successList);
        resultVO.setFail(failList);
        resultVO.setAllFailed(successList.size() == 0);
        //汇总信息
        Integer itemTypeNum = 0;
        AtomicReference<BigDecimal> qtyTotal = new AtomicReference<>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> amtTotal = new AtomicReference<>(BigDecimal.ZERO);
        for (CartToOrderSuccessRespVO order : successList) {
            for (CartToOrderSuccessRespVO.ItemSpecObjectVO item : order.getItemSpecObjectVOS()) {
                itemTypeNum = itemTypeNum + 1;
                qtyTotal.updateAndGet(v -> v.add(item.getDemandQuantity()));
                amtTotal.updateAndGet(v -> v.add(item.getTotalAmt()));
            }
        }
        resultVO.setItemTypeNum(itemTypeNum);
        resultVO.setAmtTotal(SysUtils.processAmtScale(amtTotal.get()));
        resultVO.setQtyTotal(qtyTotal.get());

        if (CollectionUtil.isNotEmpty(resultVO.getFail())) {
            throw new BusinessException(resultVO.getFail().get(0).getItemName() + "  " + resultVO.getFail().get(0).getMsg());
        }

        ScpDemandOrderSubmitVO submitVO = new ScpDemandOrderSubmitVO();
        submitVO.setWithoutCart(true);
        ScpDemandSetParamVO orderSetParam = ScpDemandSetParamVO.builder().build();
        orderSetParam.setIsPushed(false);
        orderSetParam.setType("0");
        orderSetParam.setStatus(true);
        orderSetParam.setDemandDate(LocalDateTime.now().toLocalDate().atStartOfDay());
        List<ScpDemandSetSelectRespVO> orderSetList = scpDemandOrderSetService.demandSetSelectList(orderSetParam);
        if (CollectionUtil.isEmpty(orderSetList)) {
            throw new BusinessException("未找到有效的订货集");
        }

        ScpDemandSetSelectRespVO demandOrderSet = null;
        ScpDemandOrderDomainService scpDemandOrderDomainService = SpringUtil.getBean(ScpDemandOrderDomainService.class);
        for (ScpDemandSetSelectRespVO scpDemandSetSelectRespVO : orderSetList) {
            var newParamVO = ScpDemandOrderParamVO.builder().demandCode(scpDemandSetSelectRespVO.getDemandCode()).businessType(paramVO.getBusinessType())
                    .demandWhStCode(paramVO.getDemandWhStCode()).build();
            List<ScpDemandOrderDTO> demandOrderByParam = scpDemandOrderDomainService.findDemandOrderByParam(newParamVO);
            if (CollectionUtil.isEmpty(demandOrderByParam)) {
                demandOrderSet = scpDemandSetSelectRespVO;
                break;
            }
        }

        if (demandOrderSet == null) {
            throw new BusinessException("订货集已创建订货单，请创建新的订货集");
        }

        submitVO.setDemandId(demandOrderSet.getId());
        submitVO.setDemandCode(demandOrderSet.getDemandCode());
        submitVO.setDemandName(demandOrderSet.getDemandName());
        submitVO.setDocCls("ST");
        submitVO.setType("0");
        submitVO.setDemandDate(demandOrderSet.getDemandDate());
        submitVO.setDocType(paramVO.getDocType());
        submitVO.setBusinessType(paramVO.getBusinessType());

        // 门店信息
        BeanUtil.copyProperties(paramVO, submitVO, true);

        List<ScpDemandOrderDSubmitVO> submitItemList = new ArrayList<>();
        Map<String, List<CartToOrderSuccessRespVO>> spuMap = resultVO.getSuccess().stream().collect(Collectors.groupingBy(i -> i.getSpuCode()));

        for (CartToOrderSuccessRespVO spuVo : resultVO.getSuccess()) {
            ScpDemandOrderDSubmitVO scpDemandOrderDSubmitVO = new ScpDemandOrderDSubmitVO();
            BeanUtil.copyProperties(spuVo, scpDemandOrderDSubmitVO, true);
            submitItemList.add(scpDemandOrderDSubmitVO);

            List<ScpDemandOrderDSubmitVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<>();
            scpDemandOrderDSubmitVO.setItemSpecObjectVOS(itemSpecObjectVOS);
            for (CartToOrderSuccessRespVO.ItemSpecObjectVO specObjectVO : spuVo.getItemSpecObjectVOS()) {
                ScpDemandOrderDSubmitVO.ItemSpecObjectVO itemSpecVo = new ScpDemandOrderDSubmitVO.ItemSpecObjectVO();
                BeanUtil.copyProperties(specObjectVO, itemSpecVo, true);
                itemSpecObjectVOS.add(itemSpecVo);

                List<ScpDemandOrderDSubmitVO.WhAllocObject> whAllocObjects = new ArrayList<>();
                itemSpecVo.setWhAllocObjects(whAllocObjects);
                for (CartToOrderSuccessRespVO.WhAllocObject sourceWhObj : specObjectVO.getWhAllocObjects()) {
                    ScpDemandOrderDSubmitVO.WhAllocObject targetWhObj = new ScpDemandOrderDSubmitVO.WhAllocObject();
                    BeanUtil.copyProperties(sourceWhObj, targetWhObj, true);
                    whAllocObjects.add(targetWhObj);
                }
            }
        }
        submitVO.setItemList(submitItemList);
        AppDemandOrderService appDemandOrderService = SpringUtil.getBean(AppDemandOrderService.class);
        long orderId = appDemandOrderService.submit(submitVO);
        Optional<ScpDemandOrderRespVO> demandOrder = scpDemandOrderService.findDemandOrderById(orderId);

        AiOrderRespVO respVO = new AiOrderRespVO();
        respVO.setOrderId(orderId);
        respVO.setDocNo(demandOrder.get().getDocCode());
        respVO.setTotalAmt(demandOrder.get().getAmt());
        return respVO;
    }

    @Override
    public void changeSelectedStatusAll(CartChangeSelectedStatusAllParamVO paramVO) {
        Long currentUserId = UserService.currentUserId();
        List<ScpStoreCartDO> cartItems = cartRedisUtil.getStoreCartItems(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        var cartOps = cartRedisUtil.getStoreCartOps(paramVO.getDemandWhStCode(), paramVO.getCartType(), currentUserId);
        //修改商品选中状态
        cartItems.forEach(row -> {
            String activityCode = row.getActivityCode();
            if (activityCode == null) {
                // 只修改非强配商品
                row.setSelectedStatus(paramVO.getStatus());
                //序列化存入redis中
                String redisValue = JSON.toJSONString(row);
                cartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, row.getCombineItemCode(), row.getItemCode()), redisValue);
            }
        });
    }

    /**
     * 添加强配商品
     *
     * @param currentUserId
     * @param demandWhStCode
     * @param dataList
     */
    private void addAllocSettingItem(Long currentUserId, String demandWhStCode, ScpOrderSettingRespVO orderSetting, List<ScpStoreCartDO> dataList) {
        List<String> itemTypes = StrUtil.split(orderSetting.getDeliveryType(), ",");
        List<ScpAllocSettingItemRespVO> allocSettingItemList = scpAllocSettingItemDomainService.getEnableAllocSettingItemByStoreCode(demandWhStCode, orderSetting.getBusinessType(), itemTypes);
        List<String> itemCodeList = allocSettingItemList.stream().map(ScpAllocSettingItemRespVO::getItemCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollUtil.isEmpty(itemCodeList)) {
            return;
        }
        ItmItemScpBaseRpcParam param = new ItmItemScpBaseRpcParam();
        param.setItemCodes(itemCodeList);
        param.setBusinessBuCode(demandWhStCode);
        List<ItmItemScpBaseRpcDTO> itemList = rmiItemService.findItemScpBaseRpcDtoByParam(param);
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        Map<String, ScpAllocSettingItemRespVO> allocSettingItemRespVOMap = allocSettingItemList.stream().collect(Collectors.toMap(ScpAllocSettingItemRespVO::getItemCode, Function.identity()));
        List<AppItmItemPageVO> appItmItemPageVOS = CollUtil.newCopyOnWriteArrayList(new ArrayList<>());
        List<AppItmItemPageVO> inList = itemList.stream()
                .map(t -> {
                    AppItmItemPageVO appItmItemPageVO = new AppItmItemPageVO();
                    if (Objects.equals(t.getItemType(), ScpUdcEnum.ITM_ITM_TYPE_70.getValueCode())) {
                        ScpAllocSettingItemRespVO row2 = allocSettingItemRespVOMap.get(t.getItemCode());
                        appItmItemPageVO.setItemCode(t.getItemCode());
                        appItmItemPageVO.setItemCateCode(t.getItemCateCode());
                        appItmItemPageVO.setUom(t.getUom2());
                        appItmItemPageVO.setItemId(t.getId());
                        appItmItemPageVO.setItemType2(t.getItemType2());
                        appItmItemPageVO.setCombineItemFlag(false);
                        if (row2 != null) {
                            appItmItemPageVO.setActivityCode(row2.getActivityCode());
                        }
                        List<ItmItemScpBaseRpcDTO> subItems = t.getSubItems();
                        List<AppItmItemPageVO> details = new ArrayList<>();
                        subItems.forEach(subItem -> {
                            AppItmItemPageVO a = new AppItmItemPageVO();
                            ScpAllocSettingItemRespVO row = allocSettingItemRespVOMap.get(subItem.getItemCode());
                            a.setItemCode(subItem.getItemCode());
                            a.setItemCateCode(subItem.getItemCateCode());
                            a.setUom(subItem.getUom2());
                            a.setItemId(subItem.getId());
                            a.setItemType2(subItem.getItemType2());
                            a.setCombineItemFlag(true);
                            a.setCombineItemCode(t.getItemCode());
                            if (row != null) {
                                a.setActivityCode(row.getActivityCode());
                            }
                            details.add(a);
                        });
                        appItmItemPageVO.setDetails(details);
                    } else {
                        ScpAllocSettingItemRespVO row = allocSettingItemRespVOMap.get(t.getItemCode());
                        appItmItemPageVO.setItemCode(t.getItemCode());
                        appItmItemPageVO.setItemCateCode(t.getItemCateCode());
                        appItmItemPageVO.setUom(t.getUom2());
                        appItmItemPageVO.setItemId(t.getId());
                        appItmItemPageVO.setItemType2(t.getItemType2());
                        appItmItemPageVO.setCombineItemFlag(false);
                        if (row != null) {
                            appItmItemPageVO.setActivityCode(row.getActivityCode());
                        }
                        List<AppItmItemPageVO> details = new ArrayList<>();
                        AppItmItemPageVO a = new AppItmItemPageVO();
                        BeanUtils.copyProperties(appItmItemPageVO, a);
                        details.add(a);
                        appItmItemPageVO.setDetails(details);
                    }
                    return appItmItemPageVO;
                }).toList();
        appItmItemPageVOS.addAll(inList);

        //商品价格和库存查询
        appItemActivityService.getPriceAndStock(orderSetting.getBusinessType(), appItmItemPageVOS, demandWhStCode, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
        log.info("强配商品价格和库存{}", JSONUtil.toJsonStr(appItmItemPageVOS));
        Map<String, AppItmItemPageVO> priceMap = appItmItemPageVOS.stream().collect(Collectors.toMap(AppItmItemPageVO::getItemCode, Function.identity(), (t1, t2) -> t1));

        // 只有区配 统配需要校验库存
        List<ScpStoreCartDO> allocItemList = new ArrayList<>();
        for (ItmItemScpBaseRpcDTO itmItemBaseRpcDTO : itemList) {
            if (Objects.equals(itmItemBaseRpcDTO.getItemType(), ScpUdcEnum.ITM_ITM_TYPE_70.getValueCode())) {
                List<ItmItemScpBaseRpcDTO> subItems = itmItemBaseRpcDTO.getSubItems();
                ScpAllocSettingItemRespVO row = allocSettingItemRespVOMap.get(itmItemBaseRpcDTO.getItemCode());
                AppItmItemPageVO appItemPriceRespVO = priceMap.get(itmItemBaseRpcDTO.getItemCode());
                if (ScpConstant.WH_DELIVERY_TYPES.contains(itmItemBaseRpcDTO.getItemType2())) {
                    if (appItemPriceRespVO.getAvalQty() == null || BigDecimal.ZERO.compareTo(appItemPriceRespVO.getAvalQty()) >= 0) {
                        // 排除库存不足的强配商品
                        continue;
                    }
                }
                Map<String, AppItmItemPageVO> subPriceMap;
                List<AppItmItemPageVO> details = appItemPriceRespVO.getDetails();
                if (CollUtil.isNotEmpty(details)) {
                    subPriceMap = details.stream().collect(Collectors.toMap(AppItmItemPageVO::getItemCode, Function.identity(), (t1, t2) -> t1));
                } else {
                    subPriceMap = new HashMap<>();
                }
                subItems.forEach(subItem -> {
                    AppItmItemPageVO appItemPriceRespVO2 = subPriceMap.get(itmItemBaseRpcDTO.getItemCode());
                    ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
                    storeCartDO.setUserId(currentUserId);
                    storeCartDO.setDemandWhStCode(demandWhStCode);
                    storeCartDO.setQty(row.getMinNum().multiply(subItem.getBomQty()));
                    storeCartDO.setActivityCode(row.getActivityCode());
                    storeCartDO.setActivityId(row.getMasId());
                    // 组合商品使用主单位
                    storeCartDO.setUom(subItem.getUom2());
                    storeCartDO.setUomName(subItem.getUom2Name());
                    storeCartDO.setCombineItemCode(itmItemBaseRpcDTO.getItemCode());
                    storeCartDO.setCombineItemName(itmItemBaseRpcDTO.getItemName());
                    storeCartDO.setCombineItemFlag(true);

                    storeCartDO.setItemId(subItem.getId());
                    storeCartDO.setItemCode(subItem.getItemCode());
                    storeCartDO.setItemName(subItem.getItemName());
                    storeCartDO.setAnotherName(subItem.getAnotherName());
                    storeCartDO.setUom(subItem.getUom2());
                    storeCartDO.setUomName(subItem.getUom2Name());
                    storeCartDO.setSpuId(subItem.getSpuId());
                    storeCartDO.setSpuCode(subItem.getSpuCode());
                    storeCartDO.setSpuName(subItem.getSpuName());
                    storeCartDO.setSpec(subItem.getSpec());
                    storeCartDO.setSelectedStatus(1);
                    storeCartDO.setUom2(subItem.getUom2());
                    storeCartDO.setUom2Name(subItem.getUom2Name());
                    storeCartDO.setUomRatio(subItem.getUomRatio2());
                    storeCartDO.setDecimalPlaces(subItem.getDecimalPlaces());
                    storeCartDO.setItemType(subItem.getItemType2());
                    storeCartDO.setItemType2(subItem.getItemType2());
                    storeCartDO.setItemAttrName(subItem.getItemAttrName());
                    storeCartDO.setItemCateCode(subItem.getItemCateCode());
                    storeCartDO.setMinNum(row.getMinNum().multiply(subItem.getBomQty()));
                    storeCartDO.setDeliveryType(subItem.getItemType2());
                    storeCartDO.setUrl(row.getImgUrl());
                    getPrice(appItemPriceRespVO2, storeCartDO);
                    if (storeCartDO.getPrice() != null) {
                        allocItemList.add(storeCartDO);
                    }
                });
            } else {
                AppItmItemPageVO appItemPriceRespVO2 = priceMap.get(itmItemBaseRpcDTO.getItemCode());
                List<AppItmItemPageVO> details = appItemPriceRespVO2.getDetails();
                AppItmItemPageVO appItemPriceRespVO = details.get(0);
                if (ScpConstant.WH_DELIVERY_TYPES.contains(itmItemBaseRpcDTO.getItemType2())) {
                    if (appItemPriceRespVO.getAvalQty() == null || BigDecimal.ZERO.compareTo(appItemPriceRespVO.getAvalQty()) >= 0) {
                        // 排除库存不足的强配商品
                        continue;
                    }
                }
                ScpAllocSettingItemRespVO row = allocSettingItemRespVOMap.get(itmItemBaseRpcDTO.getItemCode());
                ScpStoreCartDO storeCartDO = new ScpStoreCartDO();
                storeCartDO.setUserId(currentUserId);
                storeCartDO.setDemandWhStCode(demandWhStCode);
                storeCartDO.setItemId(itmItemBaseRpcDTO.getId());
                storeCartDO.setItemCode(itmItemBaseRpcDTO.getItemCode());
                storeCartDO.setItemName(itmItemBaseRpcDTO.getItemName());
                storeCartDO.setAnotherName(itmItemBaseRpcDTO.getAnotherName());
                storeCartDO.setUom(itmItemBaseRpcDTO.getUom2());
                storeCartDO.setUomName(itmItemBaseRpcDTO.getUom2Name());
                storeCartDO.setSpuId(itmItemBaseRpcDTO.getSpuId());
                storeCartDO.setSpuCode(itmItemBaseRpcDTO.getSpuCode());
                storeCartDO.setSpuName(itmItemBaseRpcDTO.getSpuName());
                storeCartDO.setSpec(itmItemBaseRpcDTO.getSpec());
                storeCartDO.setQty(row.getMinNum());
                storeCartDO.setSelectedStatus(1);
                storeCartDO.setUom2(itmItemBaseRpcDTO.getUom2());
                storeCartDO.setUom2Name(itmItemBaseRpcDTO.getUom2Name());
                storeCartDO.setUomRatio(itmItemBaseRpcDTO.getUomRatio2());
                storeCartDO.setDecimalPlaces(itmItemBaseRpcDTO.getDecimalPlaces());
                storeCartDO.setItemType(itmItemBaseRpcDTO.getItemType2());
                storeCartDO.setItemType2(itmItemBaseRpcDTO.getItemType2());
                storeCartDO.setItemAttrName(itmItemBaseRpcDTO.getItemAttrName());
                storeCartDO.setActivityCode(row.getActivityCode());
                storeCartDO.setActivityId(row.getMasId());
                storeCartDO.setItemCateCode(itmItemBaseRpcDTO.getItemCateCode());
                storeCartDO.setMinNum(row.getMinNum());
                storeCartDO.setDeliveryType(itmItemBaseRpcDTO.getItemType2());
                storeCartDO.setUrl(row.getImgUrl());
                storeCartDO.setCombineItemFlag(false);
                getPrice(appItemPriceRespVO, storeCartDO);
                if (storeCartDO.getPrice() != null) {
                    allocItemList.add(storeCartDO);
                }
            }
        }
        log.info("门店:{},强配添加商品信息:{}", demandWhStCode, JSONUtil.toJsonStr(allocItemList));
        dataList.addAll(allocItemList);
    }

    private List<AppItmItemPageVO> getDetails(List<ItmItemScpBaseRpcDTO> source, String storeCode, String cartType, Long currentUserId, ItmItemScpBaseRpcDTO parentItem) {
        return source.stream().map(itmItemRpcDTO -> {
            AppItmItemPageVO t = new AppItmItemPageVO();
            t.setItemName(itmItemRpcDTO.getItemName());
            t.setUom(itmItemRpcDTO.getUom2());
            t.setUomName(itmItemRpcDTO.getUom2Name());
            t.setItemType(itmItemRpcDTO.getItemType());
            t.setItemType2(itmItemRpcDTO.getItemType2());
            t.setItemTypeName(itmItemRpcDTO.getItemTypeName());
            t.setItemType2Name(itmItemRpcDTO.getItemType2Name());
            t.setBrand(itmItemRpcDTO.getBrand());
            t.setBrandName(itmItemRpcDTO.getBrandName());
            t.setItemAttr2(itmItemRpcDTO.getItemAttr2());
            t.setSpec(itmItemRpcDTO.getSpec());
            t.setItemCateCode(itmItemRpcDTO.getItemCateCode());
            t.setItemCateName(itmItemRpcDTO.getItemCateFullName());
            t.setSpuId(itmItemRpcDTO.getSpuId());
            t.setSpuCode(itmItemRpcDTO.getSpuCode());
            t.setSpuName(itmItemRpcDTO.getSpuName());
            if (StrUtil.isNotBlank(cartType)) {
                ScpStoreCartDO storeCartItem = cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(parentItem.getItemCode(), itmItemRpcDTO.getItemCode()), storeCode, cartType, currentUserId);
                if (storeCartItem != null) {
                    t.setQty(storeCartItem.getQty());
                } else {
                    t.setQty(BigDecimal.ZERO);
                }
            }
            t.setItemAttrName(StrUtil.isBlank(itmItemRpcDTO.getItemAttrName()) ? itmItemRpcDTO.getSpec() : itmItemRpcDTO.getItemAttrName());
            t.setAnotherName(itmItemRpcDTO.getAnotherName());
            //图片信息
            t.setItemImageList(AppItmItemConvert.INSTANCE.attachmentRpcDtoToProviderDtoList(itmItemRpcDTO.getSpuAttchmentList()));
            t.setItemId(itmItemRpcDTO.getId());
            t.setItemCode(itmItemRpcDTO.getItemCode());
            t.setUom2(itmItemRpcDTO.getUom());
            t.setUom2Name(itmItemRpcDTO.getUomName());
            t.setDecimalPlaces(itmItemRpcDTO.getDecimalPlaces());
            t.setUomRatio(itmItemRpcDTO.getUomRatio2());
            t.setReceiveUom(itmItemRpcDTO.getReceiveUom());
            t.setReceiveUomRatio(itmItemRpcDTO.getReceiveUomRatio());
            t.setReceiveUomName(itmItemRpcDTO.getReceiveUomName());
            t.setMoq(itmItemRpcDTO.getMoq());
            t.setPrice(itmItemRpcDTO.getPrice());
            t.setCombineQty(itmItemRpcDTO.getBomQty());
            if (itmItemRpcDTO.getBomPid() != null) {
                t.setCombineItemFlag(Boolean.TRUE);
                t.setCombineItemCode(parentItem.getItemCode());
                t.setCombineItemName(parentItem.getItemName());
            } else {
                t.setCombineItemFlag(Boolean.FALSE);
            }
            return t;
        }).collect(Collectors.toList());
    }

    // 查询限购
    private void checkLimitPurchase(String demandWhStCode, ScpOrderSettingRespVO orderSetting, List<ScpStoreCartDO> dataList) {
        List<String> itemTypes = StrUtil.split(orderSetting.getDeliveryType(), ",");
        List<ScpPurLimitSettingItemRespVO> allocSettingItemList = scpPurLimitSettingItemDomainService.getEnablePurLimitSettingItemByStoreCode(demandWhStCode, itemTypes);
        Map<Long, BigDecimal> purLimitMap = allocSettingItemList.stream().collect(Collectors.toMap(ScpPurLimitSettingItemRespVO::getItemId, ScpPurLimitSettingItemRespVO::getMinNum, (k1, k2) -> k1));
        if (CollUtil.isEmpty(purLimitMap)) {
            return;
        }
        Map<Long, BigDecimal> longBigDecimalMap = scpDemandOrderRepoProc.countAllocatedOrderItemByItemCodes(new ArrayList<>(purLimitMap.keySet()), demandWhStCode, LocalDateTime.now());
        log.info("限购查询结果：{}", longBigDecimalMap);
        // 查询
        if (CollUtil.isNotEmpty(dataList)) {
            dataList.forEach(item -> {
                Long itemId = item.getItemId();
                BigDecimal orderQty = item.getQty();
                BigDecimal purLimitQty = purLimitMap.get(itemId);
                BigDecimal useQty = BigDecimal.ZERO;
                if (longBigDecimalMap != null) {
                    useQty = longBigDecimalMap.get(itemId) == null ? BigDecimal.ZERO : longBigDecimalMap.get(itemId);
                }
                if (purLimitQty != null && orderQty != null) {
                    BigDecimal canUseQty = purLimitQty.subtract(useQty);
                    if (canUseQty.compareTo(orderQty) < 0) {
                        throw new BusinessException("商品：" + item.getItemName() + "限购数量不足,可用余量：" + canUseQty);
                    }
                }
            });
        }
    }

    private Map<String, List<ItmItemSpuBusinessRpcDTO>> getItemMoq(String storeOuCode, List<ScpStoreCartDO> dataList) {
        List<String> spuCodes = dataList.stream().map(ScpStoreCartDO::getSpuCode).distinct().collect(Collectors.toList());
        Map<String, List<ItmItemSpuBusinessRpcDTO>> moqMap = rmiItemService.findMoqByParam(spuCodes, storeOuCode);
        return moqMap;
    }

    private InvWhItemTotalStkRpcParam buildStockParam(List<OrderConfirmRespVO> confirmRespVOS) {
        if (CollUtil.isNotEmpty(confirmRespVOS)) {
            List<Long> itemIds = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(OrderConfirmRespVO::getItemId)
                    .filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Long> whIds = confirmRespVOS.stream().filter(row -> ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode().equals(row.getSupplyType())).map(OrderConfirmRespVO::getSuppWhId)
                    .filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(itemIds) || CollUtil.isEmpty(whIds)) {
                log.info("查询库存商品或者仓库为空，无需查询");
                return null;
            }
            InvWhItemTotalStkRpcParam invWhItemTotalStkRpcParam = new InvWhItemTotalStkRpcParam();
            invWhItemTotalStkRpcParam.setItemIds(itemIds);
            invWhItemTotalStkRpcParam.setWhIds(whIds);
            invWhItemTotalStkRpcParam.setExcludeDeter2Types(List.of(InvDeter2TypeEnum.TRANS.getType()));
            return invWhItemTotalStkRpcParam;
        }
        return null;
    }

    private void getWhStockMap(InvWhItemTotalStkRpcParam stkRpcParam, AtomicReference<Map<String, BigDecimal>> stockMap) {
        if (stkRpcParam == null) {
            return;
        }
        List<InvWhItemTotalStkRpcDTO> invWhItemTotalStkRpcDTOS = rmiInvStkRpcService.queryInvWhItemTotalStk(stkRpcParam);
        if (CollUtil.isEmpty(invWhItemTotalStkRpcDTOS)) {
            return;
        }
        for (InvWhItemTotalStkRpcDTO dto : invWhItemTotalStkRpcDTOS) {
            stockMap.updateAndGet(currentMap -> {
                currentMap.put(dto.getItemCode(), dto.getAvalQty2());
                return currentMap;
            });
        }
    }

    /**
     * 计算运费商品
     *
     * @param saveVOList
     * @param resultVO
     * @param successList
     */
    private void buildFreightItem(List<ScpDemandOrderDSaveVO> saveVOList, OrderCheckRespVO resultVO, List<CartToOrderSuccessRespVO> successList) {
        List<CartToOrderSuccessRespVO> freightItemList = new ArrayList<>();
        //门店订货单获取运费行商品
        String itemCode = SysUtils.getOrderItemSetting();
        String orderItemImgUrlSetting = SysUtils.getOrderItemImgUrlSetting();
        ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
        itmItemBaseRpcParam.setItemCodes(Arrays.asList(itemCode));
        List<ItmItemBaseRpcDTO> itemBaseRpcDTOList = rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
        if (CollUtil.isEmpty(itemBaseRpcDTOList)) {
            throw new BusinessException("运费商品编码：" + itemCode + "不存在");
        }
        ItmItemBaseRpcDTO shipmentItem = itemBaseRpcDTOList.get(0);
        Map<String, List<ScpDemandOrderDSaveVO>> whCodeMap = saveVOList.stream().collect(Collectors.groupingBy(row -> row.getSuppWhCode()));
        BigDecimal freightAmt = BigDecimal.ZERO;
        //门店订货单添加运费行，按照【要货门店】、【供应仓库】or【供应供应商】生成一行运费
        for (Map.Entry<String, List<ScpDemandOrderDSaveVO>> entry : whCodeMap.entrySet()) {
            List<ScpDemandOrderDSaveVO> list = entry.getValue();
            CartToOrderSuccessRespVO successVO = new CartToOrderSuccessRespVO();
            CartToOrderSuccessRespVO.ItemSpecObjectVO itemSpecObjectVO = new CartToOrderSuccessRespVO.ItemSpecObjectVO();
            CartToOrderSuccessRespVO.WhAllocObject whAllocObject = new CartToOrderSuccessRespVO.WhAllocObject();
            ScpDemandOrderDSaveVO oldSaveVO = list.get(0);
            BigDecimal amt = list.stream().filter(row -> row.getPlanAmt() != null).map(ScpDemandOrderDSaveVO::getPlanAmt)
                    .collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
            whAllocObject.setItemPrice(SysUtils.processAmtScale(amt));
            whAllocObject.setRatio(oldSaveVO.getRatio());
            whAllocObject.setQty(BigDecimal.ONE);
            whAllocObject.setOuId(oldSaveVO.getOuId());
            whAllocObject.setOuCode(oldSaveVO.getOuCode());
            whAllocObject.setOuName(oldSaveVO.getOuName());
            whAllocObject.setSupplyType(oldSaveVO.getSupplyType());
            whAllocObject.setSupplyWhCode(oldSaveVO.getSuppWhCode());
            whAllocObject.setSupplyWhId(oldSaveVO.getSuppWhId());
            whAllocObject.setSupplyWhName(oldSaveVO.getSuppWhName());
            whAllocObject.setFreightFlag(oldSaveVO.getFreightFlag());
            whAllocObject.setFreightRatio(oldSaveVO.getFreightRatio());
            whAllocObject.setSaleOuCode(oldSaveVO.getSaleOuCode());
            whAllocObject.setSaleOuName(oldSaveVO.getSaleOuName());
            whAllocObject.setSaleCustCode(oldSaveVO.getSaleCustCode());
            List<CartToOrderSuccessRespVO.WhAllocObject> whAllocObjects = List.of(whAllocObject);

            itemSpecObjectVO.setItemId(shipmentItem.getId());
            itemSpecObjectVO.setItemCode(shipmentItem.getItemCode());
            itemSpecObjectVO.setItemName(shipmentItem.getItemName());
            itemSpecObjectVO.setDemandQuantity(BigDecimal.ONE);
            itemSpecObjectVO.setUom(shipmentItem.getUom2());
            itemSpecObjectVO.setUomName(shipmentItem.getUom2Name());
            itemSpecObjectVO.setUom2(shipmentItem.getUom());
            itemSpecObjectVO.setUom2Name(shipmentItem.getUomName());
            itemSpecObjectVO.setDecimalPlaces(shipmentItem.getDecimalPlaces());
            itemSpecObjectVO.setUomRatio(shipmentItem.getUomRatio2());
            itemSpecObjectVO.setItemType(shipmentItem.getItemType2());
            itemSpecObjectVO.setItemAttrName(shipmentItem.getItemAttrName());
            itemSpecObjectVO.setTotalAmt(whAllocObject.getItemPrice());
            itemSpecObjectVO.setWhAllocObjects(whAllocObjects);

            List<CartToOrderSuccessRespVO.ItemSpecObjectVO> itemSpecObjectVOS = List.of(itemSpecObjectVO);

            successVO.setSpuId(shipmentItem.getSpuId());
            successVO.setSpuCode(shipmentItem.getSpuCode());
            successVO.setSpuName(shipmentItem.getSpuName());
            successVO.setAnotherName(shipmentItem.getAnotherName());
            successVO.setSpec(shipmentItem.getSpec());
            successVO.setUrl(orderItemImgUrlSetting);

            if (CollUtil.isNotEmpty(itemSpecObjectVOS)) {
                successVO.setItemSpecObjectVOS(itemSpecObjectVOS);
                freightItemList.add(successVO);
            }
            freightAmt = SysUtils.processAmtScale(freightAmt.add(amt));
        }
        //运费金额
        resultVO.setFreightAmt(freightAmt);
        successList.addAll(freightItemList);
    }

    /**
     * 构建简单订单明细
     *
     * @param scpCartDO
     * @param orderConfirmRespVO
     * @param whAllocObject
     * @param saveVOList
     */
    private static void buildSimpleOrderItem(ScpStoreCartDO scpCartDO, OrderConfirmRespVO orderConfirmRespVO, CartToOrderSuccessRespVO.WhAllocObject whAllocObject,
                                             List<ScpDemandOrderDSaveVO> saveVOList) {
        ScpDemandOrderDSaveVO scpDemandOrderDSaveVO = new ScpDemandOrderDSaveVO();
        scpDemandOrderDSaveVO.setAllocationDeQuantity(whAllocObject.getQty());
        scpDemandOrderDSaveVO.setRatio(whAllocObject.getRatio());
        scpDemandOrderDSaveVO.setSupplyType(whAllocObject.getSupplyType());
        scpDemandOrderDSaveVO.setSuppWhId(whAllocObject.getSupplyWhId());
        scpDemandOrderDSaveVO.setSuppWhCode(whAllocObject.getSupplyWhCode());
        scpDemandOrderDSaveVO.setSuppWhName(whAllocObject.getSupplyWhName());
        scpDemandOrderDSaveVO.setDemandQuantity(whAllocObject.getQty());
        scpDemandOrderDSaveVO.setPrice(whAllocObject.getItemPrice());
        scpDemandOrderDSaveVO.setOuId(whAllocObject.getOuId());
        scpDemandOrderDSaveVO.setOuCode(whAllocObject.getOuCode());
        scpDemandOrderDSaveVO.setOuName(whAllocObject.getOuName());
        scpDemandOrderDSaveVO.setIsCalculated(Boolean.FALSE);
        scpDemandOrderDSaveVO.setIsPushed(Boolean.FALSE);
        scpDemandOrderDSaveVO.setUom2(scpCartDO.getUom2());
        scpDemandOrderDSaveVO.setUom2Name(scpCartDO.getUom2Name());
        scpDemandOrderDSaveVO.setUomRatio(scpCartDO.getUomRatio());
//        if (!(orderConfirmRespVO.getFreightFlag() && orderConfirmRespVO.getFreightRatio() != null)) {
//            return;
//        }
        if (StrUtil.isBlank(orderConfirmRespVO.getSaleOuCode())) {
            return;
        }
//        scpDemandOrderDSaveVO.setPlanAmt(SysUtils.processAmtScale(whAllocObject.getAmt().multiply(orderConfirmRespVO.getFreightRatio())));
        scpDemandOrderDSaveVO.setPlanAmt(whAllocObject.getAmt());
        scpDemandOrderDSaveVO.setFreightFlag(whAllocObject.getFreightFlag());
        scpDemandOrderDSaveVO.setFreightRatio(whAllocObject.getFreightRatio());
        scpDemandOrderDSaveVO.setSaleCustCode(whAllocObject.getSaleCustCode());
        scpDemandOrderDSaveVO.setSaleOuCode(whAllocObject.getSaleOuCode());
        scpDemandOrderDSaveVO.setSaleOuName(whAllocObject.getSaleOuName());
        scpDemandOrderDSaveVO.setCombineItemName(scpCartDO.getCombineItemName());
        scpDemandOrderDSaveVO.setCombineItemCode(scpCartDO.getCombineItemCode());
        scpDemandOrderDSaveVO.setCombineItemFlag(scpCartDO.getCombineItemFlag());
        saveVOList.add(scpDemandOrderDSaveVO);
    }

    private Map<String, List<PriPriceRpcDTO>> buildPriceMap(List<PriPriceRpcDTO> priceList, List<ItmPriPriceRpcDtoParam> priceParamList) {
        if (CollUtil.isEmpty(priceList)) {
            //查询基本单位价格
            getBasePrice(priceParamList, priceList);
            if (CollUtil.isEmpty(priceList)) {
                return new HashMap<>();
            }
        } else {
            //查询基本单位价格
            Map<String, List<PriPriceRpcDTO>> inPriceMap =
                    priceList.stream().collect(Collectors.groupingBy(PriPriceRpcDTO::getItemCode));
            priceParamList.removeAll(priceParamList.stream().filter(row -> inPriceMap.containsKey(row.getItemCode())).collect(Collectors.toList()));
            getBasePrice(priceParamList, priceList);
        }
        return priceList.stream().collect(Collectors.groupingBy(row -> row.getItemCode() + "@" + row.getOuCode()));
    }

    private void getBasePrice(List<ItmPriPriceRpcDtoParam> priceParamList, List<PriPriceRpcDTO> priceList) {
        if (CollUtil.isEmpty(priceParamList)) {
            return;
        }
        //查询商品
        List<Long> itemIds = priceParamList.stream().map(ItmPriPriceRpcDtoParam::getItemId).distinct().collect(Collectors.toList());
        Map<Long, ItmItemSimpleRpcDTO> simpleItemMap = rmiItemService.findBaseItemMap(itemIds);

        List<ItmPriPriceRpcDtoParam> baseUomList = priceParamList.stream().map(row -> {
            ItmPriPriceRpcDtoParam param = BeanUtils.copyProperties(row, ItmPriPriceRpcDtoParam.class);
            ItmItemSimpleRpcDTO simpleItem = simpleItemMap.get(row.getItemId());
            param.setUom(simpleItem.getUom());
            return param;
        }).collect(Collectors.toList());
        List<PriPriceRpcDTO> basePriceList = rmiPriceRpcService.findPriceByParam(baseUomList);
        log.info("查询基本单位价格:{}", JSONUtil.toJsonStr(basePriceList));
        if (CollUtil.isNotEmpty(basePriceList)) {
            List<PriPriceRpcDTO> resultPriceList = basePriceList.stream().map(row -> {
                PriPriceRpcDTO priPriceRpcDTO = BeanUtils.copyProperties(row, PriPriceRpcDTO.class);
                ItmItemSimpleRpcDTO simpleItem = simpleItemMap.get(row.getItemId());
                if (simpleItem.getUomRatio2() == null) {
                    return null;
                }
                if (simpleItem.getDecimalPlaces() != null) {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()).setScale(simpleItem.getDecimalPlaces(), BigDecimal.ROUND_HALF_UP));
                } else {
                    priPriceRpcDTO.setPrice(row.getPrice().multiply(simpleItem.getUomRatio2()));
                }
                return priPriceRpcDTO;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            priceList.addAll(resultPriceList);
        }
    }

    private Map<String, List<OrderConfirmRespVO>> buildConfirmMap(List<OrderConfirmRespVO> confirmList) {
        if (CollUtil.isEmpty(confirmList)) {
            return new HashMap<>();
        }
        return confirmList.stream().collect(Collectors.groupingBy(row -> SysUtils.getItemKey(row.getCombineItemCode(), row.getItemCode()) + row.getActivityCode()));
    }

    private List<OrderConfirmRespVO> suppAllocStrategy(ScpStoreCartDO cartDO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag, Map<String, List<ScpSupplyAllocationRpcDTO>> supplyAllocationMap,
                                                       List<ItmPriPriceRpcDtoParam> priceParamList, AtomicReference<Map<String, BigDecimal>> stockMap) {
        List<OrderConfirmRespVO> result = new ArrayList<>();
        // 查询供应商配额
        List<ScpSupplyAllocationRpcDTO> suppAllocList = supplyAllocationMap.get(cartDO.getItemCode());
        log.info("供应商配额查询结果:{}", JSONUtil.toJsonStr(suppAllocList));
        if (CollUtil.isEmpty(suppAllocList)) {
            return new ArrayList<>();
        }
        // 销售价格
        for (ScpSupplyAllocationRpcDTO row : suppAllocList) {
            if (StrUtil.isBlank(row.getSaleOuCode())) {
                continue;
            }
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setPriceType(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setItemId(cartDO.getItemId());
            priceParam.setCustCode(row.getSaleCustCode());
            priceParam.setItemCode(cartDO.getItemCode());
            priceParam.setUom(cartDO.getUom());
            priceParam.setCurrCode(ScpConstant.CNY);
            priceParam.setOuCode(row.getSaleOuCode());
            priceParamList.add(priceParam);
        }
        int size = suppAllocList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; i++) {
            ScpSupplyAllocationRpcDTO row = suppAllocList.get(i);
            OrderConfirmRespVO orderConfirmRespVO = new OrderConfirmRespVO();
            orderConfirmRespVO.setItemId(cartDO.getItemId());
            orderConfirmRespVO.setItemCode(cartDO.getItemCode());
            orderConfirmRespVO.setItemName(cartDO.getItemName());
            orderConfirmRespVO.setSpuCode(cartDO.getSpuCode());
            orderConfirmRespVO.setSpuId(cartDO.getSpuId());
            orderConfirmRespVO.setSpuName(cartDO.getSpuName());
            orderConfirmRespVO.setUnitName(cartDO.getUomName());
            orderConfirmRespVO.setUnit(cartDO.getUom());
            orderConfirmRespVO.setSuppWhId(row.getSuppId());
            orderConfirmRespVO.setSuppWhCode(row.getSuppCode());
            orderConfirmRespVO.setSuppWhName(row.getSuppName());
            orderConfirmRespVO.setRatio(row.getAllocation());
            orderConfirmRespVO.setCurrency(ScpConstant.CNY);
            orderConfirmRespVO.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_SUPP.getValueCode());
            orderConfirmRespVO.setSaleOuCode(row.getSaleOuCode());
            orderConfirmRespVO.setSaleOuName(row.getSaleOuName());
            orderConfirmRespVO.setSaleCustCode(row.getSaleCustCode());
            orderConfirmRespVO.setOuId(row.getOuId());
            orderConfirmRespVO.setOuCode(row.getOuCode());
            orderConfirmRespVO.setOuName(row.getOuName());
            orderConfirmRespVO.setDemandQuantity(cartDO.getQty());
            orderConfirmRespVO.setActivityCode(cartDO.getActivityCode());
            orderConfirmRespVO.setActivityId(cartDO.getActivityId());
            stockMap.updateAndGet(currentMap -> {
                currentMap.put(cartDO.getItemCode(), new BigDecimal("9999"));
                return currentMap;
            });
            if (orgStore.getFreightFlag2() && freightFlag) {
                orderConfirmRespVO.setFreightFlag(Boolean.TRUE);
                orderConfirmRespVO.setFreightRatio(orgStore.getFreightRatio2());
            } else {
                orderConfirmRespVO.setFreightFlag(Boolean.FALSE);
                orderConfirmRespVO.setFreightRatio(BigDecimal.ZERO);
            }
            if (orderConfirmRespVO.getDemandQuantity() == null) {
                result.add(orderConfirmRespVO);
                continue;
            }
            if (i == size - 1) {
                orderConfirmRespVO.setAllocationDeQuantity(orderConfirmRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = orderConfirmRespVO.getDemandQuantity().multiply(orderConfirmRespVO.getRatio()).divide(BigDecimal.valueOf(100), 0, RoundingMode.HALF_DOWN);
                orderConfirmRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(orderConfirmRespVO);
        }
        return result;
    }

    private List<OrderConfirmRespVO> whnetStrategy(ScpStoreCartDO cartDO, OrgStoreBaseRpcDTO orgStore, Boolean freightFlag, Map<String, List<ScpWhNetRelationRpcDTO>> whNetRelationMap, List<ItmPriPriceRpcDtoParam> priceParamList) {
        List<OrderConfirmRespVO> result = new ArrayList<>();
        var whNetRelationRpcDTOList = whNetRelationMap.get(cartDO.getItemCode());
        log.info("商品编码：{},仓网供应关系信息：{}", cartDO.getItemCode(), JSONUtil.toJsonStr(whNetRelationRpcDTOList));
        if (CollUtil.isEmpty(whNetRelationRpcDTOList)) {
            return new ArrayList<>();
        }
        // 查询销售价格
        for (ScpWhNetRelationRpcDTO row : whNetRelationRpcDTOList) {
            if (StrUtil.isBlank(row.getOuCode())) {
                continue;
            }
            ItmPriPriceRpcDtoParam priceParam = new ItmPriPriceRpcDtoParam();
            priceParam.setPriceCls(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setPriceType(ScpConstant.INTERNAL_SETTLEMENT_PRICE);
            priceParam.setItemId(cartDO.getItemId());
            priceParam.setCustCode(row.getCustCode());
            priceParam.setItemCode(cartDO.getItemCode());
            priceParam.setUom(cartDO.getUom());
            priceParam.setCurrCode(ScpConstant.CNY);
            priceParam.setOuCode(row.getOuCode());
            priceParamList.add(priceParam);
        }
        int size = whNetRelationRpcDTOList.size();
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < size; i++) {
            ScpWhNetRelationRpcDTO row = whNetRelationRpcDTOList.get(i);
            OrderConfirmRespVO orderConfirmRespVO = new OrderConfirmRespVO();
            orderConfirmRespVO.setItemId(cartDO.getItemId());
            orderConfirmRespVO.setItemCode(cartDO.getItemCode());
            orderConfirmRespVO.setItemName(cartDO.getItemName());
            orderConfirmRespVO.setSpuId(cartDO.getSpuId());
            orderConfirmRespVO.setSpuCode(cartDO.getSpuCode());
            orderConfirmRespVO.setSpuName(cartDO.getSpuName());
            orderConfirmRespVO.setUnitName(cartDO.getUomName());
            orderConfirmRespVO.setUnit(cartDO.getUom());
            orderConfirmRespVO.setSuppWhId(row.getSupplyWhId());
            orderConfirmRespVO.setSuppWhCode(row.getSupplyWhCode());
            orderConfirmRespVO.setSuppWhName(row.getSupplyWhName());
            orderConfirmRespVO.setRatio(row.getSupplyPercentage());
            orderConfirmRespVO.setCurrency(ScpConstant.CNY);
            orderConfirmRespVO.setSupplyType(ScpUdcEnum.SUPPLY_DEMAND_TYPE_WH.getValueCode());
            orderConfirmRespVO.setDemandQuantity(cartDO.getQty());
            orderConfirmRespVO.setSaleOuName(row.getOuName());
            orderConfirmRespVO.setSaleOuCode(row.getOuCode());
            orderConfirmRespVO.setSaleCustCode(row.getCustCode());
            orderConfirmRespVO.setOuCode(row.getPurCompanyCode());
            orderConfirmRespVO.setOuName(row.getPurCompanyName());
            orderConfirmRespVO.setActivityCode(cartDO.getActivityCode());
            orderConfirmRespVO.setActivityId(cartDO.getActivityId());


            orderConfirmRespVO.setSuppId(cartDO.getSuppId());
            orderConfirmRespVO.setSuppCode(cartDO.getSuppCode());
            orderConfirmRespVO.setSuppName(cartDO.getSuppName());
            orderConfirmRespVO.setPrice(cartDO.getPrice());
            orderConfirmRespVO.setSalePrice(cartDO.getSalePrice());
            orderConfirmRespVO.setSettlementPrice(cartDO.getSettlementPrice());
            orderConfirmRespVO.setSettlementSalePrice(cartDO.getSettlementSalePrice());
            orderConfirmRespVO.setTefPrice(cartDO.getTefPrice());
            orderConfirmRespVO.setMefPrice(cartDO.getMefPrice());
            orderConfirmRespVO.setOefPrice(cartDO.getOefPrice());
            orderConfirmRespVO.setIsProjFeeCharged(cartDO.getIsProjFeeCharged());
            orderConfirmRespVO.setTefFeeOuCode(cartDO.getTefFeeOuCode());
            orderConfirmRespVO.setTefFeeOuName(cartDO.getTefFeeOuName());
            orderConfirmRespVO.setOefFeeOuCode(cartDO.getOefFeeOuCode());
            orderConfirmRespVO.setOefFeeOuName(cartDO.getOefFeeOuName());
            orderConfirmRespVO.setMefFeeOuCode(cartDO.getMefFeeOuCode());
            orderConfirmRespVO.setMefFeeOuName(cartDO.getMefFeeOuName());

            orderConfirmRespVO.setCombineItemCode(cartDO.getCombineItemCode());
            orderConfirmRespVO.setCombineItemName(cartDO.getCombineItemName());
//            if (orgStore.getFreightFlag() && freightFlag) {
//                orderConfirmRespVO.setFreightFlag(Boolean.TRUE);
//                orderConfirmRespVO.setFreightRatio(orgStore.getFreightRatio());
//            } else {
//                orderConfirmRespVO.setFreightFlag(Boolean.FALSE);
//                orderConfirmRespVO.setFreightRatio(BigDecimal.ZERO);
//            }
            if (orderConfirmRespVO.getDemandQuantity() == null) {
                result.add(orderConfirmRespVO);
                continue;
            }
            if (i == size - 1) {
                orderConfirmRespVO.setAllocationDeQuantity(orderConfirmRespVO.getDemandQuantity().subtract(sum));
            } else {
                BigDecimal ratioQty = orderConfirmRespVO.getDemandQuantity().multiply(orderConfirmRespVO.getRatio()).divide(BigDecimal.valueOf(100), 0, RoundingMode.HALF_DOWN);
                orderConfirmRespVO.setAllocationDeQuantity(ratioQty);
                sum = sum.add(ratioQty);
            }
            result.add(orderConfirmRespVO);
        }
        return result;

    }

    /**
     * 保存或更新购物车
     *
     * @param cartSaveVO
     * @param cartOps
     */
    private static void saveOrUpdateCart(StoreCartSaveVO cartSaveVO, BoundHashOperations<String, Object, Object> cartOps) {
        // 判断Redis是否有该商品的信息
        String product = (String) cartOps.get(SysUtils.generateRedisKey(ScpConstant.SKU, cartSaveVO.getCombineItemCode(), cartSaveVO.getItemCode()));
        if (StrUtil.isBlank(product) && cartSaveVO.getQty().compareTo(BigDecimal.ZERO) <= 0) {
            log.error("购物车中不存在此商品:{}，输入数量需要大于零", cartSaveVO.getItemCode());
            throw new BusinessException("购物车中不存在此商品，输入数量需要大于零");
        }
        if (StrUtil.isBlank(product)) {
            // 编辑购物车商品
            ScpStoreCartDO storeCartDO = ScpStoreCartConvert.INSTANCE.saveVoToDo(cartSaveVO);
            //添加购物车默认选中
            storeCartDO.setSelectedStatus(1);
            storeCartDO.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            // 购物车保存
            cartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, cartSaveVO.getCombineItemCode(), cartSaveVO.getItemCode()), JSON.toJSONString(storeCartDO));
        } else {
            // 添加商品数量=0时，删除采购车商品
            if (cartSaveVO.getQty().compareTo(BigDecimal.ZERO) == 0) {
                cartOps.delete(SysUtils.generateRedisKey(ScpConstant.SKU, cartSaveVO.getCombineItemCode(), cartSaveVO.getItemCode()));
            } else {
                // 购物车有此商品，修改数量即可
                var storeCartDO = JSON.parseObject(product, ScpStoreCartDO.class);
                storeCartDO.setQty(cartSaveVO.getQty());
                storeCartDO.setMoq(cartSaveVO.getMoq());
                String cartItemJson = JSON.toJSONString(storeCartDO);
                // 购物车保存
                cartOps.put(SysUtils.generateRedisKey(ScpConstant.SKU, storeCartDO.getCombineItemCode(), storeCartDO.getItemCode()), cartItemJson);
            }
        }
    }

    private Map<String, Boolean> setStoreDemandCalendarLimit(String storeCode, List<AppItmItemPageVO> itemList, String scpManType) {
        // 订货日历筛选 只有店员和店长会被限制
        Map<String, Boolean> result = new HashMap<>();

        // 默认不限制
        for (AppItmItemPageVO appItmItemPageVO : itemList) {
            result.put(appItmItemPageVO.getItemCode(), false);
        }
        String invisibleAccount = SysUtils.getInvisibleAccount();
        if (StrUtil.isNotBlank(scpManType) && StrUtil.isNotBlank(invisibleAccount)) {
            List<String> invisibleAccountList = Arrays.stream(invisibleAccount.split(",")).collect(Collectors.toList());
            log.info("不可见账号:{},当前账号:{}", JSONUtil.toJsonStr(invisibleAccountList), scpManType);
            // 当前用户的订货账号类型是否包含在配置里
            if (invisibleAccountList.contains(scpManType)) {
                //查询门店
                OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
                baseRpcParam.setStoreCodeList(List.of(storeCode));
                OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = orgStoreRpcService.findSimpleStoreByParam(baseRpcParam).computeData().get(0);

                // 订货日历筛选
                Map<String, List<AppItmItemPageVO>> deliveryTypeAndItemMap = itemList.stream().collect(Collectors.groupingBy(AppItmItemPageVO::getItemType2));
                Map<String, Boolean> canDeliveryMap = storeDemandCalendarDomainService.isCanDelivery(storeCode, orgStoreBaseRpcDTO.getRegion(), new ArrayList<>(deliveryTypeAndItemMap.keySet()));
                log.info("小程序可配送商品的配送类型:{}", JSONUtil.toJsonStr(canDeliveryMap));
                for (Map.Entry<String, List<AppItmItemPageVO>> entry : deliveryTypeAndItemMap.entrySet()) {
                    String deliveryType = entry.getKey();
                    List<AppItmItemPageVO> itemList1 = entry.getValue();
                    // 如果可以配送，则不被限制
                    if (canDeliveryMap != null && canDeliveryMap.get(deliveryType) != null && canDeliveryMap.get(deliveryType)) {
                        for (AppItmItemPageVO appItmItemPageVO : itemList1) {
                            result.put(appItmItemPageVO.getItemCode(), false);
                        }
                    } else {
                        // 其他情况都被限制
                        for (AppItmItemPageVO appItmItemPageVO : itemList1) {
                            result.put(appItmItemPageVO.getItemCode(), true);
                        }
                    }
                }
            }
        }
        log.info("小程序商品是否被限制:{}", JSONUtil.toJsonStr(result));
        return result;
    }
}
