package com.elitesland.scp.application.facade.vo.param.app;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(value = "商品列表查询入参")
public class CommonItemPageParamVO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -8387700128516698775L;

    @ApiModelProperty(value = "商品品类编码集合")
    private List<String> itemCateCodes;

    @ApiModelProperty(name = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "状态")
    private Boolean status;

    @ApiModelProperty(value = "类型")
    private String itemType;

    @ApiModelProperty(value = "品牌")
    private String brand;

    @ApiModelProperty(value = "商品编码集合")
    private List<String> itemCodes;

    @ApiModelProperty(value = "商品id集合")
    private List<Long> itemIds;

    @ApiModelProperty(name = "倒序/正序")
    private String asc;

    @ApiModelProperty(name = "排序字段")
    private String column;

    @ApiModelProperty(name = "关键词")
    private String keyword;

    private Long spuId;

    @ApiModelProperty(name = "商品分类", hidden = true)
    private List<String> itemTypes;

}
