package com.elitesland.scp.application.facade.vo.resp.msg;

import com.elitescloud.boot.common.param.CodeNameParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 消息分页信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Getter
@Setter
@ApiModel(description = "消息分页信息")
public class ScpMessagePageRespVO extends BaseScpMessageListRespVO {
    private static final long serialVersionUID = -4066049588882503615L;

    @ApiModelProperty(value = "是否置顶", position = 21)
    private Boolean top;

    @ApiModelProperty(value = "是否已发布", position = 22)
    private Boolean published;
    @ApiModelProperty(value = "发布时间", position = 22)
    private LocalDateTime publishTime;
    @ApiModelProperty(value = "失效时间", position = 22)
    private LocalDateTime invalidTime;

    @ApiModelProperty(value = "是否推送小程序", position = 23)
    private Boolean pushApplet;

    @ApiModelProperty(value = "门店编码", position = 24)
    private List<String> orgStoreCodes;

    @ApiModelProperty(value = "门店编", position = 25)
    private List<CodeNameParam> orgStores;

    @ApiModelProperty(value = "创建时间", position = 31)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改时间", position = 32)
    private LocalDateTime changeTime;

    @ApiModelProperty(value = "是否填写", position = 33)
    private boolean fillStatus;
}
