package com.elitesland.scp.application.web.msg;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.query.msg.ScpMessagePageMngQueryVO;
import com.elitesland.scp.application.facade.vo.resp.msg.ScpMessageEditRespVO;
import com.elitesland.scp.application.facade.vo.resp.msg.ScpMessagePageRespVO;
import com.elitesland.scp.application.facade.vo.save.msg.ScpMessageSaveVO;
import com.elitesland.scp.domain.service.msg.ScpMessageMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Set;

/**
 * 运营消息管理.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/28
 */
@Api(tags = "运营消息管理")
@RestController
@RequestMapping(value = "/mng/scpMessage", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class ScpMessageMngController {

    @Autowired
    private ScpMessageMngService service;

    @ApiOperation(value = "保存消息")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/save")
    public ApiResult<Long> save(@RequestBody @Valid ScpMessageSaveVO saveVO) {
        return service.save(saveVO);
    }

    @ApiOperation(value = "假删除消息")
    @ApiOperationSupport(order = 2)
    @DeleteMapping(value = "/deleteFake")
    public ApiResult<Set<Long>> deleteFake(@RequestBody @NotEmpty(message = "消息ID为空") Set<Long> ids) {
        return service.delete(ids, false);
    }

    @ApiOperation(value = "删除消息")
    @ApiOperationSupport(order = 2)
    @DeleteMapping(value = "/delete")
    public ApiResult<Set<Long>> delete(@RequestBody @NotEmpty(message = "消息ID为空") Set<Long> ids) {
        return service.delete(ids, true);
    }

    @ApiOperation(value = "发布消息")
    @ApiOperationSupport(order = 3)
    @PatchMapping(value = "/publish")
    public ApiResult<Set<Long>> execPublish(@RequestBody @NotEmpty(message = "消息ID为空") Set<Long> ids) {
        return service.execPublish(ids);
    }

    @ApiOperation(value = "撤回消息")
    @ApiOperationSupport(order = 4)
    @PatchMapping(value = "/revoke")
    public ApiResult<Set<Long>> execRevoke(@RequestBody @NotEmpty(message = "消息ID为空") Set<Long> ids) {
        return service.execRevoke(ids);
    }

    @ApiOperation(value = "获取消息详细信息")
    @ApiOperationSupport(order = 5)
    @ApiImplicitParam(name = "id", value = "消息ID", dataType = "long", required = true)
    @GetMapping(value = "/edit")
    public ApiResult<ScpMessageEditRespVO> getEditVO(@RequestParam(name = "id") @NotNull(message = "消息ID为空") Long id) {
        return service.getEditVO(id);
    }

    @ApiOperation(value = "分页查询")
    @ApiOperationSupport(order = 6)
    @PostMapping(value = "/pageMng")
    public ApiResult<PagingVO<ScpMessagePageRespVO>> pageMng(@RequestBody ScpMessagePageMngQueryVO queryVO) {
        return service.pageMng(queryVO);
    }
}
