package com.elitesland.scp.infr.repo.whnet;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemPageParamVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationExportRespVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationPageParamVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationPageVO;
import com.elitesland.scp.application.facade.vo.whnet.ScpWhNetRelationRespVO;
import com.elitesland.scp.domain.entity.whnet.QScpWhNetRelationDO;
import com.elitesland.scp.domain.entity.whnet.ScpWhNetRelationDO;
import com.elitesland.scp.dto.whnet.ScpWhNetRelationRpcDTO;
import com.elitesland.scp.param.ScpWhNetRelationParam;
import com.elitesland.scp.param.ScpWhNetRelationRpcDtoParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.val;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
 * @description:
 * @author: jeesie.jiang
 * @create: 2024-03-20
 * @Version 1.0
 **/
@Component
public class ScpWhNetRelationRepoProc extends BaseRepoProc<ScpWhNetRelationDO> {

    private static final QScpWhNetRelationDO qScpWhNetRelationDO = QScpWhNetRelationDO.scpWhNetRelationDO;

    public ScpWhNetRelationRepoProc() {
        super(qScpWhNetRelationDO);
    }


    public PagingVO<ScpWhNetRelationPageVO> page(ScpWhNetRelationPageParamVO param) {
        val jpaQuery = jpaQueryFactory.select(getBean()).from(qScpWhNetRelationDO);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return queryByPage(jpaQuery, param.getPageRequest());
    }


    @NotNull
    private QBean<ScpWhNetRelationPageVO> getBean() {
        return Projections.bean(
                ScpWhNetRelationPageVO.class,
                qScpWhNetRelationDO.id,
                qScpWhNetRelationDO.supplyWhId,
                qScpWhNetRelationDO.supplyWhCode,
                qScpWhNetRelationDO.supplyWhName,
                qScpWhNetRelationDO.demandWhStId,
                qScpWhNetRelationDO.demandWhStCode,
                qScpWhNetRelationDO.demandWhStName,
                qScpWhNetRelationDO.itemId,
                qScpWhNetRelationDO.itemCode,
                qScpWhNetRelationDO.itemName,
                qScpWhNetRelationDO.itemCateCode,
                qScpWhNetRelationDO.itemCateName,
                qScpWhNetRelationDO.supplyPercentage,
                qScpWhNetRelationDO.transferLeadTime,
                qScpWhNetRelationDO.startTime,
                qScpWhNetRelationDO.endTime,
                qScpWhNetRelationDO.type,
                qScpWhNetRelationDO.status,
                qScpWhNetRelationDO.createTime,
                qScpWhNetRelationDO.createUserId,
                qScpWhNetRelationDO.createUserId,
                qScpWhNetRelationDO.modifyUserId,
                qScpWhNetRelationDO.modifyTime,
                qScpWhNetRelationDO.updater,
                qScpWhNetRelationDO.remark,
                qScpWhNetRelationDO.tenantId,
                qScpWhNetRelationDO.ouCode,
                qScpWhNetRelationDO.ouName,
                qScpWhNetRelationDO.deliveryType,
                qScpWhNetRelationDO.purCompanyCode,
                qScpWhNetRelationDO.purCompanyName
//                qScpWhNetRelationDO.effectiveDate,
//                qScpWhNetRelationDO.invalidDate
        );
    }

    private Predicate where(ScpWhNetRelationPageParamVO param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (CollectionUtils.isNotEmpty(param.getItemIds())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.itemId.in(param.getItemIds()));
        }
        if (CollectionUtils.isNotEmpty(param.getItemCateCodes())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.itemCateCode.in(param.getItemCateCodes()));
        }

        if (CollectionUtils.isNotEmpty(param.getDemandWhStIds())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.demandWhStId.in(param.getDemandWhStIds()));
        }
        if (CollectionUtils.isNotEmpty(param.getTypes())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.type.in(param.getTypes()));
        }

        if (CollectionUtils.isNotEmpty(param.getSupplyWhIds())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.supplyWhId.in(param.getSupplyWhIds()));
        }
        if (StringUtils.isNotEmpty(param.getDemandWhStName())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.demandWhStName.like("%" + param.getDemandWhStName() + "%"));
        }
        if (CollUtil.isNotEmpty(param.getIdSet())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.id.in(param.getIdSet()));
        }
        if (CollUtil.isNotEmpty(param.getOuCodes())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.ouCode.in(param.getOuCodes()));
        }
        if (CollUtil.isNotEmpty(param.getDeliveryTypes())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.deliveryType.in(param.getDeliveryTypes()));
        }
        if (CollUtil.isNotEmpty(param.getWhIds()) && CollUtil.isNotEmpty(param.getStoreIds())) {
            Predicate predicate1 = ExpressionUtils.or(
                    qScpWhNetRelationDO.supplyWhId.in(param.getWhIds()),
                    qScpWhNetRelationDO.type.eq("1").and(qScpWhNetRelationDO.demandWhStId.in(param.getWhIds()))
            );
            Predicate predicate2 = ExpressionUtils.and(qScpWhNetRelationDO.type.eq("0"),
                    qScpWhNetRelationDO.demandWhStId.in(param.getStoreIds()));
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(predicate1, predicate2));
        } else if (CollUtil.isNotEmpty(param.getWhIds()) && CollUtil.isEmpty(param.getStoreIds())) {
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    qScpWhNetRelationDO.supplyWhId.in(param.getWhIds()),
                    qScpWhNetRelationDO.demandWhStId.in(param.getWhIds()).and(qScpWhNetRelationDO.type.eq("1")))
            );
        } else if (CollUtil.isEmpty(param.getWhIds()) && CollUtil.isNotEmpty(param.getStoreIds())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.type.eq("0"));
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.demandWhStId.in(param.getStoreIds()));
        }
        return predicate;

    }

    public List<ScpWhNetRelationRpcDTO> findWhNetRelationRpcDtoByParam(ScpWhNetRelationRpcDtoParam param) {
        JPAQuery<ScpWhNetRelationRpcDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpWhNetRelationRpcDTO.class,
                qScpWhNetRelationDO.id,
                qScpWhNetRelationDO.supplyWhId,
                qScpWhNetRelationDO.supplyWhCode,
                qScpWhNetRelationDO.supplyWhName,
                qScpWhNetRelationDO.demandWhStId,
                qScpWhNetRelationDO.demandWhStCode,
                qScpWhNetRelationDO.demandWhStName,
                qScpWhNetRelationDO.itemId,
                qScpWhNetRelationDO.itemCode,
                qScpWhNetRelationDO.itemName,
                qScpWhNetRelationDO.itemCateCode,
                qScpWhNetRelationDO.itemCateName,
                qScpWhNetRelationDO.supplyPercentage,
                qScpWhNetRelationDO.transferLeadTime,
                qScpWhNetRelationDO.startTime,
                qScpWhNetRelationDO.endTime,
                qScpWhNetRelationDO.type,
                qScpWhNetRelationDO.ouCode,
                qScpWhNetRelationDO.ouName,
                qScpWhNetRelationDO.purCompanyCode,
                qScpWhNetRelationDO.purCompanyName,
                qScpWhNetRelationDO.custCode,
                qScpWhNetRelationDO.deliveryType
        )).from(qScpWhNetRelationDO);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return jpaQuery.fetch();

    }

    public List<String> findSaleOuInfo(String storeCode) {
        return jpaQueryFactory.select(qScpWhNetRelationDO.ouCode)
                .from(qScpWhNetRelationDO).where(qScpWhNetRelationDO.demandWhStCode.eq(storeCode)
                        .and(qScpWhNetRelationDO.type.eq("0"))
                        .and(qScpWhNetRelationDO.status.eq(Boolean.TRUE))).fetch();
    }

    private Predicate where(ScpWhNetRelationRpcDtoParam param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.status.eq(Boolean.TRUE));
        if (StringUtils.isNotEmpty(param.getType())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.type.eq(param.getType()));
        }
        if (StringUtils.isNotEmpty(param.getDemandWhStCode())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.demandWhStCode.eq(param.getDemandWhStCode()));
        }
        if (StringUtils.isNotEmpty(param.getItemCateCode())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.itemCateCode.eq(param.getItemCateCode()).or(qScpWhNetRelationDO.itemCateCode.isNull()));
        }
        if (StringUtils.isNotEmpty(param.getItemCode())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.itemCode.eq(param.getItemCode()).or(qScpWhNetRelationDO.itemCode.isNull()));
        }
        if (CollUtil.isNotEmpty(param.getItemCodes())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.itemCode.in(param.getItemCodes()).or(qScpWhNetRelationDO.itemCode.isNull()));
        }
        if (CollectionUtils.isNotEmpty(param.getOuCodes())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.ouCode.in(param.getOuCodes()));
        }
        if (CollectionUtils.isNotEmpty(param.getDeliveryTypes())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.deliveryType.in(param.getDeliveryTypes()));
        }
        if (param.getValidDate() != null) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.startTime.loe(param.getValidDate())
                    .or(qScpWhNetRelationDO.startTime.isNull()));
        }
        if (param.getValidDate() != null) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.endTime.goe(param.getValidDate())
                    .or(qScpWhNetRelationDO.endTime.isNull()));
        }
        return predicate;

    }

    public PagingVO<ScpWhNetRelationExportRespVO> exportSearch(ScpWhNetRelationPageParamVO param) {
        val jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpWhNetRelationExportRespVO.class,
                qScpWhNetRelationDO.supplyWhId,
                qScpWhNetRelationDO.supplyWhCode,
                qScpWhNetRelationDO.supplyWhName,
                qScpWhNetRelationDO.demandWhStId,
                qScpWhNetRelationDO.demandWhStCode,
                qScpWhNetRelationDO.demandWhStName,
                qScpWhNetRelationDO.itemId,
                qScpWhNetRelationDO.itemCode,
                qScpWhNetRelationDO.itemName,
                qScpWhNetRelationDO.itemCateCode,
                qScpWhNetRelationDO.itemCateName,
                qScpWhNetRelationDO.supplyPercentage,
                qScpWhNetRelationDO.transferLeadTime,
                qScpWhNetRelationDO.status,
                qScpWhNetRelationDO.type,
                qScpWhNetRelationDO.createTime,
                qScpWhNetRelationDO.ouCode,
                qScpWhNetRelationDO.ouName,
                qScpWhNetRelationDO.deliveryType
        )).from(qScpWhNetRelationDO);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return queryByPage(jpaQuery, param.getPageRequest());
    }


    public PagingVO<ScpWhNetRelationPageVO> queryitemByStoreCode(AppItemPageParamVO param) {
        val jpaQuery = jpaQueryFactory.select(getBean()).from(qScpWhNetRelationDO);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return queryByPage(jpaQuery, param.getPageRequest());
    }

    private Predicate where(AppItemPageParamVO param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (StringUtils.isNotEmpty(param.getStoreCode())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.demandWhStCode.eq(param.getStoreCode()));
        }
//        if(CollectionUtils.isNotEmpty(param.getItemCateCodes())){
//            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.itemCateCode.in(param.getItemCateCode()));
//        }
        if (StringUtils.isNotEmpty(param.getItemName())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.itemName.like("%" + param.getItemName() + "%"));
        }
        if (StringUtils.isNotEmpty(param.getItemCode())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.itemCode.like("%" + param.getItemCode() + "%"));
        }
        if (CollectionUtils.isNotEmpty(param.getItemCodes())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.itemCode.in(param.getItemCodes()));
        }
        if (CollectionUtils.isNotEmpty(param.getItemIds())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.itemId.in(param.getItemIds()));
        }
        if (StrUtil.isNotBlank(param.getKeyword())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.demandWhStCode.like("%" + param.getKeyword() + "%").or(qScpWhNetRelationDO.demandWhStName.like("%" + param.getKeyword() + "%")));
        }
        return predicate;

    }

    @Transactional(rollbackFor = Exception.class)
    public Long updateStoreNameByStoreId(Long storeId, String storeName) {
        return jpaQueryFactory.update(qScpWhNetRelationDO)
                .set(qScpWhNetRelationDO.demandWhStName, storeName)
                .where(qScpWhNetRelationDO.demandWhStId.eq(storeId))
                .execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public Long updateItemNameByItemId(Long itemId, String itemName) {
        return jpaQueryFactory.update(qScpWhNetRelationDO)
                .set(qScpWhNetRelationDO.itemName, itemName)
                .where(qScpWhNetRelationDO.itemId.eq(itemId))
                .execute();
    }

    public List<ScpWhNetRelationRespVO> findValidWhNetRelationByParam(List<Long> itemIds, String storeCode, LocalDateTime dateTime) {
        return jpaQueryFactory.select(Projections.bean(
                        ScpWhNetRelationRespVO.class,
                        qScpWhNetRelationDO.supplyWhId,
                        qScpWhNetRelationDO.supplyWhCode,
                        qScpWhNetRelationDO.demandWhStId,
                        qScpWhNetRelationDO.demandWhStCode,
                        qScpWhNetRelationDO.itemId,
                        qScpWhNetRelationDO.itemCode

                )).from(qScpWhNetRelationDO)
                .where(
                        qScpWhNetRelationDO.itemId.in(itemIds)
                                .and(qScpWhNetRelationDO.demandWhStCode.eq(storeCode))
                                .and(qScpWhNetRelationDO.type.eq("0"))
                                .and(qScpWhNetRelationDO.status.eq(true))
                                .and(qScpWhNetRelationDO.startTime.loe(dateTime))
                                .and(qScpWhNetRelationDO.endTime.goe(dateTime))

                ).orderBy(qScpWhNetRelationDO.createTime.desc()).fetch();
    }

    public List<ScpWhNetRelationRespVO> findValidWhNetRelationByParam2(String itemType, String storeCode, LocalDateTime dateTime) {
        return jpaQueryFactory.select(Projections.bean(
                        ScpWhNetRelationRespVO.class,
                        qScpWhNetRelationDO.supplyWhId,
                        qScpWhNetRelationDO.supplyWhCode,
                        qScpWhNetRelationDO.demandWhStId,
                        qScpWhNetRelationDO.demandWhStCode,
                        qScpWhNetRelationDO.itemId,
                        qScpWhNetRelationDO.itemCode

                )).from(qScpWhNetRelationDO)
                .where(qScpWhNetRelationDO.deliveryType.eq(itemType)
                        .and(qScpWhNetRelationDO.demandWhStCode.eq(storeCode))
                        .and(qScpWhNetRelationDO.itemId.isNull())
                        .and(qScpWhNetRelationDO.type.eq("0"))
                        .and(qScpWhNetRelationDO.status.eq(true))
                        .and(qScpWhNetRelationDO.startTime.loe(dateTime))
                        .and(qScpWhNetRelationDO.endTime.goe(dateTime))

                ).orderBy(qScpWhNetRelationDO.createTime.desc()).fetch();
    }


    public List<ScpWhNetRelationRpcDTO> outFindWhNetRelationRpcDtoByParam(ScpWhNetRelationParam whNetRelationParam) {
        JPAQuery<ScpWhNetRelationRpcDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                ScpWhNetRelationRpcDTO.class,
                qScpWhNetRelationDO.id,
                qScpWhNetRelationDO.supplyWhId,
                qScpWhNetRelationDO.supplyWhCode,
                qScpWhNetRelationDO.supplyWhName,
                qScpWhNetRelationDO.demandWhStId,
                qScpWhNetRelationDO.demandWhStCode,
                qScpWhNetRelationDO.demandWhStName,
                qScpWhNetRelationDO.itemId,
                qScpWhNetRelationDO.itemCode,
                qScpWhNetRelationDO.itemName,
                qScpWhNetRelationDO.itemCateCode,
                qScpWhNetRelationDO.itemCateName,
                qScpWhNetRelationDO.supplyPercentage,
                qScpWhNetRelationDO.transferLeadTime,
                qScpWhNetRelationDO.startTime,
                qScpWhNetRelationDO.endTime,
                qScpWhNetRelationDO.type,
                qScpWhNetRelationDO.ouCode,
                qScpWhNetRelationDO.ouName,
                qScpWhNetRelationDO.purCompanyCode,
                qScpWhNetRelationDO.purCompanyName,
                qScpWhNetRelationDO.custCode,
                qScpWhNetRelationDO.deliveryType
        )).from(qScpWhNetRelationDO);
        if (whNetRelationParam != null) {
            jpaQuery.where(outWhere(whNetRelationParam));
        }
        return jpaQuery.fetch();
    }

    private Predicate outWhere(ScpWhNetRelationParam param) {
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (CollectionUtils.isNotEmpty(param.getStoreCodeList())) {
            predicate = ExpressionUtils.and(predicate, qScpWhNetRelationDO.demandWhStCode.in(param.getStoreCodeList()));
        }
        return predicate;

    }

    public List<ScpWhNetRelationRespVO> findAllNotItem() {
        return jpaQueryFactory.select(Projections.bean(
                        ScpWhNetRelationRespVO.class,
                        qScpWhNetRelationDO.supplyWhId,
                        qScpWhNetRelationDO.supplyWhCode,
                        qScpWhNetRelationDO.demandWhStId,
                        qScpWhNetRelationDO.demandWhStCode,
                        qScpWhNetRelationDO.deliveryType
                )).from(qScpWhNetRelationDO)
                .where(qScpWhNetRelationDO.itemId.isNull()
                                .and(qScpWhNetRelationDO.type.eq("0"))
                                .and(qScpWhNetRelationDO.status.eq(true))).fetch();
    }

    public List<ScpWhNetRelationDO> findByAllBusinessKey(String demandWhStCode, String deliveryType, String itemCateCode, String itemCode) {
        JPAQuery<ScpWhNetRelationDO> where = jpaQueryFactory.select(qScpWhNetRelationDO).from(qScpWhNetRelationDO)
                .where(qScpWhNetRelationDO.deleteFlag.eq(0).or(qScpWhNetRelationDO.deleteFlag.isNull()));
        if (StringUtils.isNotBlank(demandWhStCode)) {
            where.where(qScpWhNetRelationDO.demandWhStCode.eq(demandWhStCode));
        } else {
            where.where(qScpWhNetRelationDO.demandWhStCode.isNull());
        }
        if (StringUtils.isNotBlank(deliveryType)) {
            where.where(qScpWhNetRelationDO.deliveryType.eq(deliveryType));
        } else {
            where.where(qScpWhNetRelationDO.deliveryType.isNull());
        }
        if (StringUtils.isNotBlank(itemCateCode)) {
            where.where(qScpWhNetRelationDO.itemCateCode.eq(itemCateCode));
        } else {
            where.where(qScpWhNetRelationDO.itemCateCode.isNull());
        }
        if (StringUtils.isNotBlank(itemCode)) {
            where.where(qScpWhNetRelationDO.itemCode.eq(itemCode));
        } else {
            where.where(qScpWhNetRelationDO.itemCode.isNull());
        }
        return where.fetch();
    }


    public List<ScpWhNetRelationDO> findByConcatKey(Collection<String> storeCodeSet,
                                                    Collection<String> deliverySet,
                                                    Collection<String> itemCodeSet,
                                                    Collection<String> itemCateCodeSet) {
        JPAQuery<ScpWhNetRelationDO> where = jpaQueryFactory.select(qScpWhNetRelationDO).from(qScpWhNetRelationDO)
                .where(qScpWhNetRelationDO.deleteFlag.eq(0).or(qScpWhNetRelationDO.deleteFlag.isNull()));
        if (CollectionUtils.isNotEmpty(storeCodeSet)) {
            where.where(qScpWhNetRelationDO.demandWhStCode.in(storeCodeSet));
        } else {
            where.where(qScpWhNetRelationDO.demandWhStCode.isNull());
        }

        if (CollectionUtils.isNotEmpty(deliverySet)) {
            where.where(qScpWhNetRelationDO.deliveryType.in(deliverySet));
        } else {
            where.where(qScpWhNetRelationDO.deliveryType.isNull());
        }

        if (CollectionUtils.isNotEmpty(itemCodeSet)) {
            where.where(qScpWhNetRelationDO.itemCode.in(itemCodeSet));
        } else {
            where.where(qScpWhNetRelationDO.itemCode.isNull());
        }

        if (CollectionUtils.isNotEmpty(itemCateCodeSet)) {
            where.where(qScpWhNetRelationDO.itemCateCode.in(itemCateCodeSet));
        } else {
            where.where(qScpWhNetRelationDO.itemCateCode.isNull());
        }

        return where.fetch();
    }
}