package com.elitesland.scp.application.facade.vo.cart;

import com.alibaba.fastjson.annotation.JSONField;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.scp.utils.SysUtils;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/26 16:58
 * @Description:
 */
@Data
@ApiModel("采购车详情结果")
public class CartDetailRespVO implements Serializable {

    @ApiModelProperty("商品SPU编码")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("商品SPU编码")
    private String spuCode;

    @ApiModelProperty("商品SPU名称")
    private String spuName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty("是否收藏，是：true, 否：false")
    private Boolean collectFlag;

    @ApiModelProperty("是否允许打折,0:不允许,1:允许")
    private Boolean allowDiscount;

    private List<ItemSpecObjectVO> itemSpecObjectVOS;

    @ApiModelProperty("组合商品标识")
    private Boolean combineItemFlag;

    @ApiModelProperty("组合商品编码")
    private String combineItemCode;

    @ApiModelProperty("组合商品名称")
    private String combineItemName;

    @ApiModelProperty(value = "组合数量")
    private BigDecimal combineQty;

    @ApiModelProperty("强配活动Id")
    private Long activityId;

    @ApiModelProperty(value = "强配活动编码")
    private String activityCode;

    private List<CartDetailRespVO> subItemList;

    @Data
    public static class ItemSpecObjectVO {

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("单位名称")
        private String uomName;

        @ApiModelProperty("商品规格ID(SKU-ID)")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long itemId;

        @ApiModelProperty("商品规格编码(SKU编码)")
        private String itemCode;

        @ApiModelProperty("商品规格名称(SKU名称)")
        private String itemName;

        @ApiModelProperty("含税单价")
        private BigDecimal itemPrice;

        @ApiModelProperty("数量")
        private BigDecimal qty;

        @ApiModelProperty("库存数量")
        private BigDecimal avalQty;

        @ApiModelProperty("选中状态 0-未选中 1-选中")
        private Integer status;

        @ApiModelProperty("基本单位")
        private String uom2;
        @ApiModelProperty(value = "基本单位名称")
        private String uom2Name;

        @ApiModelProperty("单位转换系数")
        private BigDecimal uomRatio;

        @ApiModelProperty("有效位数")
        private Integer decimalPlaces;

        @ApiModelProperty(value = "商品分类")
        private String itemType;

        @ApiModelProperty(value = "商品分类2")
        @SysCode(sys = "yst-suplan", mod = "ITEM_TYPE2")
        private String itemType2;
        private String itemType2Name;

        @ApiModelProperty(value = "包装规格")
        private String itemAttrName;

        @ApiModelProperty(value = "最小起订量")
        private BigDecimal moq;

        @ApiModelProperty("供应商ID")
        private Long suppId;

        @ApiModelProperty("供应商编码")
        private String suppCode;

        @ApiModelProperty("供应商名称")
        private String suppName;

        @ApiModelProperty("门店编码")
        private String storeCode;

        @ApiModelProperty("仓配结算价")
        private BigDecimal costPrice;

        @ApiModelProperty("采购价")
        private BigDecimal purPrice;

        @ApiModelProperty("总价格")
        private BigDecimal price;

        @ApiModelProperty("销售单价（不含服务费）")
        private BigDecimal salePrice;

        @ApiModelProperty("科技费价格")
        private BigDecimal tefPrice;

        @ApiModelProperty("科技费商品")
        private String tefItemCode;

        @ApiModelProperty("营销费价格")
        private BigDecimal mefPrice;

        @ApiModelProperty("营销费商品")
        private String mefItemCode;

        @ApiModelProperty("运营费价格")
        private BigDecimal oefPrice;

        @ApiModelProperty("运营费商品")
        private String oefItemCode;

        @ApiModelProperty("是否收取项目费用")
        private Boolean isProjFeeCharged;

        @ApiModelProperty("打折方式")
        @SysCode(sys = "yst-suplan", mod = "DISCOUNT_TYPE")
        private String discountType;
        private String discountTypeName;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuCode;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuCode;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuCode;

        @ApiModelProperty("科技服务费用归属公司")
        private String tefFeeOuName;

        @ApiModelProperty("运营费服务费用归属公司")
        private String oefFeeOuName;

        @ApiModelProperty("营销费服务费用归属公司")
        private String mefFeeOuName;

        @ApiModelProperty("折扣比例")
        private BigDecimal discount;

        @ApiModelProperty("结算单价")
        private BigDecimal settlementPrice;

        @ApiModelProperty("结算货款单价")
        private BigDecimal settlementSalePrice;

        @ApiModelProperty("预售状态")
        private Boolean preSaleStatus;

        @ApiModelProperty("是否被门店订货日历限制")
        private Boolean calendarLimit;

        public BigDecimal getTotalAmt() {
            BigDecimal price = this.itemPrice == null ? BigDecimal.ZERO : this.itemPrice;
            BigDecimal qty = this.qty == null ? BigDecimal.ZERO : this.qty;
            return SysUtils.processAmtScale(price.multiply(qty));
        }
    }

    @ApiModelProperty("选中状态 0-未选中 1-选中，当子项全部为1是此值为1，否则为0")
    private Integer status;

    @ApiModelProperty("spu规格型号")
    private String spec;

    @ApiModelProperty("图片url")
    private String url;

    private String fileCode;

    @ApiModelProperty("金额小计")
    private BigDecimal totalAmt;
}
