package com.elitesland.scp.domain.entity.purLimit;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ScpPurLimitSettingRedisDO implements Serializable {
    private static final long serialVersionUID = -4892561478153648138L;

    private List<ActivityDO> activityList;

    @Data
    public static class ActivityDO {

        private Long activityId;

        private String activityCode;

        @JSONField(format = "yyyy-MM-dd HH:mm:ss")
        private LocalDateTime validFrom;

        @JSONField(format = "yyyy-MM-dd HH:mm:ss")
        private LocalDateTime validTo;

        @JSONField(format = "yyyy-MM-dd HH:mm:ss")
        private LocalDateTime modifiedTime;

        @ApiModelProperty("最大强配次数")
        private Integer maxNum;

        @ApiModelProperty("已配次数")
        private Integer activeNum;

        private Boolean enabled;

        private List<String> docTypes;

        private List<InnerItemDO> innerItemDOS;

        @Data
        public static class InnerItemDO {

            @ApiModelProperty("活动ID")
            private Long masId;

            @ApiModelProperty("商品ID")
            private Long itemId;

            @ApiModelProperty("商品编码")
            private String itemCode;

            @ApiModelProperty("商品名称")
            private String itemName;

            @ApiModelProperty("商品分类")
            private String itemType2;

            @ApiModelProperty("最小强配数量")
            private BigDecimal minNum;

            @ApiModelProperty("图片")
            private String imgUrl;
        }
    }
}
