package com.elitesland.scp.infr.repo.item;

import com.elitesland.scp.domain.entity.item.ScpCateItemSaleScopeRegionDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;

public interface ScpCateItemSaleScopeRegionRepo extends JpaRepository<ScpCateItemSaleScopeRegionDO, Long>, QuerydslPredicateExecutor<ScpCateItemSaleScopeRegionDO> {


    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "delete from scp_cate_item_sale_scope_region where mas_id in ?1", nativeQuery = true)
    void deleteByMasIdIn(Collection<Long> masIdList);

    List<ScpCateItemSaleScopeRegionDO> findAllByMasId(Long masId);

    List<ScpCateItemSaleScopeRegionDO> findAllByRegionCode(String regionCode);
}
