package com.elitesland.scp.pay.service;


import com.elitesland.scp.pay.vo.OnlinePayOrderParamVO;
import com.elitesland.scp.pay.vo.PayOrderReqDTO;
import com.tenpay.business.entpay.mse.sdk.api.Payment;
import com.tenpay.business.entpay.mse.sdk.api.Redirect;
import com.tenpay.business.entpay.mse.sdk.exception.EntpayException;
import org.springframework.boot.configurationprocessor.json.JSONException;

public interface PaymentService {

    /**
     * 小程序支付下单
     *
     * @return
     */
    Payment createMpPay(PayOrderReqDTO param) throws EntpayException;

    /**
     * 小程序支付下单-在线
     *
     * @return
     */
    Redirect createMpPayOnline(OnlinePayOrderParamVO param);

    /**
     * 支付回调
     *
     * @param body
     * @param authorization
     * @return
     */
    String paymentNotify(String body, String authorization) throws EntpayException, JSONException;

    /**
     * 二维码支付下单
     *
     * @return
     */
    Payment createQrCodePay(PayOrderReqDTO param) throws EntpayException;

    /**
     * 二维码支付下单-在线
     *
     * @return
     */
    Redirect createQrCodePayOnline(OnlinePayOrderParamVO param);

}
