/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.JSONUtil;
import com.elitesland.scp.application.enums.ScpUdcEnum;
import com.elitesland.scp.application.facade.vo.param.app.AppStorePasswordModifyParamVO;
import com.elitesland.scp.application.facade.vo.param.app.AppStorePasswordPaymentParamVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.app.AppStorePasswordPaymentService;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.bo.ScpsmanRegionBO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.enums.UdcEnum;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanRegionRepoProc;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.param.OrgStorePasswordModifyRpcParam;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AppStorePasswordPaymentServiceImpl
implements AppStorePasswordPaymentService {
    private static final Logger log = LoggerFactory.getLogger(AppStorePasswordPaymentServiceImpl.class);
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpsmanInfoRepoProc scpsmanInfoRepoProc;
    private final ScpsmanRegionRepoProc scpsmanRegionRepoProc;

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void setPassword(AppStorePasswordPaymentParamVO param) {
        this.verifyScpmanAuthority(param.getStoreCode());
        OrgStorePasswordModifyRpcParam passwordModifyRpcParam = new OrgStorePasswordModifyRpcParam();
        passwordModifyRpcParam.setFlag(Integer.valueOf(0));
        passwordModifyRpcParam.setNewPayPassword(param.getPayPassword());
        passwordModifyRpcParam.setStoreCode(param.getStoreCode());
        this.orgStoreRpcService.setStorePayPassword(passwordModifyRpcParam).computeData();
    }

    @Override
    public void modifyPassword(AppStorePasswordModifyParamVO param) {
        this.verifyScpmanAuthority(param.getStoreCode());
        OrgStorePasswordModifyRpcParam passwordModifyRpcParam = new OrgStorePasswordModifyRpcParam();
        passwordModifyRpcParam.setFlag(Integer.valueOf(1));
        passwordModifyRpcParam.setNewPayPassword(param.getPayPassword());
        passwordModifyRpcParam.setOldPayPassword(param.getOldPayPassword());
        passwordModifyRpcParam.setStoreCode(param.getStoreCode());
        log.info("\u4fee\u6539\u652f\u4ed8\u5bc6\u7801\u5165\u53c2\uff1a{}", (Object)passwordModifyRpcParam);
        this.orgStoreRpcService.setStorePayPassword(passwordModifyRpcParam).computeData();
    }

    private void verifyScpmanAuthority(String param) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        ScpsmanInfoDO scpsmanInfo = this.scpsmanInfoRepoProc.getByScpsmanNo(currentUserDTO.getDetail().getUsername());
        Assert.notNull((Object)((Object)scpsmanInfo), (String)"\u8ba1\u5212\u5458\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        if (!ObjectUtil.equal((Object)scpsmanInfo.getScpsmanType(), (Object)UdcEnum.SALE_SCPSMAN_TYPE_SHOPOWNER.getValueCode())) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u65e0\u95e8\u5e97\u652f\u4ed8\u5bc6\u7801\u4fee\u6539\u6743\u9650");
        }
        if (Boolean.TRUE.equals(scpsmanInfo.getJurisdictionAll())) {
            return;
        }
        List<ScpsmanRegionBO> scpsmanRegionList = this.scpsmanRegionRepoProc.listBoByMasId(scpsmanInfo.getId());
        if (scpsmanRegionList.isEmpty()) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u65e0\u8be5\u95e8\u5e97\u7684\u64cd\u4f5c\u6743\u9650");
        }
        HashSet<String> regionCodes = new HashSet<String>(scpsmanRegionList.size());
        for (ScpsmanRegionBO bo : scpsmanRegionList) {
            if (StrUtil.isBlank((CharSequence)bo.getRegionCode())) continue;
            if (ScpUdcEnum.SCPSMAN_REGION_TYPE_STORE.getValueCode().equals(bo.getRegionType())) {
                if (!bo.getRegionCode().equals(param)) continue;
                return;
            }
            if (!ScpUdcEnum.SCPSMAN_REGION_TYPE_REGION.getValueCode().equals(bo.getRegionType())) continue;
            regionCodes.add(bo.getRegionCode());
        }
        if (!regionCodes.isEmpty()) {
            log.info("\u67e5\u8be2\u7ba1\u7406\u533a\u57df\u7684\u95e8\u5e97\uff1a{}", (Object)JSONUtil.toJsonString(regionCodes));
            OrgStoreBaseRpcParam orgStoreParam = new OrgStoreBaseRpcParam();
            orgStoreParam.setRegionList(new ArrayList(regionCodes));
            List storeList = (List)this.orgStoreRpcService.findSimpleStoreByParam(orgStoreParam).computeData();
            if (CollUtil.isNotEmpty((Collection)storeList)) {
                for (OrgStoreBaseRpcDTO orgStoreBaseRpcDTO : storeList) {
                    if (!param.equals(orgStoreBaseRpcDTO.getStoreCode())) continue;
                    return;
                }
            }
        }
        throw new BusinessException("\u5f53\u524d\u7528\u6237\u65e0\u8be5\u95e8\u5e97\u7684\u64cd\u4f5c\u6743\u9650");
    }

    public AppStorePasswordPaymentServiceImpl(OrgStoreRpcService orgStoreRpcService, ScpsmanInfoRepoProc scpsmanInfoRepoProc, ScpsmanRegionRepoProc scpsmanRegionRepoProc) {
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpsmanInfoRepoProc = scpsmanInfoRepoProc;
        this.scpsmanRegionRepoProc = scpsmanRegionRepoProc;
    }
}

