/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.stock;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.inv.dto.invwh.InvWhRpcSimpleDTO;
import com.elitesland.inv.provider.InvWhProvider;
import com.elitesland.scp.application.facade.vo.stock.ScpSafetyTargetStockImportEntity;
import com.elitesland.scp.domain.entity.stock.ScpSafetyTargetStockDO;
import com.elitesland.scp.domain.service.stock.ScpSafetyTargetStockDomainService;
import com.elitesland.scp.infr.dto.stock.ScpSafetyTargetStockDTO;
import com.elitesland.scp.infr.repo.stock.ScpSafetyTargetStockRepo;
import com.elitesland.support.provider.item.dto.ItmItemSkuBusinessRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemSkuBusinessRpcDtoParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ScpSafetyTargetStockImportService
implements DataImport<ScpSafetyTargetStockImportEntity> {
    private static final Logger log = LoggerFactory.getLogger(ScpSafetyTargetStockImportService.class);
    private final InvWhProvider invWhProvider;
    private final ItmItemRpcService itemRpcService;
    private final OrgOuRpcService orgOuRpcService;
    private final ScpSafetyTargetStockDomainService safetyTargetStockDomainService;
    private final ScpSafetyTargetStockRepo scpSafetyTargetStockRepo;

    public String getTmplCode() {
        return "safety_target_stock_import";
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public List<String> executeImport(List<ScpSafetyTargetStockImportEntity> dataList, int startRowIndex) {
        if (CollUtil.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        HashMap errorMap = new HashMap();
        ArrayList<String> errorList = new ArrayList<String>();
        HashMap<CallSite, Integer> uniqueMap = new HashMap<CallSite, Integer>();
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            Integer ex;
            ScpSafetyTargetStockImportEntity importEntity = dataList.get(i2);
            importEntity.setLine(i2 + 1);
            errorMap.put(importEntity.getLine(), new ArrayList());
            if (!StringUtils.hasText((String)importEntity.getOuCode())) {
                ((List)errorMap.get(importEntity.getLine())).add("\u5217[\u516c\u53f8\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)importEntity.getWhCode())) {
                ((List)errorMap.get(importEntity.getLine())).add("\u5217[\u4ed3\u5e93\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)importEntity.getItemCode())) {
                ((List)errorMap.get(importEntity.getLine())).add("\u5217[\u5546\u54c1\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)importEntity.getPlanUom())) {
                ((List)errorMap.get(importEntity.getLine())).add("\u5217[\u8ba1\u5212\u5355\u4f4d]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ((ex = (Integer)uniqueMap.get(importEntity.getOuCode() + importEntity.getWhCode() + importEntity.getItemCode())) != null) {
                ((List)errorMap.get(importEntity.getLine())).add("\u5217[\u516c\u53f8\u7f16\u7801]-[\u4ed3\u5e93\u7f16\u7801]-[\u5546\u54c1\u7f16\u7801] \u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5");
                ((List)errorMap.get(ex)).add("\u5217[\u516c\u53f8\u7f16\u7801]-[\u4ed3\u5e93\u7f16\u7801]-[\u5546\u54c1\u7f16\u7801] \u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5");
            } else {
                uniqueMap.put((CallSite)((Object)(importEntity.getOuCode() + importEntity.getWhCode() + importEntity.getItemCode())), i2);
            }
            if (importEntity.getSafetyQty() == null) {
                ((List)errorMap.get(importEntity.getLine())).add("\u5217[\u5b89\u5168\u5e93\u5b58]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (importEntity.getTargetQty() != null) continue;
            ((List)errorMap.get(importEntity.getLine())).add("\u5217[\u76ee\u6807\u5e93\u5b58]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Integer line : errorMap.keySet()) {
            errorList.add(String.join((CharSequence)",", (Iterable)errorMap.get(line)));
        }
        if (Boolean.TRUE.equals(this.getErrorResult(errorList))) {
            return errorList;
        }
        List itemCodes = dataList.stream().map(ScpSafetyTargetStockImportEntity::getItemCode).distinct().collect(Collectors.toList());
        List ouCodes = dataList.stream().map(ScpSafetyTargetStockImportEntity::getOuCode).distinct().collect(Collectors.toList());
        List whCodes = dataList.stream().map(ScpSafetyTargetStockImportEntity::getWhCode).distinct().collect(Collectors.toList());
        ItmItemSkuBusinessRpcDtoParam itmItemRpcDtoParam = new ItmItemSkuBusinessRpcDtoParam();
        itmItemRpcDtoParam.setItemCodes(itemCodes);
        List itemInfos = this.itemRpcService.findItemSkuBusinessByParam(itmItemRpcDtoParam);
        Map<String, ItmItemSkuBusinessRpcDTO> itemMap = itemInfos.stream().collect(Collectors.toMap(i -> i.getItemCode(), i -> i, (o, n) -> n));
        List invWhRpcSimpleDTOS = (List)this.invWhProvider.findSimpleWhByWhCodes(whCodes).computeData();
        Map<String, InvWhRpcSimpleDTO> whMap = invWhRpcSimpleDTOS.stream().collect(Collectors.toMap(i -> i.getOuId() + i.getWhCode(), i -> i, (o, n) -> n));
        Map<String, InvWhRpcSimpleDTO> whCodeMap = invWhRpcSimpleDTOS.stream().collect(Collectors.toMap(i -> i.getWhCode(), i -> i, (o, n) -> n));
        List simpleByOuCodes = this.orgOuRpcService.findSimpleByOuCodes(ouCodes);
        Map<String, OrgOuRpcSimpleDTO> ouMap = simpleByOuCodes.stream().collect(Collectors.toMap(i -> i.getOuCode(), i -> i, (o, n) -> n));
        log.info("\u4ed3\u5e93\u5b57\u5178:{}", (Object)JSONUtil.toJsonStr(whCodeMap));
        ArrayList<ScpSafetyTargetStockDTO> stockSaveVOS = new ArrayList<ScpSafetyTargetStockDTO>();
        for (ScpSafetyTargetStockImportEntity importEntity : dataList) {
            ScpSafetyTargetStockDTO stockSaveVO = new ScpSafetyTargetStockDTO();
            stockSaveVO.setPlanUom(importEntity.getPlanUom());
            stockSaveVO.setSafetyQty(importEntity.getSafetyQty());
            stockSaveVO.setTargetQty(importEntity.getTargetQty());
            if (!itemMap.containsKey(importEntity.getItemCode())) {
                ((List)errorMap.get(importEntity.getLine())).add("\u5217[\u5546\u54c1\u7f16\u7801]\u4e0d\u5b58\u5728");
            } else {
                ItmItemSkuBusinessRpcDTO itemSkuBusinessRpcDTO = itemMap.get(importEntity.getItemCode());
                stockSaveVO.setItemId(itemSkuBusinessRpcDTO.getItemId());
                stockSaveVO.setItemName(itemSkuBusinessRpcDTO.getItemName());
                stockSaveVO.setItemType2(itemSkuBusinessRpcDTO.getItemType2());
                stockSaveVO.setBrand(itemSkuBusinessRpcDTO.getBrand());
                stockSaveVO.setItemCateCode(itemSkuBusinessRpcDTO.getItemCateCode());
                stockSaveVO.setUom(itemSkuBusinessRpcDTO.getUom());
            }
            if (!ouMap.containsKey(importEntity.getOuCode())) {
                ((List)errorMap.get(importEntity.getLine())).add("\u5217[\u516c\u53f8\u7f16\u7801]\u4e0d\u5b58\u5728");
            } else {
                OrgOuRpcSimpleDTO orgOuRpcSimpleDTO = ouMap.get(importEntity.getOuCode());
                stockSaveVO.setOuId(orgOuRpcSimpleDTO.getId());
                if (!whMap.containsKey(stockSaveVO.getOuId() + importEntity.getWhCode())) {
                    ((List)errorMap.get(importEntity.getLine())).add(String.format("\u5217\u3010\u516c\u53f8\u7f16\u7801\u3011\u4e0d\u5c5e\u4e8e \u4ed3\u5e93 %s", importEntity.getWhCode()));
                } else {
                    stockSaveVO.setOuName(orgOuRpcSimpleDTO.getOuName());
                    stockSaveVO.setOuCode(importEntity.getOuCode());
                    stockSaveVO.setWhId(whMap.get(stockSaveVO.getOuId() + importEntity.getWhCode()).getWhId());
                    stockSaveVO.setWhName(whMap.get(stockSaveVO.getOuId() + importEntity.getWhCode()).getWhName());
                    stockSaveVO.setWhCode(importEntity.getWhCode());
                    stockSaveVO.setBusinessId(stockSaveVO.getOuId().toString() + stockSaveVO.getWhId().toString() + stockSaveVO.getItemId().toString());
                }
            }
            stockSaveVOS.add(stockSaveVO);
        }
        if (!CollectionUtils.isEmpty(stockSaveVOS)) {
            List<ScpSafetyTargetStockDTO> stockDTOS = stockSaveVOS.stream().filter(d -> d.getBusinessId() != null).distinct().collect(Collectors.toList());
            List<String> businessIds = stockDTOS.stream().map(ScpSafetyTargetStockDTO::getBusinessId).collect(Collectors.toList());
            List<ScpSafetyTargetStockDO> targetStockDOS = this.scpSafetyTargetStockRepo.findAllByBusinessIdIn(businessIds);
            if (!CollectionUtils.isEmpty(targetStockDOS)) {
                List<Long> ids = targetStockDOS.stream().map(BaseModel::getId).collect(Collectors.toList());
                this.safetyTargetStockDomainService.delete(ids);
            }
            this.safetyTargetStockDomainService.saveAll(stockDTOS);
        }
        for (Integer line : errorMap.keySet()) {
            if (((List)errorMap.get(line)).isEmpty() || Objects.equals(errorList.get(line - 1), null)) continue;
            errorList.set(line - 1, (String)errorList.get(line - 1) + String.join((CharSequence)",", (Iterable)errorMap.get(line)));
        }
        return errorList;
    }

    @Nullable
    private Boolean getErrorResult(List<String> errorList) {
        Boolean flag = false;
        errorList.replaceAll(new UnaryOperator<String>(){

            @Override
            public String apply(String s) {
                if (!StringUtils.hasText((String)s)) {
                    return null;
                }
                return s;
            }
        });
        for (String s : errorList) {
            if (!StringUtils.hasText((String)s)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public Integer stepSize() {
        return 200000;
    }

    public Set<Integer> sheetNoList() {
        return Set.of(Integer.valueOf(1));
    }

    public ScpSafetyTargetStockImportService(InvWhProvider invWhProvider, ItmItemRpcService itemRpcService, OrgOuRpcService orgOuRpcService, ScpSafetyTargetStockDomainService safetyTargetStockDomainService, ScpSafetyTargetStockRepo scpSafetyTargetStockRepo) {
        this.invWhProvider = invWhProvider;
        this.itemRpcService = itemRpcService;
        this.orgOuRpcService = orgOuRpcService;
        this.safetyTargetStockDomainService = safetyTargetStockDomainService;
        this.scpSafetyTargetStockRepo = scpSafetyTargetStockRepo;
    }
}

