/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.alloc;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.alloc.ScpAllocSettingRegionPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingRegionRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingRegionSaveVO;
import com.elitesland.scp.domain.convert.alloc.ScpAllocSettingRegionConvert;
import com.elitesland.scp.domain.entity.alloc.ScpAllocSettingRegionDO;
import com.elitesland.scp.domain.service.alloc.ScpAllocSettingRegionDomainService;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingRegionRepo;
import com.elitesland.scp.infr.repo.alloc.ScpAllocSettingRegionRepoProc;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpAllocSettingRegionDomainServiceImpl
implements ScpAllocSettingRegionDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpAllocSettingRegionDomainServiceImpl.class);
    private final ScpAllocSettingRegionRepo scpAllocSettingRegionRepo;
    private final ScpAllocSettingRegionRepoProc scpAllocSettingRegionRepoProc;

    @Override
    public List<ScpAllocSettingRegionRespVO> findByMasId(Long masId) {
        List<ScpAllocSettingRegionDO> settingItemDOS = this.scpAllocSettingRegionRepo.findByMasId(masId);
        if (CollUtil.isNotEmpty(settingItemDOS)) {
            return ScpAllocSettingRegionConvert.INSTANCE.dosToRespVOS(settingItemDOS);
        }
        return new ArrayList<ScpAllocSettingRegionRespVO>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSaveAllocSettingRegion(List<ScpAllocSettingRegionSaveVO> saveVOS) {
        this.scpAllocSettingRegionRepo.saveAll(ScpAllocSettingRegionConvert.INSTANCE.saveVosDOS(saveVOS));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.scpAllocSettingRegionRepo.deleteByMasId(masId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpAllocSettingRegionRepo.deleteByIds(ids);
    }

    @Override
    public PagingVO<ScpAllocSettingRegionRespVO> page(ScpAllocSettingRegionPageParamVO paramVO) {
        long count = this.scpAllocSettingRegionRepoProc.countAllocSettingRegion(paramVO);
        if (count > 0L) {
            List<ScpAllocSettingRegionRespVO> respVOList = this.scpAllocSettingRegionRepoProc.queryAllocSettingRegion(paramVO);
            return new PagingVO(count, respVOList);
        }
        return new PagingVO();
    }

    @Override
    public List<Long> findMasIdByRegionCode(String regionCode) {
        return this.scpAllocSettingRegionRepoProc.findMasIdByRegionCode(regionCode);
    }

    public ScpAllocSettingRegionDomainServiceImpl(ScpAllocSettingRegionRepo scpAllocSettingRegionRepo, ScpAllocSettingRegionRepoProc scpAllocSettingRegionRepoProc) {
        this.scpAllocSettingRegionRepo = scpAllocSettingRegionRepo;
        this.scpAllocSettingRegionRepoProc = scpAllocSettingRegionRepoProc;
    }
}

