package com.elitesland.scp.domain.entity.serviceconfig;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_service_config")
@org.hibernate.annotations.Table(appliesTo = "scp_service_config", comment = "项目服务配置")
@Accessors(chain = true)
@ApiModel(value = "项目服务配置", description = "项目服务配置")
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ScpServiceConfigDO extends BaseModel implements Serializable {


    @Column(name = "id", columnDefinition = "bigint")
    @Comment("记录唯一ID")
    private Long id;

    @Column(name = "fee_type", columnDefinition = "varchar(64)")
    @Comment("费用归属类型")
    private String feeType;

    @Column(name = "ou_id", columnDefinition = "bigint")
    @Comment("费用归属公司id")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(64)")
    @Comment("费用归属公司编码")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(64)")
    @Comment("费用归属公司名称")
    private String ouName;

    @Column(name = "type", columnDefinition = "varchar(30)")
    @Comment("类型")
    private String type;

    @Column(name = "region_store_id", columnDefinition = "bigint")
    @Comment("区域id/门店id")
    private Long regionStoreId;

    @Column(name = "region_store_code", columnDefinition = "varchar(64)")
    @Comment("区域编码/门店编码")
    private String regionStoreCode;

    @Column(name = "region_store_name", columnDefinition = "varchar(64)")
    @Comment("区域名称/门店名称")
    private String regionStoreName;

    @Column(name = "store_level", columnDefinition = "varchar(64)")
    @Comment("适用门店等级")
    private String storeLevel;

    @Column(name = "fee_percentage", columnDefinition = "decimal(20,8)")
    @Comment("费用比例")
    private BigDecimal feePercentage;

    @Column(name = "business_key", columnDefinition = "varchar(255)")
    @Comment("业务主键")
    private String businessKey;

    public List<String> getStoreLevels() {
        if (StringUtils.isNotEmpty(storeLevel)) {
            return List.of(storeLevel.split(","));
        }
        return new ArrayList<>();
    }
}