package com.elitesland.scp.domain.vo.article;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
@ApiModel(description = "显示/隐藏入参")
public class ArticleInfoShowParam implements Serializable {

    private static final long serialVersionUID = 5771439104790143L;

    @ApiModelProperty(value = "文章id", required = true)
    @NotNull(message = "id不能为空")
    private Long id;

    @ApiModelProperty(value = "是否显示", required = true)
    @NotBlank(message = "显示/隐藏不能为空")
    private String showFlag;

}
