package com.elitesland.scp.domain.vo.survey;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(description = "问卷出参")
@Data
public class SurveyRespVO implements Serializable {

    private static final long serialVersionUID = 44067892996016803L;

    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("问卷标题")
    private String surveyTitle;

    @ApiModelProperty("问卷描述")
    private String surveyDesc;

    @ApiModelProperty("开始时间")
    private LocalDateTime beginTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("问卷状态")
    @SysCode(sys = "yst-suplan", mod = "SURVEY_STATUS")
    private String surveyStatus;
    private String surveyStatusName;

    @ApiModelProperty("发布人")
    private Long publisherId;

    @ApiModelProperty("发布人")
    private String publisherName;

    @ApiModelProperty("发布公司名称")
    private String publishOuName;

    @ApiModelProperty("填写数量")
    private Integer fillCount;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("是否必填")
    private Boolean required;

    @ApiModelProperty("发布时间")
    private LocalDateTime publishTime;

    @ApiModelProperty("问题列表")
    private List<SurveyQuestionRespVO> questionList;

    @ApiModelProperty("答案列表(分页)")
    private List<SurveyAnswerRespVO> answerList;

}
