/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.stock;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.scp.application.facade.vo.stock.ScpPredictStStockSaveVO;
import com.elitesland.scp.application.service.stock.ScpPredictStStockService;
import com.elitesland.scp.domain.convert.stock.ScpPredictStStockConvert;
import com.elitesland.scp.domain.entity.stock.ScpPredictStStockDO;
import com.elitesland.scp.domain.entity.stock.ScpSafetyTargetStockDO;
import com.elitesland.scp.infr.repo.stock.ScpPredictStStockRepo;
import com.elitesland.scp.infr.repo.stock.ScpPredictStStockRepoProc;
import com.elitesland.scp.infr.repo.stock.ScpSafetyTargetStockRepo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpPredictStStockServiceImpl
implements ScpPredictStStockService {
    private static final Logger log = LoggerFactory.getLogger(ScpPredictStStockServiceImpl.class);
    private final ScpPredictStStockRepoProc scpPredictStStockRepoProc;
    private final ScpPredictStStockRepo scpPredictStStockRepo;
    private final ScpSafetyTargetStockRepo scpSafetyTargetStockRepo;

    @Override
    @Transactional
    public void saveBatch(List<ScpPredictStStockSaveVO> param) {
        long count = param.stream().map(d -> d.getOuId().toString() + d.getWhId().toString() + d.getItemId().toString()).distinct().count();
        if (count != (long)param.size()) {
            throw new RuntimeException("\u516c\u53f8\u4ed3\u5e93\u5546\u54c1\u4e0d\u80fd\u91cd\u590d");
        }
        long stCount = param.stream().map(ScpPredictStStockSaveVO::getStId).distinct().count();
        if (stCount != (long)param.size()) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u540c\u4e00\u6279\u6b21\u6570\u636e");
        }
        List updateList = param.stream().filter(d -> d.getId() != null).collect(Collectors.toList());
        List createList = param.stream().filter(d -> d.getId() == null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(createList)) {
            List<String> businessIds = createList.stream().map(ScpPredictStStockSaveVO::getBusinessId).collect(Collectors.toList());
            List<ScpSafetyTargetStockDO> targetStockDOS = this.scpSafetyTargetStockRepo.findAllByBusinessIdIn(businessIds);
            Map<Object, Object> stockDOMap = CollectionUtils.isNotEmpty(targetStockDOS) ? targetStockDOS.stream().collect(Collectors.toMap(ScpSafetyTargetStockDO::getBusinessId, v -> v, (e1, e2) -> e1)) : new HashMap();
            List<Long> stIds = createList.stream().map(ScpPredictStStockSaveVO::getStId).collect(Collectors.toList());
            List stStockDOS = createList.stream().map(d -> {
                if (stockDOMap.get(d.getBusinessId()) != null) {
                    d.setSafetyQty(((ScpSafetyTargetStockDO)stockDOMap.get(d.getBusinessId())).getSafetyQty());
                    d.setTargetQty(((ScpSafetyTargetStockDO)stockDOMap.get(d.getBusinessId())).getTargetQty());
                } else {
                    d.setSafetyQty(BigDecimal.ZERO);
                    d.setTargetQty(BigDecimal.ZERO);
                }
                ScpPredictStStockDO scpPredictStStockDO = new ScpPredictStStockDO();
                ScpPredictStStockConvert.INSTANCE.copySaveVoToDo((ScpPredictStStockSaveVO)d, scpPredictStStockDO);
                return scpPredictStStockDO;
            }).collect(Collectors.toList());
            List<ScpPredictStStockDO> predictStStockDOS = this.scpPredictStStockRepo.findAllByStIdInAndBusinessIdIn(stIds, businessIds);
            if (CollectionUtils.isNotEmpty(predictStStockDOS)) {
                List ids = predictStStockDOS.stream().map(BaseModel::getId).collect(Collectors.toList());
                this.scpPredictStStockRepo.deleteAllById(ids);
            }
            this.scpPredictStStockRepo.saveAll(stStockDOS);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            List ids = updateList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            Map<Long, ScpPredictStStockSaveVO> stockSaveVOMap = updateList.stream().collect(Collectors.toMap(BaseViewModel::getId, v -> v));
            List predictStStockDOS = this.scpPredictStStockRepo.findAllById(ids);
            predictStStockDOS.forEach(d -> {
                d.setPredSafetyQty(((ScpPredictStStockSaveVO)stockSaveVOMap.get(d.getId())).getPredSafetyQty());
                d.setPredTargetQty(((ScpPredictStStockSaveVO)stockSaveVOMap.get(d.getId())).getPredTargetQty());
            });
            this.scpPredictStStockRepo.saveAll(predictStStockDOS);
        }
    }

    @Override
    @Transactional
    public String update(List<ScpPredictStStockSaveVO> param) {
        long count = param.stream().filter(d -> d.getId() == null).count();
        if (count > 0L) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e");
        }
        this.saveBatch(param);
        return "success";
    }

    @Override
    @Transactional
    public void delete(List<Long> ids) {
        this.scpPredictStStockRepo.deleteAllById(ids);
    }

    public ScpPredictStStockServiceImpl(ScpPredictStStockRepoProc scpPredictStStockRepoProc, ScpPredictStStockRepo scpPredictStStockRepo, ScpSafetyTargetStockRepo scpSafetyTargetStockRepo) {
        this.scpPredictStStockRepoProc = scpPredictStStockRepoProc;
        this.scpPredictStStockRepo = scpPredictStStockRepo;
        this.scpSafetyTargetStockRepo = scpSafetyTargetStockRepo;
    }
}

