package com.elitesland.scp.application.facade.vo.cart;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/26 17:39
 * @Description:
 */
@Data
@ApiModel("下单校验结果")
public class OrderCheckRespVO implements Serializable {

    @ApiModelProperty("商品种类数")
    private Integer itemTypeNum;

    @ApiModelProperty("数量")
    private BigDecimal qtyTotal;

    @ApiModelProperty("含税合计")
    private BigDecimal amtTotal;

    @ApiModelProperty("成功的数据")
    private List<CartToOrderSuccessRespVO> success;

    @ApiModelProperty("失败的数据")
    private List<CartToOrderFailRespVO> fail;

    @ApiModelProperty("采购车全部商品匹配失败")
    private boolean allFailed;

    @ApiModelProperty("商品金额")
    private BigDecimal goodAmt;

    @ApiModelProperty("运费")
    private BigDecimal freightAmt;
}
