package com.elitesland.scp.domain.entity.order;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "scp_demand_order_reply")
@org.hibernate.annotations.Table(appliesTo = "scp_demand_order_reply", comment = "订货订单评价表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "订货订单评价表", description = "订货订单评价表")
@Where(clause = "delete_flag = 0")
public class ScpDemandOrderReplyDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -4291780509052482519L;

    @ApiModelProperty("订货单ID")
    @Comment("订货单ID")
    @Column()
    private Long orderId;

    @Comment("订单分数")
    @Column()
    @ApiModelProperty(value = "订单分数")
    private Integer orderScore;

    @Comment("物流分数")
    @Column()
    @ApiModelProperty(value = "物流分数")
    private Integer expressScore;

    @Comment("评论内容")
    @Column()
    @ApiModelProperty(value = "评论内容")
    private String comment;

    @Comment("评论图片")
    @Column()
    @ApiModelProperty(value = "评论图片")
    private String pics;

}
