package com.elitesland.scp.domain.service.minOrder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStorePageParamVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingStoreParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingStoreRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingStoreSaveVO;

import java.util.List;

public interface ScpMinOrderSettingStoreDomainService {

    /**
     * 订货强配活动门店查询
     *
     * @param paramVO
     * @return
     */
    PagingVO<ScpMinOrderSettingStoreRespVO> page(ScpMinOrderSettingStorePageParamVO paramVO);

    /**
     * 订货强配活动门店保存
     *
     * @param saveVOS 保存单据类型配置的值对象
     * @return 返回保存后的单据类型配置的ID
     */
    void batchSaveMinOrderSettingStore(List<ScpMinOrderSettingStoreSaveVO> saveVOS, int batchSize);

    default void batchSaveMinOrderSettingStore(List<ScpMinOrderSettingStoreSaveVO> saveVOS) {
        batchSaveMinOrderSettingStore(saveVOS, 100);
    }

    /**
     * 删除订货强配活动门店
     *
     * @param masId
     */
    void deleteByMasId(Long masId);

    /**
     * 删除订货强配活动门店
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 根据门店查询
     *
     * @param storeCode
     * @return
     */
    List<Long> findMasIdByStoreCode(String storeCode);

    /**
     * 更新已强配次数
     *
     * @param masIds
     * @param storeCode
     */
    void updateMinOrderNumByParam(List<Long> masIds, String storeCode);

    /**
     * 根据参数查询
     * @param paramVO
     */
    List<ScpMinOrderSettingStoreRespVO> findByParam(ScpMinOrderSettingStoreParamVO paramVO);

    /**
     * 更新门店
     * @param saveVO
     */
    Long updateMinOrderSettingStore(ScpMinOrderSettingStoreSaveVO saveVO);

    /**
     * 根据活动ID查询门店
     * @param masId
     * @return
     */
    List<ScpMinOrderSettingStoreRespVO> findByMasId(Long masId);

    List<ScpMinOrderSettingStoreRespVO> findEnabledByParam(ScpMinOrderSettingStoreParamVO paramVO);
}
