/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.mq;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitesland.scp.boh.StoreReceiveConfirmSendParam;
import com.elitesland.scp.domain.entity.storereceive.StoreReceiveDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDomainService;
import com.elitesland.scp.infr.dto.boh.DemandOrderDtl;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepo;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepoProc;
import com.elitesland.scp.utils.SysUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StoreReceiveConfirmListener
implements MessageQueueListener<StoreReceiveConfirmSendParam> {
    private static final Logger log = LoggerFactory.getLogger(StoreReceiveConfirmListener.class);
    private final StoreReceiveRepo storeReceiveRepo;
    private final StoreReceiveRepoProc storeReceiveRepoProc;
    private final ScpDemandOrderDomainService scpDemandOrderDomainService;
    private final ScpDemandOrderDDomainService scpDemandOrderDDomainService;
    private final RedisTemplate<Object, Object> redisTemplate;

    @NotEmpty
    public String[] channels() {
        return new String[]{"store_order_confirm"};
    }

    @Transactional(rollbackFor={Exception.class})
    public void onConsume(@NotBlank String s, @NotNull StoreReceiveConfirmSendParam storeReceiveSendParam) {
        log.info("\u95e8\u5e97\u6536\u9000\u8d27 \u786e\u8ba4\u56de\u5199\uff1a{}", (Object)JSON.toJSONString((Object)storeReceiveSendParam));
        List<StoreReceiveDO> receiveDOS = this.storeReceiveRepo.findAllByDocId(storeReceiveSendParam.getDocId());
        if (CollectionUtil.isEmpty(receiveDOS)) {
            return;
        }
        List<StoreReceiveDO> ceList = receiveDOS.stream().filter(i -> Objects.equals(i.getStatus(), "CE")).toList();
        if (ceList.isEmpty()) {
            return;
        }
        Integer amtPlace = SysUtils.getAmtPlace();
        List<Long> orderDidList = storeReceiveSendParam.getItems().stream().map(StoreReceiveConfirmSendParam.OrderItem::getOrderDid).distinct().collect(Collectors.toList());
        List<DemandOrderDtl> orderDtl = this.storeReceiveRepoProc.findOrderDtlWithSettlePrice(orderDidList);
        Map<Long, BigDecimal> priceMap = orderDtl.stream().filter(i -> i.getPrice() != null).collect(Collectors.toMap(DemandOrderDtl::getId, DemandOrderDtl::getPrice));
        StoreReceiveDO thisDo = receiveDOS.get(0);
        thisDo.setStatus("CF");
        thisDo.setTotalRealQty(storeReceiveSendParam.getItems().stream().map(StoreReceiveConfirmSendParam.OrderItem::getQty).reduce(BigDecimal.ZERO, BigDecimal::add));
        BigDecimal totalRealAmt = BigDecimal.ZERO;
        for (Object item : storeReceiveSendParam.getItems()) {
            BigDecimal bigDecimal = priceMap.get(item.getOrderDid());
            if (bigDecimal == null) continue;
            totalRealAmt = totalRealAmt.add(item.getQty().multiply(bigDecimal).setScale((int)amtPlace, RoundingMode.HALF_UP));
        }
        thisDo.setRealAmt(totalRealAmt.setScale((int)amtPlace, RoundingMode.HALF_UP));
        if (thisDo.getRtType().equals("R")) {
            thisDo.setReceiveDate(storeReceiveSendParam.getConfirmTime());
        } else {
            thisDo.setRtnDate(storeReceiveSendParam.getConfirmTime());
        }
        this.storeReceiveRepo.save(thisDo);
        log.info("\u8c03\u62e8\u5355\u66f4\u65b0\u8ba2\u8d27\u5355\u6536\u9000\u8d27\u6570\u91cf\uff1a{}", (Object)JSONUtil.toJsonStr((Object)storeReceiveSendParam.getItems()));
        Map<Long, BigDecimal> orderDidQtyMap = storeReceiveSendParam.getItems().stream().collect(Collectors.groupingBy(StoreReceiveConfirmSendParam.OrderItem::getOrderDid, Collectors.mapping(StoreReceiveConfirmSendParam.OrderItem::getQty, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        log.info("\u8c03\u62e8\u5355\u66f4\u65b0\u6536\u9000\u8d27\u6570\u91cf\u6570\u636e\uff1a{}", (Object)JSONUtil.toJsonStr(orderDidQtyMap));
        if ("T".equals(thisDo.getRtType())) {
            if (storeReceiveSendParam.getRefundType().equals("REFUND")) {
                for (Map.Entry entry : orderDidQtyMap.entrySet()) {
                    this.scpDemandOrderDDomainService.updateCompensationQty((Long)entry.getKey(), (BigDecimal)entry.getValue());
                }
            } else if (storeReceiveSendParam.getRefundType().equals("RETURN")) {
                for (Map.Entry entry : orderDidQtyMap.entrySet()) {
                    this.scpDemandOrderDDomainService.updateReturnQty((Long)entry.getKey(), (BigDecimal)entry.getValue());
                }
            }
        } else {
            for (Map.Entry entry : orderDidQtyMap.entrySet()) {
                this.scpDemandOrderDDomainService.updateRecvQty((Long)entry.getKey(), (BigDecimal)entry.getValue());
            }
            List<Long> ids = storeReceiveSendParam.getItems().stream().map(StoreReceiveConfirmSendParam.OrderItem::getOrderDid).collect(Collectors.toList());
            List list = this.scpDemandOrderDDomainService.getMasIdByDId(ids).stream().distinct().toList();
            for (Long masId : list) {
                this.scpDemandOrderDomainService.updateDocStatusById(masId, "RECV");
            }
            String recvKey = "RECEIVE" + storeReceiveSendParam.getDocId().toString();
            if (this.redisTemplate.hasKey((Object)recvKey).booleanValue()) {
                log.info("\u95e8\u5e97\u6536\u8d27\u63d0\u4ea4\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f00\u59cb\u6e05\u9664redis:{}", (Object)recvKey);
                this.redisTemplate.delete((Object)recvKey);
            }
        }
    }

    public StoreReceiveConfirmListener(StoreReceiveRepo storeReceiveRepo, StoreReceiveRepoProc storeReceiveRepoProc, ScpDemandOrderDomainService scpDemandOrderDomainService, ScpDemandOrderDDomainService scpDemandOrderDDomainService, RedisTemplate<Object, Object> redisTemplate) {
        this.storeReceiveRepo = storeReceiveRepo;
        this.storeReceiveRepoProc = storeReceiveRepoProc;
        this.scpDemandOrderDomainService = scpDemandOrderDomainService;
        this.scpDemandOrderDDomainService = scpDemandOrderDDomainService;
        this.redisTemplate = redisTemplate;
    }
}

