/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.app;

import com.elitesland.scp.application.facade.vo.param.app.AppStoreServiceEntityRespVO;
import com.elitesland.scp.application.facade.vo.serviceconfig.ScpServiceConfigRespVO;
import com.elitesland.scp.application.service.app.AppStoreServiceEntityService;
import com.elitesland.scp.application.service.serviceconfig.ScpServiceConfigService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreBaseRpcParam;
import com.elitesland.support.provider.org.service.OrgOuRpcService;
import com.elitesland.support.provider.org.service.OrgStoreRpcService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AppStoreServiceEntityServiceImpl
implements AppStoreServiceEntityService {
    private static final Logger log = LoggerFactory.getLogger(AppStoreServiceEntityServiceImpl.class);
    private final OrgStoreRpcService orgStoreRpcService;
    private final ScpServiceConfigService scpServiceConfigService;
    private final OrgOuRpcService orgOuRpcService;

    @Override
    public AppStoreServiceEntityRespVO query(String storeCode) {
        List allAppStoreSupplyOuRpcDto;
        AppStoreServiceEntityRespVO entityRespVO = new AppStoreServiceEntityRespVO();
        entityRespVO.setStoreCode(storeCode);
        OrgStoreBaseRpcParam baseRpcParam = new OrgStoreBaseRpcParam();
        baseRpcParam.setStoreCode(storeCode);
        OrgStoreBaseRpcDTO orgStoreBaseRpcDTO = (OrgStoreBaseRpcDTO)((List)this.orgStoreRpcService.findSimpleStoreByParam(baseRpcParam).computeData()).get(0);
        Map<String, ScpServiceConfigRespVO> configRespVOMap = null;
        if ((Boolean.TRUE.equals(orgStoreBaseRpcDTO.getDeliveryChargeFlag()) || Boolean.TRUE.equals(orgStoreBaseRpcDTO.getWhChargeFlag())) && (configRespVOMap = this.scpServiceConfigService.findServiceConfigGroupByStore(orgStoreBaseRpcDTO.getStoreCode(), orgStoreBaseRpcDTO.getRegion(), orgStoreBaseRpcDTO.getStoreLevel())) != null && configRespVOMap.get("TECH") != null) {
            entityRespVO.setFeeOuCode(configRespVOMap.get("TECH").getOuCode());
            entityRespVO.setFeeOuName(configRespVOMap.get("TECH").getOuName());
        }
        if (CollectionUtils.isNotEmpty((Collection)(allAppStoreSupplyOuRpcDto = this.orgOuRpcService.findAllAppStoreSupplyOuRpcDto()))) {
            entityRespVO.setSupplyOuList(allAppStoreSupplyOuRpcDto.stream().map(i -> {
                AppStoreServiceEntityRespVO.SupplyOuRespVO respVO = new AppStoreServiceEntityRespVO.SupplyOuRespVO();
                respVO.setSupplyOuCode(i.getOuCode());
                respVO.setSupplyOuName(i.getOuName());
                return respVO;
            }).collect(Collectors.toList()));
        }
        return entityRespVO;
    }

    public AppStoreServiceEntityServiceImpl(OrgStoreRpcService orgStoreRpcService, ScpServiceConfigService scpServiceConfigService, OrgOuRpcService orgOuRpcService) {
        this.orgStoreRpcService = orgStoreRpcService;
        this.scpServiceConfigService = scpServiceConfigService;
        this.orgOuRpcService = orgOuRpcService;
    }
}

