/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.wechat;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.param.AuthUserIdQueryDTO;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import com.elitesland.scp.application.facade.vo.wechat.WechatAccessTokenVO;
import com.elitesland.scp.application.service.wechat.WechatService;
import com.elitesland.scp.config.WechatProperties;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.stereotype.Service;

@Service
public class WechatServiceImpl
implements WechatService {
    private static final Logger log = LoggerFactory.getLogger(WechatServiceImpl.class);
    private final WechatProperties wechatProperties;
    private final RedisUtils redisUtils;

    @Override
    public String oauth2LoginUrl() {
        String getWechatLogin = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=snsapi_privateinfo&state=STATE&agentid=AGENTID#wechat_redirect";
        String loginUrl = getWechatLogin.replace("APPID", this.wechatProperties.getCorpId()).replace("REDIRECT_URI", this.wechatProperties.getRedirectUrl()).replace("AGENTID", this.wechatProperties.getAgentId());
        log.info("\u4f01\u4e1a\u5fae\u4fe1\u5185\u767b\u5f55\u91cd\u5b9a\u5411url:" + loginUrl);
        return loginUrl;
    }

    @Override
    public String getEnterpriseAccessToken(String corpid, String corpsecret, String type) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("corpid", corpid);
        params.put("corpsecret", corpsecret);
        Object accessToken = this.redisUtils.get("wxEnterprise-" + corpid + "-" + type);
        if (Objects.isNull(accessToken)) {
            String body = HttpUtil.get((String)this.wechatProperties.getProviderTokenUrl(), params, (int)7200);
            log.info("getProviderToken\u51fa\u53c2" + body);
            WechatAccessTokenVO weChat = (WechatAccessTokenVO)JSONUtil.toBean((String)body, WechatAccessTokenVO.class);
            if (weChat.getErrcode() == null || weChat.getErrcode() == 0) {
                accessToken = weChat.getAccess_token();
                this.redisUtils.set("wxEnterprise-" + corpid + "-" + type, accessToken, weChat.getExpires_in().longValue(), TimeUnit.SECONDS);
            }
        }
        return (String)accessToken;
    }

    @Override
    public String pcLogin(String code) {
        String accessToken = this.getEnterpriseAccessToken(this.wechatProperties.getCorpId(), this.wechatProperties.getH5Corpsecret(), "PC");
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("access_token", accessToken);
        param.put("code", code);
        String result = HttpUtil.get((String)"https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo", param, (int)7200);
        log.info("PC\u767b\u5f55\u83b7\u53d6\u8bbf\u95ee\u7528\u6237\u8eab\u4efd:{}", (Object)result);
        JSONObject userInfoObject = JSONUtil.parseObj((String)result);
        Integer errcode = (Integer)userInfoObject.get((Object)"errcode");
        if (errcode != 0) {
            throw new BusinessException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25:" + userInfoObject.get((Object)"errmsg"));
        }
        String userid = (String)userInfoObject.get((Object)"userid");
        AuthUserIdQueryDTO queryDTO = new AuthUserIdQueryDTO();
        queryDTO.setUserIdCypher(((TextEncryptor)SpringContextHolder.getBean(TextEncryptor.class)).encrypt(userid));
        ApiResult tokenResult = ((SysUserPermissionRpcService)SpringContextHolder.getBean(SysUserPermissionRpcService.class)).authByOuterKey(queryDTO);
        log.info("PC\u767b\u5f55\u8c03\u7528\u7cfb\u7edf\u57df\u6362\u53d6token\u63a5\u53e3:{}", (Object)tokenResult);
        if (tokenResult.isSuccess() && tokenResult.getData() != null) {
            OAuthToken data = (OAuthToken)tokenResult.getData();
            return data.getTokenType() + " " + data.getAccessToken();
        }
        throw new BusinessException("\u767b\u5f55\u5931\u8d25:" + tokenResult.getMsg());
    }

    @Override
    public String mgLogin(String code) {
        String accessToken = this.getEnterpriseAccessToken(this.wechatProperties.getCorpId(), this.wechatProperties.getMgCorpsecret(), "MG");
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put("access_token", accessToken);
        param.put("js_code", code);
        param.put("grant_type", "authorization_code");
        String result = HttpUtil.get((String)"https://qyapi.weixin.qq.com/cgi-bin/miniprogram/jscode2session", param, (int)7200);
        log.info("\u5c0f\u7a0b\u5e8f\u767b\u5f55\u4e34\u65f6\u767b\u5f55\u51ed\u8bc1:" + result);
        JSONObject jsonObject = JSONUtil.parseObj((String)result);
        Integer errcode = (Integer)jsonObject.get((Object)"errcode");
        if (errcode != 0) {
            throw new BusinessException("\u4e34\u65f6\u767b\u5f55\u51ed\u8bc1\u6821\u9a8c\u5931\u8d25:" + jsonObject.get((Object)"errmsg"));
        }
        String userid = (String)jsonObject.get((Object)"userid");
        AuthUserIdQueryDTO queryDTO = new AuthUserIdQueryDTO();
        queryDTO.setUserIdCypher(((TextEncryptor)SpringContextHolder.getBean(TextEncryptor.class)).encrypt(userid));
        ApiResult tokenResult = ((SysUserPermissionRpcService)SpringContextHolder.getBean(SysUserPermissionRpcService.class)).authByOuterKey(queryDTO);
        log.info("\u5c0f\u7a0b\u5e8f\u767b\u5f55\u8c03\u7528\u7cfb\u7edf\u57df\u6362\u53d6token\u63a5\u53e3:{}", (Object)tokenResult);
        if (tokenResult.isSuccess() && tokenResult.getData() != null) {
            OAuthToken data = (OAuthToken)tokenResult.getData();
            return data.getTokenType() + " " + data.getAccessToken();
        }
        throw new BusinessException("\u767b\u5f55\u5931\u8d25:" + tokenResult.getMsg());
    }

    @Override
    public String webLoginUrl() {
        String getWechatLogin = "https://login.work.weixin.qq.com/wwlogin/sso/login?login_type=LOGIN_TYPE&appid=APPID&redirect_uri=REDIRECT_URI&state=STATE";
        String loginUrl = getWechatLogin.replace("LOGIN_TYPE", this.wechatProperties.getLoginType()).replace("APPID", this.wechatProperties.getCorpId()).replace("REDIRECT_URI", this.wechatProperties.getRedirectUrl());
        log.info("\u4f01\u4e1a\u5fae\u4fe1SSO\u767b\u5f55\u91cd\u5b9a\u5411url:" + loginUrl);
        return loginUrl;
    }

    public WechatServiceImpl(WechatProperties wechatProperties, RedisUtils redisUtils) {
        this.wechatProperties = wechatProperties;
        this.redisUtils = redisUtils;
    }
}

