/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.order;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.el.coordinator.core.common.utils.UUIDUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.sale.api.vo.resp.crm.CustBaseDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderDPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderPayInfoRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderDSaveVO;
import com.elitesland.scp.domain.convert.order.ScpDemandOrderDConvert;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDDO;
import com.elitesland.scp.domain.service.order.ScpDemandOrderDDomainService;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderRelateDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepo;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderDRepoProc;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.rmi.RmiSalRpcService;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.ItmItemAttachmentProviderDTO;
import com.elitesland.support.provider.item.dto.ItmItemBaseRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemBaseRpcParam;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScpDemandOrderDDomainServiceImpl
implements ScpDemandOrderDDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpDemandOrderDDomainServiceImpl.class);
    private final EntityManager entityManager;
    private final RmiItemService rmiItemService;
    private final RmiSalRpcService rmiSalRpcService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final ScpDemandOrderDRepo scpDemandOrderDRepo;
    private final ScpDemandOrderDRepoProc scpDemandOrderDRepoProc;
    @Value(value="${ext.server-addr}")
    private String serverAddr;

    @Override
    public Long saveDemandOrderD(ScpDemandOrderDSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpDemandOrderDDO intentDO = ScpDemandOrderDConvert.INSTANCE.saveVoToDO(saveVO);
            return ((ScpDemandOrderDDO)this.scpDemandOrderDRepo.save(intentDO)).getId();
        }
        Optional option = this.scpDemandOrderDRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u8ba2\u5355\u660e\u7ec6ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpDemandOrderDConvert.INSTANCE.copySaveParamToDo(saveVO, (ScpDemandOrderDDO)option.get());
        return ((ScpDemandOrderDDO)this.scpDemandOrderDRepo.save((ScpDemandOrderDDO)option.get())).getId();
    }

    @Override
    @SysCodeProc
    public List<ScpDemandOrderDDTO> findDemandOrderDByMasId(Long masId) {
        return this.scpDemandOrderDRepo.findByMasId(masId).stream().map(ScpDemandOrderDConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    @SysCodeProc
    public List<ScpDemandOrderDDTO> findDemandOrderDByMasIdAndProjectFeeFlag(Long masId, Boolean projectFeeFlag) {
        return this.scpDemandOrderDRepo.findByMasIdAndProjectFeeFlag(masId, projectFeeFlag).stream().map(ScpDemandOrderDConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    public List<ScpDemandOrderDDO> findDemandOrderDBySpuCodes(Long masId, List<String> spuCode) {
        return this.scpDemandOrderDRepo.findByMasIdAndSpuItemCodeIn(masId, spuCode);
    }

    @Override
    public Page<ScpDemandOrderDDO> pageDemandOrderDByMasId(ScpDemandOrderDPageParamVO paramVO) {
        Page<ScpDemandOrderDDO> scpDemandOrderDDTOS = this.scpDemandOrderDRepo.findByMasId(paramVO.getMasId(), (Pageable)paramVO.getPageRequest());
        return scpDemandOrderDDTOS;
    }

    @Override
    public List<ScpDemandOrderDDTO> findDemandOrderDByIds(Collection<Long> ids) {
        return this.scpDemandOrderDRepo.findByIdIn(ids).stream().map(ScpDemandOrderDConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(List<Long> ids) {
        this.scpDemandOrderDRepoProc.deleteByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePlanQtyAndAmtById(Long id, BigDecimal planQty) {
        this.scpDemandOrderDRepoProc.updatePlanQtyAndAmtById(id, planQty);
    }

    private ScpDemandOrderDSaveVO generateFeeSaveVO(AtomicInteger lineNo, ScpDemandOrderDSaveVO oldSaveVO, ScpDemandOrderDSaveVO scpDemandOrderDSaveVO, Map<String, ItmItemBaseRpcDTO> itemMap, Map<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap, String itemCode, BigDecimal fee) {
        if (scpDemandOrderDSaveVO == null) {
            scpDemandOrderDSaveVO = new ScpDemandOrderDSaveVO();
            ItmItemBaseRpcDTO itmItemBaseRpcDTO = itemMap.get(itemCode);
            scpDemandOrderDSaveVO.setMasId(oldSaveVO.getMasId());
            scpDemandOrderDSaveVO.setDemandQuantity(BigDecimal.ONE);
            scpDemandOrderDSaveVO.setAllocationQuantity(BigDecimal.ONE);
            scpDemandOrderDSaveVO.setAllocationDeQuantity(BigDecimal.ONE);
            scpDemandOrderDSaveVO.setPlanQuantity(BigDecimal.ONE);
            scpDemandOrderDSaveVO.setPrice(fee);
            scpDemandOrderDSaveVO.setPlanAmt(fee);
            scpDemandOrderDSaveVO.setSalePrice(fee);
            scpDemandOrderDSaveVO.setSaleAmt(fee);
            scpDemandOrderDSaveVO.setSettlementPrice(fee);
            scpDemandOrderDSaveVO.setSettlementAmt(fee);
            scpDemandOrderDSaveVO.setSettlementSalePrice(fee);
            scpDemandOrderDSaveVO.setSettlementSaleAmt(fee);
            scpDemandOrderDSaveVO.setTechFee(BigDecimal.ZERO);
            scpDemandOrderDSaveVO.setMarketingFee(BigDecimal.ZERO);
            scpDemandOrderDSaveVO.setOperationFee(BigDecimal.ZERO);
            scpDemandOrderDSaveVO.setTefPrice(BigDecimal.ZERO);
            scpDemandOrderDSaveVO.setMefPrice(BigDecimal.ZERO);
            scpDemandOrderDSaveVO.setOefPrice(BigDecimal.ZERO);
            scpDemandOrderDSaveVO.setCurrency("CNY");
            scpDemandOrderDSaveVO.setPreRootUuid(UUIDUtil.getUUID());
            scpDemandOrderDSaveVO.setItemId(itmItemBaseRpcDTO.getId());
            scpDemandOrderDSaveVO.setItemCode(itmItemBaseRpcDTO.getItemCode());
            scpDemandOrderDSaveVO.setItemName(itmItemBaseRpcDTO.getItemName());
            scpDemandOrderDSaveVO.setSpuItemCode(itmItemBaseRpcDTO.getSpuCode());
            scpDemandOrderDSaveVO.setSpuItemName(itmItemBaseRpcDTO.getSpuName());
            scpDemandOrderDSaveVO.setUom2(itmItemBaseRpcDTO.getUom());
            scpDemandOrderDSaveVO.setSaleCustCode(oldSaveVO.getSaleCustCode());
            scpDemandOrderDSaveVO.setUom2Name(itmItemBaseRpcDTO.getUomName());
            scpDemandOrderDSaveVO.setUnit(itmItemBaseRpcDTO.getUom2());
            scpDemandOrderDSaveVO.setUnitName(itmItemBaseRpcDTO.getUom2Name());
            scpDemandOrderDSaveVO.setPayStatus(ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode());
            scpDemandOrderDSaveVO.setItemType(itmItemBaseRpcDTO.getItemType2());
            scpDemandOrderDSaveVO.setSupplyType(oldSaveVO.getSupplyType());
            scpDemandOrderDSaveVO.setSuppWhId(oldSaveVO.getSuppWhId());
            scpDemandOrderDSaveVO.setSuppWhName(oldSaveVO.getSuppWhName());
            scpDemandOrderDSaveVO.setSuppWhCode(oldSaveVO.getSuppWhCode());
            scpDemandOrderDSaveVO.setRatio(BigDecimal.valueOf(100L));
            scpDemandOrderDSaveVO.setUomRatio(itmItemBaseRpcDTO.getUomRatio2());
            scpDemandOrderDSaveVO.setQty2(itmItemBaseRpcDTO.getUomRatio2());
            scpDemandOrderDSaveVO.setLineNo(new BigDecimal(lineNo.getAndIncrement()));
            scpDemandOrderDSaveVO.setFreightLineFlag(Boolean.TRUE);
            scpDemandOrderDSaveVO.setIsCalculated(Boolean.TRUE);
            scpDemandOrderDSaveVO.setOuId(oldSaveVO.getOuId());
            scpDemandOrderDSaveVO.setOuCode(oldSaveVO.getOuCode());
            scpDemandOrderDSaveVO.setOuName(oldSaveVO.getOuName());
            scpDemandOrderDSaveVO.setSaleOuName(oldSaveVO.getSaleOuName());
            scpDemandOrderDSaveVO.setSaleOuCode(oldSaveVO.getSaleOuCode());
            scpDemandOrderDSaveVO.setSaleCustCode(oldSaveVO.getSaleCustCode());
            scpDemandOrderDSaveVO.setDeliveryType(oldSaveVO.getDeliveryType());
            scpDemandOrderDSaveVO.setProjectFeeFlag(Boolean.TRUE);
            scpDemandOrderDSaveVO.setCostType("SF");
            List<ItmItemAttachmentProviderDTO> imageInfo = skuImgMap.get(itmItemBaseRpcDTO.getId());
            if (CollUtil.isNotEmpty(imageInfo)) {
                ItmItemAttachmentProviderDTO attachmentProviderDTO = imageInfo.stream().filter(i -> i.getMajor() != null && i.getMajor() != false).findFirst().orElse(null);
                if (attachmentProviderDTO == null) {
                    attachmentProviderDTO = imageInfo.get(0);
                }
                String fileUrl = this.serverAddr + "/coordinator/el-fsm-service/api/fsm/download/" + attachmentProviderDTO.getFileCode();
                scpDemandOrderDSaveVO.setImgUrl(fileUrl);
            }
        } else {
            scpDemandOrderDSaveVO.setPrice(scpDemandOrderDSaveVO.getPrice().add(fee));
            scpDemandOrderDSaveVO.setPlanAmt(scpDemandOrderDSaveVO.getPlanAmt().add(fee));
            scpDemandOrderDSaveVO.setSettlementPrice(scpDemandOrderDSaveVO.getSettlementPrice().add(fee));
            scpDemandOrderDSaveVO.setSettlementAmt(scpDemandOrderDSaveVO.getSettlementAmt().add(fee));
            scpDemandOrderDSaveVO.setSalePrice(scpDemandOrderDSaveVO.getSalePrice().add(fee));
            scpDemandOrderDSaveVO.setSaleAmt(scpDemandOrderDSaveVO.getSaleAmt().add(fee));
            scpDemandOrderDSaveVO.setSettlementSalePrice(scpDemandOrderDSaveVO.getSettlementSalePrice().add(fee));
            scpDemandOrderDSaveVO.setSettlementSaleAmt(scpDemandOrderDSaveVO.getSettlementSaleAmt().add(fee));
        }
        return scpDemandOrderDSaveVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<ScpDemandOrderDSaveVO> saveVOS, AtomicInteger lineNo, String source) {
        List<ScpDemandOrderDSaveVO> saveList;
        Map<String, List<ScpDemandOrderDSaveVO>> groupMap = saveVOS.stream().filter(row -> row != null && row.getIsProjFeeCharged() != null && row.getIsProjFeeCharged() != false).collect(Collectors.groupingBy(v -> v.getSuppWhCode() + "|" + v.getOuCode()));
        List<String> custCodes = saveVOS.stream().map(ScpDemandOrderDSaveVO::getSaleCustCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, CustBaseDTO> custMap = this.rmiSalRpcService.getCustBaseMapByCode(custCodes);
        saveVOS.forEach(row -> {
            log.info("\u4fdd\u5b58\u8ba2\u8d27\u5355\u660e\u7ec6\uff1a\u9500\u552e\u516c\u53f8\u7f16\u7801\uff1a{},\u91c7\u8d2d\u516c\u53f8\u7f16\u7801\uff1a{},\u5ba2\u6237\u7f16\u7801\uff1a{}", new Object[]{row.getSaleOuCode(), row.getOuCode(), row.getSaleCustCode()});
            if (StrUtil.isBlank((CharSequence)row.getSaleOuCode()) && StrUtil.isBlank((CharSequence)row.getOuCode())) {
                row.setPayStatus(ScpUdcEnum.PAY_STATUS_NO_PAY.getValueCode());
            } else {
                CustBaseDTO custBaseInfoDTO = (CustBaseDTO)custMap.get(row.getSaleCustCode());
                log.info("\u5ba2\u6237\u7f16\u7801\uff1a{}\uff0c\u5ba2\u6237\u5185\u5916\u4fe1\u606f\uff1a{}", (Object)custBaseInfoDTO.getCustCode(), (Object)custBaseInfoDTO.getInOutCust());
                String payStatus = !"OUT".equals(custBaseInfoDTO.getInOutCust()) ? ScpUdcEnum.PAY_STATUS_NO_PAY.getValueCode() : ScpUdcEnum.PAY_STATUS_WAIT_PAY.getValueCode();
                row.setPayStatus(payStatus);
            }
        });
        ArrayList<Object> result = new ArrayList<Object>();
        if (CollUtil.isNotEmpty(groupMap)) {
            final String technologyCostsItemCode = SysUtils.getTechnologyCosts();
            final String marketingCostsItemCode = SysUtils.getMarketingCosts();
            final String operatingCostsItemCode = SysUtils.getOperatingCosts();
            ItmItemBaseRpcParam itmItemBaseRpcParam = new ItmItemBaseRpcParam();
            itmItemBaseRpcParam.setItemCodes((List)new ArrayList<String>(){
                {
                    this.add(technologyCostsItemCode);
                    this.add(marketingCostsItemCode);
                    this.add(operatingCostsItemCode);
                }
            });
            List<ItmItemBaseRpcDTO> itemBaseRpcDTOList = this.rmiItemService.findItemBaseRpcDtoByParam(itmItemBaseRpcParam);
            if (CollUtil.isEmpty(itemBaseRpcDTOList)) {
                throw new BusinessException("\u9879\u76ee\u8d39\u7528\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
            }
            List<Long> fetchImageIds = itemBaseRpcDTOList.stream().map(ItmItemBaseRpcDTO::getId).toList();
            List<ItmItemAttachmentProviderDTO> skuImgList = this.rmiItemService.findSkuImgByItemIds(fetchImageIds);
            HashMap<Long, List<ItmItemAttachmentProviderDTO>> skuImgMap = new HashMap();
            if (CollUtil.isNotEmpty(skuImgList)) {
                skuImgMap = skuImgList.stream().collect(Collectors.groupingBy(ItmItemAttachmentProviderDTO::getItemId));
            }
            Map<String, ItmItemBaseRpcDTO> itemMap = itemBaseRpcDTOList.stream().collect(Collectors.toMap(ItmItemBaseRpcDTO::getItemCode, itmItemBaseRpcDTO -> itmItemBaseRpcDTO));
            for (Map.Entry<String, List<ScpDemandOrderDSaveVO>> entry : groupMap.entrySet()) {
                List<ScpDemandOrderDSaveVO> value = entry.getValue();
                HashMap<String, ScpDemandOrderDSaveVO> map = new HashMap<String, ScpDemandOrderDSaveVO>();
                AtomicReference<BigDecimal> amt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                AtomicReference<BigDecimal> saleAmt = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                for (ScpDemandOrderDSaveVO scpDemandOrderDSaveVO : value) {
                    saleAmt.updateAndGet(v -> v.add(scpDemandOrderDSaveVO.getSettlementSaleAmt()));
                    amt.updateAndGet(v -> v.add(scpDemandOrderDSaveVO.getSettlementAmt()));
                    ScpDemandOrderDSaveVO scpDemandOrderDSaveVO2 = this.generateFeeSaveVO(lineNo, scpDemandOrderDSaveVO, (ScpDemandOrderDSaveVO)map.get(technologyCostsItemCode), itemMap, skuImgMap, technologyCostsItemCode, scpDemandOrderDSaveVO.getTechFee());
                    scpDemandOrderDSaveVO2.setTefPrice(scpDemandOrderDSaveVO2.getTefPrice().add(scpDemandOrderDSaveVO.getTefPrice()));
                    scpDemandOrderDSaveVO2.setTechFee(scpDemandOrderDSaveVO2.getTechFee().add(scpDemandOrderDSaveVO.getTechFee()));
                    scpDemandOrderDSaveVO2.setSaleOuCode(scpDemandOrderDSaveVO.getTefFeeOuCode());
                    scpDemandOrderDSaveVO2.setSaleOuName(scpDemandOrderDSaveVO.getTefFeeOuName());
                    scpDemandOrderDSaveVO2.setTefFeeOuCode(scpDemandOrderDSaveVO.getTefFeeOuCode());
                    map.put(technologyCostsItemCode, scpDemandOrderDSaveVO2);
                    ScpDemandOrderDSaveVO scpDemandOrderDSaveVO1 = this.generateFeeSaveVO(lineNo, scpDemandOrderDSaveVO, (ScpDemandOrderDSaveVO)map.get(marketingCostsItemCode), itemMap, skuImgMap, marketingCostsItemCode, scpDemandOrderDSaveVO.getMarketingFee());
                    scpDemandOrderDSaveVO1.setMefPrice(scpDemandOrderDSaveVO1.getMefPrice().add(scpDemandOrderDSaveVO.getMefPrice()));
                    scpDemandOrderDSaveVO1.setMarketingFee(scpDemandOrderDSaveVO1.getMarketingFee().add(scpDemandOrderDSaveVO.getMarketingFee()));
                    scpDemandOrderDSaveVO1.setSaleOuCode(scpDemandOrderDSaveVO.getMefFeeOuCode());
                    scpDemandOrderDSaveVO1.setSaleOuName(scpDemandOrderDSaveVO.getMefFeeOuName());
                    scpDemandOrderDSaveVO1.setMefFeeOuCode(scpDemandOrderDSaveVO.getMefFeeOuCode());
                    map.put(marketingCostsItemCode, scpDemandOrderDSaveVO1);
                    ScpDemandOrderDSaveVO scpDemandOrderDSaveVO22 = this.generateFeeSaveVO(lineNo, scpDemandOrderDSaveVO, (ScpDemandOrderDSaveVO)map.get(operatingCostsItemCode), itemMap, skuImgMap, operatingCostsItemCode, scpDemandOrderDSaveVO.getOperationFee());
                    scpDemandOrderDSaveVO22.setOefPrice(scpDemandOrderDSaveVO22.getOefPrice().add(scpDemandOrderDSaveVO.getOefPrice()));
                    scpDemandOrderDSaveVO22.setOperationFee(scpDemandOrderDSaveVO22.getOperationFee().add(scpDemandOrderDSaveVO.getOperationFee()));
                    scpDemandOrderDSaveVO22.setSaleOuCode(scpDemandOrderDSaveVO.getOefFeeOuCode());
                    scpDemandOrderDSaveVO22.setSaleOuName(scpDemandOrderDSaveVO.getOefFeeOuName());
                    scpDemandOrderDSaveVO22.setOefFeeOuCode(scpDemandOrderDSaveVO.getOefFeeOuCode());
                    map.put(operatingCostsItemCode, scpDemandOrderDSaveVO22);
                }
                List<Object> projectFeeList = new ArrayList();
                if (!map.isEmpty()) {
                    projectFeeList = map.values().stream().filter(Objects::nonNull).toList();
                    for (ScpDemandOrderDSaveVO scpDemandOrderDSaveVO2 : projectFeeList) {
                        saleAmt.updateAndGet(v -> v.add(scpDemandOrderDSaveVO2.getSettlementSaleAmt()));
                    }
                }
                if (amt.get().compareTo(saleAmt.get()) != 0) {
                    BigDecimal bigDecimal = amt.get().subtract(saleAmt.get());
                    value.stream().max(Comparator.comparing(ScpDemandOrderDSaveVO::getSettlementAmt)).ifPresent(max -> max.setSettlementAmt(max.getSettlementAmt().subtract(diff)));
                }
                result.addAll(value);
                if (!CollUtil.isNotEmpty(projectFeeList)) continue;
                result.addAll(projectFeeList);
            }
        } else {
            result.addAll(saveVOS);
        }
        List<ScpDemandOrderDSaveVO> updateList = result.stream().filter(saveVO -> ObjectUtil.isNotEmpty((Object)saveVO.getId())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(updateList)) {
            this.scpDemandOrderDRepo.saveAll(ScpDemandOrderDConvert.INSTANCE.saveVoListToDOList(updateList));
        }
        if (CollUtil.isNotEmpty(saveList = result.stream().filter(saveVO -> ObjectUtil.isEmpty((Object)saveVO.getId())).collect(Collectors.toList()))) {
            this.batchInsert(ScpDemandOrderDConvert.INSTANCE.saveVoListToDOList(saveList));
        }
        List<ScpDemandOrderDDO> saveRootList = this.scpDemandOrderDRepoProc.findByMasIdAndIsPushed(saveVOS.get(0).getMasId(), Boolean.FALSE);
        Map rootItemMap = saveRootList.stream().collect(Collectors.groupingBy(ScpDemandOrderDDO::groupByUuid)).values().stream().map(list -> (ScpDemandOrderDDO)list.get(0)).collect(Collectors.toMap(ScpDemandOrderDDO::groupByUuid, Function.identity(), (t1, t2) -> t1));
        saveRootList.forEach(row -> {
            ScpDemandOrderDDO item = (ScpDemandOrderDDO)rootItemMap.get(row.groupByUuid());
            row.setSourceId(item != null ? item.getId() : row.getId());
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSuppAllocPlanQty(Long demandId) {
        this.scpDemandOrderDRepo.updateSuppAllocPlanQty(demandId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateIsPushed(List<Long> dIds, String msg) {
        String syncMsg = StrUtil.isBlank((CharSequence)msg) ? "\u6210\u529f" : msg;
        this.scpDemandOrderDRepo.updateIsPushed(dIds, syncMsg);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSyncMsg(List<Long> dIds, String msg) {
        this.scpDemandOrderDRepo.updateSyncMsg(dIds, msg);
    }

    @Override
    public void updateSrcInfo(Long srcDocId, String srcDocNo, Long dId, Integer srcDocLineNo) {
        this.scpDemandOrderDRepo.updateSrcDocInfoByIds(srcDocId, srcDocNo, dId, srcDocLineNo);
    }

    @Override
    public void updatePOSrcInfo(Long id, Long srcDocId, String srcDocNo, String srcLineNO) {
        this.scpDemandOrderDRepoProc.updateSrcDocInfoById(id, srcDocId, srcDocNo, srcLineNO, "PO");
    }

    @Override
    public void updateSrcDoc2No(Long id, String srcDocNo) {
        this.scpDemandOrderDRepoProc.updateSrcDoc2No(id, srcDocNo);
    }

    @Override
    public void clearSrcDocInfo(Long docId) {
        this.scpDemandOrderDRepoProc.clearSrcDocInfo(docId);
    }

    @Override
    public void resetSrcDocQuantity(Long dId, BigDecimal qty) {
        this.scpDemandOrderDRepo.resetSrcDocQuantity(dId, qty);
    }

    @Override
    public void updateAllocQuantity(Long dId, BigDecimal qty) {
        this.scpDemandOrderDRepoProc.updateAllocQtyById(dId, qty);
    }

    @Override
    public void updateQuantity(Long dId, BigDecimal qty) {
        this.scpDemandOrderDRepo.updateQtyById(dId, qty);
    }

    @Override
    public void updateErrorMsg(Long dId, String errorMsg) {
        this.scpDemandOrderDRepoProc.updateErrorMsgById(dId, errorMsg);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteUnPushedItem(Long masId) {
        this.scpDemandOrderDRepo.deleteByMasIdAndIsPushed(masId, Boolean.FALSE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBySourceIds(List<Long> sourceIds) {
        this.scpDemandOrderDRepoProc.deleteBySourceIds(sourceIds);
    }

    @Override
    public BigDecimal findMaxLineNoPushedByMasId(Long masId) {
        return this.scpDemandOrderDRepoProc.findPushedItemMasId(masId);
    }

    @Override
    public List<ScpDemandOrderDDTO> findDemandOrderDByMasIds(List<Long> masIds) {
        return this.scpDemandOrderDRepo.findByMasIdIn(masIds).stream().map(ScpDemandOrderDConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    public List<Long> getMasIdByDId(List<Long> dIds) {
        return this.scpDemandOrderDRepoProc.getMasIdByDId(dIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelOrderByDIds(List<Long> dIds) {
        Optional byId = this.scpDemandOrderDRepo.findById(dIds.get(0));
        if (byId.isPresent()) {
            ScpDemandOrderDDO scpDemandOrderDDO = (ScpDemandOrderDDO)byId.get();
            String srcDocNo = scpDemandOrderDDO.getSrcDocNo();
            if (srcDocNo != null) {
                this.scpDemandOrderDRepoProc.updateStatusBySrcDocNo(srcDocNo, ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode());
            } else {
                this.scpDemandOrderDRepo.cancelOrderByDIds(dIds, ScpUdcEnum.DEO_STATUS_CLOSE.getValueCode());
            }
        }
    }

    @Override
    public List<ScpDemandOrderPayInfoRespVO> payInfo(Long masId) {
        return this.scpDemandOrderDRepoProc.findPayInfo(masId);
    }

    @Override
    public void updateRecvQty(Long dId, BigDecimal qty) {
        this.scpDemandOrderDRepo.updateRecvQtyById(dId, qty);
    }

    @Override
    public void updateReturnQty(Long dId, BigDecimal qty) {
        this.scpDemandOrderDRepo.updateReturnQtyById(dId, qty);
    }

    @Override
    public void updateCompensationQty(Long dId, BigDecimal qty) {
        this.scpDemandOrderDRepo.updateCompensateQtyById(dId, qty);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initAllocQuantity(Long masId) {
        this.scpDemandOrderDRepoProc.initAllocQuantity(masId);
    }

    @Override
    public void updatePayStatus(List<Long> ids, String payStatus) {
        this.scpDemandOrderDRepo.updatePayStatus(ids, payStatus);
    }

    @Override
    public List<ScpDemandOrderDDTO> findDemandOrderDBySrcDocId(Long srcDocId) {
        return this.scpDemandOrderDRepo.findBySrcDocId(srcDocId).stream().map(ScpDemandOrderDConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    public List<ScpDemandOrderDDTO> findDemandOrderDBySrcDocIdAndProjectFeeFlag(Long srcDocId, Boolean projectFeeFlag) {
        return this.scpDemandOrderDRepo.findBySrcDocIdAndProjectFeeFlag(srcDocId, false).stream().map(ScpDemandOrderDConvert.INSTANCE::doToDto).collect(Collectors.toList());
    }

    @Override
    public LocalDateTime findDocCreateTimeBySrcDocId(Long srcDocId) {
        return this.scpDemandOrderDRepoProc.findDocCreateTimeBySrcDocId(srcDocId);
    }

    @Override
    public List<ScpDemandOrderRelateDTO> findRelateOrderByMasId(Long masId) {
        return this.scpDemandOrderDRepoProc.findRelateOrderByMasId(masId);
    }

    public void batchInsert(List<ScpDemandOrderDDO> dataList) {
        int index = 0;
        int batchSize = 500;
        for (ScpDemandOrderDDO data : dataList) {
            this.entityManager.persist((Object)data);
            if (batchSize <= 1 || ++index % batchSize != 0) continue;
            this.entityManager.flush();
            this.entityManager.clear();
        }
        if (!dataList.isEmpty()) {
            this.entityManager.flush();
        }
    }

    public ScpDemandOrderDDomainServiceImpl(EntityManager entityManager, RmiItemService rmiItemService, RmiSalRpcService rmiSalRpcService, ScpDemandOrderRepoProc scpDemandOrderRepoProc, ScpDemandOrderDRepo scpDemandOrderDRepo, ScpDemandOrderDRepoProc scpDemandOrderDRepoProc) {
        this.entityManager = entityManager;
        this.rmiItemService = rmiItemService;
        this.rmiSalRpcService = rmiSalRpcService;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
        this.scpDemandOrderDRepo = scpDemandOrderDRepo;
        this.scpDemandOrderDRepoProc = scpDemandOrderDRepoProc;
    }
}

