package com.elitesland.scp.application.facade.vo.template;

import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @Auther: Mark
 * @Date: 2024/4/29 09:34
 * @Description:
 */
@Data
@ApiModel(description = "应用模板")
public class DemandOrderApplyRespVO implements Serializable {

    @ApiModelProperty("成功的数据")
    List<DemandOrderApplySuccessRespVO> success;

    @ApiModelProperty("失败的数据")
    List<DemandOrderApplyFailureRespVO> fail;

    @ApiModelProperty("全部商品匹配失败")
    boolean allFailed;

    @ApiModelProperty(hidden = true)
    //将模板内所有商品价格对象返回，传递给后续逻辑使用
            Map<String, PriPriceRpcDTO> priceMap;
}
