package com.elitesland.scp.domain.entity.item;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;


@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_cate_item_sale_scope_store")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "scp_cate_item_sale_scope_store", comment = "报货商品可售范围门店")
public class ScpCateItemSaleScopeStoreDO extends BaseModel implements Serializable {

    @Column(name = "mas_id", columnDefinition = "bigint")
    @Comment("主表id")
    private Long masId;

    @Comment(value = "适用门店编码")
    @Column(nullable = false)
    private String storeCode;

    @Column(name = "visible_status", columnDefinition = "tinyint(1)")
    @Comment("可见状态")
    private Boolean visibleStatus;

    @ApiModelProperty(value = "可见状态生效日期")
    @Comment("可见状态生效时间")
    @Column()
    private LocalDateTime visibleDateStart;

    @ApiModelProperty(value = "可见状态失效日期")
    @Comment("可见状态失效时间")
    @Column()
    private LocalDateTime visibleDateEnd;

}