/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.service.app;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.scp.application.facade.vo.param.app.OrgStoreListParam;
import com.elitesland.scp.application.facade.vo.param.authority.ScpManAuthorityParam;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreDemandCalendarParam;
import com.elitesland.scp.application.facade.vo.resp.app.OrgStoreRespVO;
import com.elitesland.scp.application.facade.vo.resp.authority.ScpManAuthorityPageRespVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.app.AppStoreListService;
import com.elitesland.scp.application.service.authority.ScpsmanAuthorityManager;
import com.elitesland.scp.common.CurrentUserDTO;
import com.elitesland.scp.domain.convert.AppStoreListConvert;
import com.elitesland.scp.domain.convert.authority.AppItmItemConvert;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.service.authority.ScpDemandAuthorityService;
import com.elitesland.scp.domain.service.calendar.ScpStoreDemandCalendarDomainService;
import com.elitesland.scp.infr.dto.calendar.ScpStoreDemandCalendarDTO;
import com.elitesland.scp.infr.repo.order.ScpDemandOrderRepoProc;
import com.elitesland.scp.infr.repo.scpsman.ScpsmanInfoRepoProc;
import com.elitesland.scp.infr.repo.storereceive.StoreReceiveRepoProc;
import com.elitesland.scp.rmi.RmiOrgStoreRpcService;
import com.elitesland.support.provider.org.dto.OrgStoreBaseRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreRpcDTO;
import com.elitesland.support.provider.org.param.OrgStoreRpcParam;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AppStoreListServiceImpl
implements AppStoreListService {
    private static final Logger log = LoggerFactory.getLogger(AppStoreListServiceImpl.class);
    private final RmiOrgStoreRpcService rmiOrgStoreRpcService;
    private final ScpDemandAuthorityService scpDemandAuthorityService;
    private final ScpDemandOrderRepoProc scpDemandOrderRepoProc;
    private final StoreReceiveRepoProc storeReceiveRepoProc;
    private final ScpStoreDemandCalendarDomainService scpStoreDemandCalendarDomainService;
    private final ScpsmanInfoRepoProc scpsmanInfoRepoProc;
    private final ScpsmanAuthorityManager scpsmanAuthorityManager;

    @Override
    public List<OrgStoreRespVO> list(OrgStoreListParam param) {
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        if (StringUtils.isEmpty((String)param.getStoreCode())) {
            throw new BusinessException("\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setType(0L);
        PagingVO<ScpManAuthorityPageRespVO> scpManAuthorityPageRespVOPagingVO = this.scpDemandAuthorityService.queryAuthorit(scpManAuthorityParam);
        if (scpManAuthorityPageRespVOPagingVO.isEmpty()) {
            return null;
        }
        List records = scpManAuthorityPageRespVOPagingVO.getRecords();
        List storeCodeList = records.stream().filter(t -> ObjectUtil.isNotNull((Object)t.getStWhCode())).map(ScpManAuthorityPageRespVO::getStWhCode).collect(Collectors.toList());
        OrgStoreRpcParam orgStoreRpcParam = new OrgStoreRpcParam();
        orgStoreRpcParam.setStoreCodes(storeCodeList);
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = this.rmiOrgStoreRpcService.appSearch(orgStoreRpcParam);
        List<OrgStoreRespVO> orgStoreRespVOS = AppStoreListConvert.INSTANCE.doToVO(orgStoreRpcDTOS);
        this.sumQuantity(orgStoreRespVOS);
        List<OrgStoreRespVO> orgStoreRespVOList = this.sortFirst(orgStoreRespVOS, param.getStoreCode());
        return orgStoreRespVOList;
    }

    @Override
    public PagingVO<OrgStoreRpcDTO> pageQuery(OrgStoreRpcParam param) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        ScpsmanInfoDO scpsmanInfo = this.scpsmanInfoRepoProc.getByScpsmanNo(currentUser.getUsername());
        if (scpsmanInfo == null) {
            return PagingVO.empty();
        }
        if (!Boolean.TRUE.equals(scpsmanInfo.getJurisdictionAll())) {
            Map<String, OrgStoreBaseRpcDTO> storeAuthed = this.scpsmanAuthorityManager.queryStoreList(currentUser, scpsmanInfo, -1, param.getStoreCodeOrNameLike());
            if (storeAuthed.isEmpty()) {
                return PagingVO.empty();
            }
            ArrayList<String> storeCodeList = new ArrayList<String>();
            for (String s : storeAuthed.keySet()) {
                if (!CollUtil.isEmpty((Collection)param.getStoreCodes()) && !param.getStoreCodes().contains(s)) continue;
                storeCodeList.add(s);
            }
            param.setStoreCodes(storeCodeList);
        }
        param.setCurrent(param.getCurrent());
        param.setSize(param.getSize());
        return this.rmiOrgStoreRpcService.rpcStoreQuery(param);
    }

    @Override
    public PagingVO<OrgStoreRpcDTO> pageQueryByDate(OrgStoreListParam param) {
        ScpManAuthorityParam scpManAuthorityParam = new ScpManAuthorityParam();
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (ObjectUtil.isEmpty((Object)currentUserDTO)) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u67e5\u8be2\u5f02\u5e38");
        }
        scpManAuthorityParam.setLoginAccount(currentUserDTO.getDetail().getUsername());
        scpManAuthorityParam.setType(0L);
        List<ScpManAuthorityPageRespVO> records = this.scpDemandAuthorityService.listQuery(scpManAuthorityParam);
        if (CollectionUtil.isEmpty(records)) {
            return null;
        }
        List storeCodeList = records.stream().filter(t -> ObjectUtil.isNotNull((Object)t.getStWhCode())).map(ScpManAuthorityPageRespVO::getStWhCode).collect(Collectors.toList());
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.addAll(storeCodeList);
        if (Objects.nonNull(param) && CollectionUtil.isNotEmpty(param.getStoreCodes())) {
            codeList.addAll(param.getStoreCodes());
        }
        param.setStoreCodes(codeList);
        OrgStoreRpcParam orgStoreRpcParam = AppItmItemConvert.INSTANCE.paramToRpcPram(param);
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = this.rmiOrgStoreRpcService.appSearch(orgStoreRpcParam);
        if (CollectionUtil.isEmpty(orgStoreRpcDTOS)) {
            return null;
        }
        ScpStoreDemandCalendarParam scpStoreDemandCalendarParam = new ScpStoreDemandCalendarParam();
        scpStoreDemandCalendarParam.setStoreCodeList(param.getStoreCodes());
        scpStoreDemandCalendarParam.setWorkStatus("W");
        scpStoreDemandCalendarParam.setYear(param.getYear());
        scpStoreDemandCalendarParam.setMonth(param.getMonth());
        scpStoreDemandCalendarParam.setDay(param.getDay());
        List<ScpStoreDemandCalendarDTO> scpStoreDemandCalendarDTOS = this.scpStoreDemandCalendarDomainService.listCalendarDTOs(scpStoreDemandCalendarParam);
        if (CollectionUtil.isEmpty(scpStoreDemandCalendarDTOS)) {
            return null;
        }
        List collect = orgStoreRpcDTOS.stream().filter(item -> scpStoreDemandCalendarDTOS.stream().anyMatch(i -> i.getStoreCode().equals(item.getStoreCode()))).collect(Collectors.toList());
        int startIndex = param.getCurrent() * param.getSize();
        int endIndex = Math.min(startIndex + param.getSize(), collect.size());
        List orgStoreRpcDTOS1 = collect.subList(startIndex, endIndex);
        return PagingVO.builder().total((long)collect.size()).records(orgStoreRpcDTOS1).build();
    }

    private void sumQuantity(List<OrgStoreRespVO> orgStoreRespVOS) {
        List<Long> storeIds;
        LocalDateTime todt = LocalDateTime.now();
        LocalDateTime fromdt = todt.minusMonths(1L);
        List<String> collect = orgStoreRespVOS.stream().filter(t -> ObjectUtil.isNotNull((Object)t.getStoreCode())).map(OrgStoreRespVO::getStoreCode).collect(Collectors.toList());
        List<Object> scpDemandOrderDOS = new ArrayList();
        List<Object> storeReceiveDOS = new ArrayList();
        if (CollectionUtil.isNotEmpty(collect)) {
            scpDemandOrderDOS = this.scpDemandOrderRepoProc.findByDemandWhStCodeInAndByCreateTime(collect, fromdt, todt);
        }
        if (CollectionUtil.isNotEmpty(storeIds = orgStoreRespVOS.stream().filter(t -> ObjectUtil.isNotNull((Object)t.getId())).map(OrgStoreRespVO::getId).collect(Collectors.toList()))) {
            storeReceiveDOS = this.storeReceiveRepoProc.findAllByStoreIdInAndByCreateTime(storeIds, fromdt, todt);
        }
        List<Object> finalScpDemandOrderDOS = scpDemandOrderDOS;
        ArrayList finalStoreReceiveDOS = storeReceiveDOS;
        orgStoreRespVOS.stream().forEach(t -> {
            List storeReceiveDOList;
            if (CollectionUtil.isNotEmpty((Collection)finalScpDemandOrderDOS)) {
                List scpDemandOrderDOS1 = finalScpDemandOrderDOS.stream().filter(od -> ObjectUtil.isNotNull((Object)od.getDemandWhStCode())).filter(or -> or.getDemandWhStCode().equals(t.getStoreCode())).collect(Collectors.toList());
                t.setOrderQuantity(CollectionUtil.isEmpty(scpDemandOrderDOS1) ? BigDecimal.ZERO : BigDecimal.valueOf(scpDemandOrderDOS1.size()));
            }
            if (CollectionUtil.isNotEmpty((Collection)finalStoreReceiveDOS) && CollectionUtil.isNotEmpty(storeReceiveDOList = finalStoreReceiveDOS.stream().filter(od -> ObjectUtil.isNotNull((Object)od.getStoreId())).filter(or -> or.getStoreId().equals(t.getId())).collect(Collectors.toList()))) {
                List r = storeReceiveDOList.stream().filter(od -> ObjectUtil.isNotNull((Object)od.getRtType())).filter(or -> or.getRtType().equals("R")).collect(Collectors.toList());
                List rtType = storeReceiveDOList.stream().filter(od -> ObjectUtil.isNotNull((Object)od.getRtType())).filter(or -> or.getRtType().equals("T")).collect(Collectors.toList());
                t.setStoreReceiptNumber(CollectionUtil.isEmpty(r) ? BigDecimal.ZERO : BigDecimal.valueOf(r.size()));
                t.setStoreReturnsNumber(CollectionUtil.isEmpty(rtType) ? BigDecimal.ZERO : BigDecimal.valueOf(rtType.size()));
            }
        });
    }

    private List<OrgStoreRespVO> sortFirst(List<OrgStoreRespVO> orgStoreRespVOS, String storeCode) {
        Optional<OrgStoreRespVO> first = orgStoreRespVOS.stream().filter(t -> ObjectUtil.isNotNull((Object)t.getStoreCode())).filter(org -> storeCode.equals(org.getStoreCode())).findFirst();
        if (first.isPresent()) {
            OrgStoreRespVO orgStoreRespVO = first.get();
            int index = orgStoreRespVOS.indexOf(orgStoreRespVO);
            if (index >= 0) {
                orgStoreRespVOS.remove(index);
            }
            orgStoreRespVOS.add(0, orgStoreRespVO);
        }
        return orgStoreRespVOS;
    }

    public AppStoreListServiceImpl(RmiOrgStoreRpcService rmiOrgStoreRpcService, ScpDemandAuthorityService scpDemandAuthorityService, ScpDemandOrderRepoProc scpDemandOrderRepoProc, StoreReceiveRepoProc storeReceiveRepoProc, ScpStoreDemandCalendarDomainService scpStoreDemandCalendarDomainService, ScpsmanInfoRepoProc scpsmanInfoRepoProc, ScpsmanAuthorityManager scpsmanAuthorityManager) {
        this.rmiOrgStoreRpcService = rmiOrgStoreRpcService;
        this.scpDemandAuthorityService = scpDemandAuthorityService;
        this.scpDemandOrderRepoProc = scpDemandOrderRepoProc;
        this.storeReceiveRepoProc = storeReceiveRepoProc;
        this.scpStoreDemandCalendarDomainService = scpStoreDemandCalendarDomainService;
        this.scpsmanInfoRepoProc = scpsmanInfoRepoProc;
        this.scpsmanAuthorityManager = scpsmanAuthorityManager;
    }
}

