/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.domain.service.minOrder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.minOrder.ScpMinOrderSettingPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.minOrder.ScpMinOrderSettingPageRespVO;
import com.elitesland.scp.application.facade.vo.save.minOrder.ScpMinOrderSettingSaveVO;
import com.elitesland.scp.domain.convert.minOrder.ScpMinOrderSettingConvert;
import com.elitesland.scp.domain.entity.minOrder.ScpMinOrderSettingDO;
import com.elitesland.scp.domain.service.minOrder.ScpMinOrderSettingDomainService;
import com.elitesland.scp.infr.dto.minOrder.ScpMinOrderSettingDTO;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingRepo;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingRepoProc;
import com.elitesland.scp.infr.repo.minOrder.ScpMinOrderSettingStoreRepoProc;
import com.elitesland.scp.rmi.RmiSysUDCService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScpMinOrderSettingDomainServiceImpl
implements ScpMinOrderSettingDomainService {
    private static final Logger log = LoggerFactory.getLogger(ScpMinOrderSettingDomainServiceImpl.class);
    private final ScpMinOrderSettingRepo scpMinOrderSettingRepo;
    private final ScpMinOrderSettingRepoProc scpMinOrderSettingRepoProc;
    private final ScpMinOrderSettingStoreRepoProc scpMinOrderSettingStoreRepoProc;
    private final RmiSysUDCService rmiSysUDCService;

    @Override
    @SysCodeProc
    public PagingVO<ScpMinOrderSettingPageRespVO> queryMinOrderSettingList(ScpMinOrderSettingPageParamVO paramVO) {
        long count = this.scpMinOrderSettingRepoProc.countMinOrderSetting(paramVO);
        if (count > 0L) {
            Map<String, String> docTypeMap = this.rmiSysUDCService.getCodeMap("yst-suplan", "OB_DOC_TYPE");
            List<ScpMinOrderSettingPageRespVO> MinOrderSettings = this.scpMinOrderSettingRepoProc.queryMinOrderSetting(paramVO);
            Map<Long, Long> usedIdMap = this.getUsedIdMap(MinOrderSettings);
            MinOrderSettings.forEach(item -> {
                if (StrUtil.isNotBlank((CharSequence)item.getDocType())) {
                    List<String> itemCateName = StrUtil.split((CharSequence)item.getDocType(), (char)',').stream().map(docTypeMap::get).collect(Collectors.toList());
                    item.setDocTypeNames(itemCateName);
                }
                item.setUseFlag(usedIdMap.containsKey(item.getId()));
            });
            return new PagingVO(count, MinOrderSettings);
        }
        return new PagingVO();
    }

    private Map<Long, Long> getUsedIdMap(List<ScpMinOrderSettingPageRespVO> MinOrderSettings) {
        List<Long> ids = MinOrderSettings.stream().map(BaseViewModel::getId).collect(Collectors.toList());
        List<Long> usedSettings = this.scpMinOrderSettingStoreRepoProc.findUsedSettingByMasIds(ids);
        if (CollUtil.isNotEmpty(usedSettings)) {
            return usedSettings.stream().collect(Collectors.toMap(Long::valueOf, Function.identity()));
        }
        return new HashMap<Long, Long>();
    }

    @Override
    @SysCodeProc
    public Optional<ScpMinOrderSettingDTO> findMinOrderSettingById(Long id) {
        return this.scpMinOrderSettingRepo.findById(id).map(ScpMinOrderSettingConvert.INSTANCE::doToDto);
    }

    @Override
    public Long saveMinOrderSetting(ScpMinOrderSettingSaveVO saveVO) {
        if (saveVO.getId() == null) {
            ScpMinOrderSettingDO intentDO = ScpMinOrderSettingConvert.INSTANCE.saveVoToDO(saveVO);
            intentDO.setDocType(StrUtil.join((CharSequence)",", saveVO.getDocTypes()));
            Long masId = ((ScpMinOrderSettingDO)this.scpMinOrderSettingRepo.save(intentDO)).getId();
            return masId;
        }
        Optional<ScpMinOrderSettingDO> option = this.scpMinOrderSettingRepo.findById(saveVO.getId());
        if (option.isEmpty()) {
            throw new BusinessException("\u8ba2\u8d27\u5f3a\u914d\u6d3b\u52a8ID\uff1a" + saveVO.getId() + "\u4e0d\u5b58\u5728");
        }
        ScpMinOrderSettingDO scpMinOrderSettingDO = option.get();
        ScpMinOrderSettingConvert.INSTANCE.copySaveParamToDo(saveVO, scpMinOrderSettingDO);
        scpMinOrderSettingDO.setDocType(StrUtil.join((CharSequence)",", saveVO.getDocTypes()));
        Long masId = ((ScpMinOrderSettingDO)this.scpMinOrderSettingRepo.save(scpMinOrderSettingDO)).getId();
        return masId;
    }

    @Override
    public void enableMinOrderSetting(List<Long> ids, Boolean enable) {
        this.scpMinOrderSettingRepoProc.enableMinOrderSetting(ids, enable);
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        List<ScpMinOrderSettingDO> settingDOS = this.scpMinOrderSettingRepo.findByIdIn(ids);
        this.scpMinOrderSettingRepoProc.deleteByIds(ids);
    }

    public ScpMinOrderSettingDomainServiceImpl(ScpMinOrderSettingRepo scpMinOrderSettingRepo, ScpMinOrderSettingRepoProc scpMinOrderSettingRepoProc, ScpMinOrderSettingStoreRepoProc scpMinOrderSettingStoreRepoProc, RmiSysUDCService rmiSysUDCService) {
        this.scpMinOrderSettingRepo = scpMinOrderSettingRepo;
        this.scpMinOrderSettingRepoProc = scpMinOrderSettingRepoProc;
        this.scpMinOrderSettingStoreRepoProc = scpMinOrderSettingStoreRepoProc;
        this.rmiSysUDCService = rmiSysUDCService;
    }
}

