package com.elitesland.scp.application.facade.vo.param.mrp;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 千元用量商品关联
 *
 * @author wangly
 * @date 2025-03-29
 */
@Getter
@Setter
public class ScpThousandUseRefParam extends AbstractOrderQueryParam {
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 主表id 精确 */
    @ApiModelProperty("主表id")
    private Long masId;
    /** 主表id 精确 */
    @ApiModelProperty("主表id集合")
    private List<Long> masIdList;
    /** 商品id 精确 */
    @ApiModelProperty("商品id")
    private Long itemId;
    /** 类型 精确 */
    @ApiModelProperty("类型")
    private String itemType;
    /** 商品编码 精确 */
    @ApiModelProperty("商品编码")
    private String itemCode;
    /** 商品名称 精确 */
    @ApiModelProperty("商品名称")
    private String itemName;
    /** 商品规格 精确 */
    @ApiModelProperty("商品规格")
    private String itemAttr;
    /** 商品状态 */
    @ApiModelProperty("商品状态")
    private String itemStatus;
    /** 商品基本单位 */
    @ApiModelProperty("商品基本单位")
    private String uom;
    /** 商品辅助单位 [UDC]COM:UOM 精确 */
    @ApiModelProperty("商品辅助单位 [UDC]COM:UOM")
    private String uom2;
    /** 预估千元用量 精确 */
    @ApiModelProperty("预估千元用量")
    private BigDecimal estimateThousNum;
    /** 调整千元用量 精确 */
    @ApiModelProperty("调整千元用量")
    private BigDecimal adjustThousNum;
    /**  精确 */
    @ApiModelProperty("")
    private String ext1;
    /**  精确 */
    @ApiModelProperty("")
    private String ext2;
    /**  精确 */
    @ApiModelProperty("")
    private String ext3;
}
