package com.elitesland.scp.application.facade.vo.resp.mrp;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("物料需求计划明细")
public class ScpMrpDRespVO extends BaseViewModel implements Serializable {
    
    private static final long serialVersionUID = -7666697678545938140L;

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("仓库id")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("预测安全库存")
    private BigDecimal predSafetyQty;

    @ApiModelProperty("预测目标库存")
    private BigDecimal predTargetQty;

    @ApiModelProperty("在库数")
    private BigDecimal invQty;

    @ApiModelProperty("毛需求")
    private BigDecimal grossDemand;

    @ApiModelProperty("采购在途数量")
    private BigDecimal purTransitQty;

    @ApiModelProperty("最小起订量")
    private BigDecimal moq;

    @ApiModelProperty("采购提前期")
    private BigDecimal purLeadTime;

    @ApiModelProperty("预期到货日期")
    private LocalDateTime expectArriveDate;

    @ApiModelProperty("月销量")
    private BigDecimal salQty;

    @ApiModelProperty("库存增减量")
    private BigDecimal ioQty;

    @ApiModelProperty("30天前的库存余额")
    private BigDecimal beforeQty;

    @ApiModelProperty("转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty("库存周转率")
    private BigDecimal invTurnover;

    @ApiModelProperty("标准库存周转率")
    private BigDecimal stdInvTurnover;

    @ApiModelProperty("净需求")
    private BigDecimal netDemand;

    @ApiModelProperty("采购计划单位")
    private String uom;

    @ApiModelProperty("采购计划单位名称")
    private String uomName;

    @ApiModelProperty("来源单据明细ID")
    private Long relateDocDid;

    @ApiModelProperty("明细采购计划")
    List<ScpMrpDPlanRespVO> scpMrpDPlanRespVOList;

}
