package com.elitesland.scp.application.facade.vo.save.minOrder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "订货强配活动保存参数")
public class ScpMinOrderSettingSaveVO implements Serializable {
    private static final long serialVersionUID = -3342841575717594695L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("活动名称")
    @NotBlank(message = "活动名称不能为空")
    private String activityName;

    @ApiModelProperty("活动类型")
    @NotBlank(message = "活动类型不能为空")
    private String activityType;

    @ApiModelProperty("单据类型集合")
    private List<String> docTypes;

    @ApiModelProperty(value = "生效日期")
    @NotNull(message = "生效日期不能为空")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效日期")
    @NotNull(message = "失效日期不能为空")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "是否全部门店，true:是，false：否")
    @NotNull(message = "是否全部门店入参不能为空")
    private Boolean allStoreFlag;

    @ApiModelProperty(value = "最大强配次数")
    private Integer maxNum;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("状态")
    private Boolean status;

    @ApiModelProperty(value = "区域集合")
    private List<ScpMinOrderSettingRegionSaveVO> regionList;

    @ApiModelProperty(value = "门店集合")
    private List<ScpMinOrderSettingStoreSaveVO> storeList;

    @ApiModelProperty(value = "商品集合")
    private List<ScpMinOrderSettingItemSaveVO> itemList;
}
