package com.elitesland.scp.application.facade.vo.scpsman;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 19:05
 * @Description:
 */
@Data
@ApiModel("计划员查询返回参数")
public class SalesmanInfoRespVO implements Serializable {
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("计划员编号")
    private String scpsmanNo;

    @ApiModelProperty("计划员类型")
    private String scpsmanType;

    @ApiModelProperty("计划员类型名称")
    private String scpsmanTypeName;

    @ApiModelProperty("业务类型")
    @SysCode(sys = "yst-suplan", mod = "BUSINESS_TYPE")
    private String businessType;
    private String businessTypeName;

    @ApiModelProperty("业务类型列表")
    private List<String> businessTypeList;
    private List<String> businessTypeNameList;

    @ApiModelProperty("管辖区域")
    private List<SalesmanRegionVO> jurisdiction;

    // @ApiModelProperty("管辖区域名称")
    // private String jurisdictionName;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty(value = "计划员表关联员工code")
    private String relateId;

    @ApiModelProperty("启用状态")
    private Integer enableStatus;

    @ApiModelProperty("启用状态名称")
    private String enableStatusName;

    @ApiModelProperty(value = "员工信息")
    private EmployeeInfoRespVO employeeInfoRespVO;

    @ApiModelProperty(value = "是否拥有下属")
    private boolean hasUnder = false;
    private String source;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("更新人")
    private String updater;

    @ApiModelProperty("更新时间")
    private LocalDateTime modifyTime;

    private Boolean jurisdictionAll;
}
