package com.elitesland.scp.application.facade.vo.template;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/4/24 16:34
 * @Description:
 */
@Data
@ApiModel(description = "详情")
public class DemandOrderDetailRespVO implements Serializable {
    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("备注")
    private String remark;


    @ApiModelProperty("订货模板编号")
    private String demandTemCode;

    @ApiModelProperty("订货模板名称")
    private String demandTemName;

    @ApiModelProperty("状态，1:启用，0:禁用")
    private Integer demandTemStatus;

    @ApiModelProperty("起始日期")
    private Date startDate;

    @ApiModelProperty("截止日期")
    private Date endDate;

    @ApiModelProperty("详细日期")
    private String detailedTime;

    @ApiModelProperty("商品分类")
    private List<String> itemCates;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("业务类型")
    @SysCode(sys = "yst-suplan", mod = "BUSINESS_TYPE")
    private String businessType;
    private String businessTypeName;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String type;
    private String typeName;

    private List<WhStZoObject> whStZoObjects;

    private List<ItemObject> itemObjects;

    @Data
    public static class WhStZoObject {
        @ApiModelProperty("类型")
        private String type;

        @ApiModelProperty("类型名称")
        private String typeName;

        @ApiModelProperty("门店/仓库/区域id")
        private Long whStZoId;

        @ApiModelProperty("门店/仓库/区域编号")
        private String whStZoCode;

        @ApiModelProperty("门店/仓库/区域名称")
        private String whStZoName;

        @ApiModelProperty("详细地址")
        private String detailedAddress;

        @ApiModelProperty("所属组织编码")
        private String belongOrgCode;

        @ApiModelProperty("所属组织名称")
        private String belongOrgName;

        @ApiModelProperty("所属公司编码")
        private String belongOuCode;

        @ApiModelProperty("所属公司名称")
        private String belongOuName;

        @ApiModelProperty("经营性质")
        private String storeType;

        @ApiModelProperty("经营性质名称")
        private String storeTypeName;
    }

    @Data
    public static class ItemObject {
        @ApiModelProperty("商品id")
        private Long itemId;

        @ApiModelProperty("商品编号")
        private String itemCode;

        @ApiModelProperty("商品名称")
        private String itemName;

        @ApiModelProperty("商品分类/品类")
        private String itemCateCode;

        @ApiModelProperty("商品分类/品类名称")
        private String itemCateName;

        @ApiModelProperty("商品规格")
        private String itemSpec;

        @ApiModelProperty("基本计量单位")
        private String basicUnitMeasure;
        @ApiModelProperty("基本计量单位名称")
        private String basicUnitMeasureName;

        @ApiModelProperty("重量")
        private BigDecimal weight;

        @ApiModelProperty("重量单位")
        private String weightUom;
        private String weightUomName;

        @ApiModelProperty("订货数量")
        private BigDecimal demandQuantity;

        @ApiModelProperty("总重量")
        private BigDecimal totalWeight;

        @ApiModelProperty("错误原因")
        private String errorReason;

        @ApiModelProperty("基本单位")
        private String uom2;

        @ApiModelProperty("基本单位名称")
        private String uom2Name;

        @ApiModelProperty("基本单位数量")
        private BigDecimal qty2;

        @ApiModelProperty("单位转换系数")
        private BigDecimal uomRatio;

        @ApiModelProperty(name = "有效小数位数")
        private Integer decimalPlaces;
    }
}
