package com.elitesland.scp.application.service.collect;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.application.facade.vo.cart.CartDetailRespVO;
import com.elitesland.scp.application.facade.vo.param.app.AppItemActivityItemPriceParamVO;
import com.elitesland.scp.application.facade.vo.param.app.ScpStoreItemParamVO;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectCancelVO;
import com.elitesland.scp.application.facade.vo.param.collect.ScpUserCollectParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.AppItemPriceRespVO;
import com.elitesland.scp.application.facade.vo.resp.collect.ScpUserCollectRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderDRespVO;
import com.elitesland.scp.application.facade.vo.resp.setting.ScpOrderSettingRespVO;
import com.elitesland.scp.application.facade.vo.save.collect.ScpUserCollectSaveVO;
import com.elitesland.scp.application.service.UserService;
import com.elitesland.scp.application.service.app.ScpCacheService;
import com.elitesland.scp.application.service.common.CommonPriceService;
import com.elitesland.scp.application.service.item.ScpCateItemService;
import com.elitesland.scp.common.ScpConstant;
import com.elitesland.scp.domain.convert.collect.ScpUserCollectConvert;
import com.elitesland.scp.domain.entity.cart.ScpStoreCartDO;
import com.elitesland.scp.domain.entity.collect.ScpUserCollectDO;
import com.elitesland.scp.domain.entity.item.ScpStoreItemDO;
import com.elitesland.scp.domain.service.setting.ScpOrderSettingDomainService;
import com.elitesland.scp.dto.item.ScpCateItemDTO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.param.CateItemRpcParam;
import com.elitesland.scp.rmi.RmiItemService;
import com.elitesland.scp.utils.CartRedisUtil;
import com.elitesland.scp.utils.CollectRedisUtil;
import com.elitesland.scp.utils.SysUtils;
import com.elitesland.support.provider.item.dto.*;
import com.elitesland.support.provider.item.param.ItmItemCateCodeParam;
import com.elitesland.support.provider.item.service.ItmItemRpcService;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import io.seata.common.util.CollectionUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ScpUserCollectServiceImpl implements ScpUserCollectService {

    private final CartRedisUtil cartRedisUtil;
    private final ScpCacheService scpCacheService;
    private final CollectRedisUtil collectRedisUtil;
    private final CommonPriceService commonPriceService;
    private final RmiItemService rmiItemService;
    private final ScpCateItemService scpCateItemService;
    private final ScpOrderSettingDomainService scpOrderSettingDomainService;
    private final ItmItemRpcService itmItemRpcService;

    @Override
    public List<ScpUserCollectRespVO> getUserList(ScpUserCollectParamVO paramVO) {
        // 获取当前登录任信息
        Long currentUserId = UserService.currentUserId();
        List<ScpUserCollectDO> userCollectItems = collectRedisUtil.getUserCollectItems(paramVO.getDemandWhStCode(), currentUserId);
        if (CollUtil.isEmpty(userCollectItems)) {
            return new ArrayList<>();
        }
        // 实时获取商品价格
        Map<String, AppItemPriceRespVO> priceMap = getItemPrice(paramVO, userCollectItems);
        List<ScpUserCollectRespVO> resultList = new ArrayList<>();
        Map<String, List<ScpUserCollectDO>> spuMap =
                userCollectItems.stream().collect(Collectors.groupingBy(item -> SysUtils.getItemKey(item.getCombineItemCode(), item.getItemCode())));


        Set<String> uniqueValues = new HashSet<>();
        Set<Long> itemIdSet = new HashSet<>();
        for (ScpUserCollectDO userCollectItem : userCollectItems) {
            Optional.ofNullable(userCollectItem.getSpuCode()).ifPresent(uniqueValues::add);
            Optional.ofNullable(userCollectItem.getItemId()).ifPresent(itemIdSet::add);
        }

        //查询商品的moq
        Map<String, List<ItmItemSpuBusinessRpcDTO>> moqMap;
        List<String> spuCodes = new ArrayList<>(uniqueValues);
        if (CollUtil.isNotEmpty(spuCodes)) {
            moqMap = rmiItemService.findMoqByParam(spuCodes, paramVO.getOuCode());
        } else {
            moqMap = new HashMap<>();
        }

        // 查询商品的scp分类
        List<Long> itemIds = new ArrayList<>(itemIdSet);
        Map<String, ItmCateCodeAndNameRpcDTO> cateMap = new HashMap<>();
        Map<Long, ScpCateItemDTO> scpCateItemMap = new HashMap<>();
        if (CollUtil.isNotEmpty(itemIds)) {
            CateItemRpcParam cateItemRpcParam = new CateItemRpcParam();
            cateItemRpcParam.setItemIds(itemIds);
            ApiResult<List<ScpCateItemDTO>> query = scpCateItemService.query(cateItemRpcParam);
            if (query.isSuccess()) {
                List<ScpCateItemDTO> items = query.getData();
                if (CollUtil.isNotEmpty(items)) {
                    List<String> itemCateCodes = items.stream().map(ScpCateItemDTO::getCateCode).collect(Collectors.toList());
                    if (CollUtil.isNotEmpty(itemCateCodes)) {
                        ItmItemCateCodeParam cateCodeParam = new ItmItemCateCodeParam();
                        cateCodeParam.setItemCateCodes(itemCateCodes);
                        ItmItemCateCodeRpcDTO itemCateCodeRpcDTO = itmItemRpcService.findCateCodeReItemCateCode(cateCodeParam);
                        cateMap = itemCateCodeRpcDTO.getCateMap();
                    }
                    scpCateItemMap = items.stream().collect(Collectors.toMap(ScpCateItemDTO::getItemId, item -> item));
                }
            } else {
                log.error("查询商品类型分类异常：{}", query.getMsg());
            }
        }

        //封装返回
        for (Map.Entry<String, List<ScpUserCollectDO>> entry : spuMap.entrySet()) {
            ScpUserCollectRespVO vo = new ScpUserCollectRespVO();
            List<ScpUserCollectDO> storeCartDOS = entry.getValue();
            // SPU信息赋值
            ScpUserCollectDO scpUserCollectDO = storeCartDOS.get(0);
            vo.setSpuId(scpUserCollectDO.getSpuId());
            vo.setSpuCode(scpUserCollectDO.getSpuCode());
            vo.setSpuName(scpUserCollectDO.getSpuName());
            vo.setSpec(scpUserCollectDO.getSpec());
            vo.setAnotherName(scpUserCollectDO.getAnotherName());
            vo.setCombineItemCode(scpUserCollectDO.getCombineItemCode());
            vo.setCombineItemName(scpUserCollectDO.getCombineItemName());
            // 如果SPU存在主图取主图，否则任取一张图片
            if (CollUtil.isNotEmpty(scpUserCollectDO.getSpuAttchmentList())) {
                Optional<ItmItemAttachmentRpcDTO> attachOpt = scpUserCollectDO.getSpuAttchmentList().stream().filter(attach -> attach.getMajor()).findFirst();
                vo.setUrl(attachOpt.isPresent() ? attachOpt.get().getUrl() : scpUserCollectDO.getSpuAttchmentList().get(0).getUrl());
            }
            // 如果SPU存在主图取主图，否则任取一张图片
            if (CollUtil.isNotEmpty(scpUserCollectDO.getSpuAttchmentList())) {
                Optional<ItmItemAttachmentRpcDTO> attachOpt = scpUserCollectDO.getSpuAttchmentList().stream().filter(attach -> attach.getMajor()).findFirst();
                vo.setUrl(attachOpt.isPresent() ? attachOpt.get().getUrl() : scpUserCollectDO.getSpuAttchmentList().get(0).getUrl());
            }
            vo.setItemCateCode(scpUserCollectDO.getItemCateCode());
            vo.setItemCateName(scpUserCollectDO.getItemCateName());
            vo.setDocType(scpUserCollectDO.getDocType());
            var moqList = moqMap.get(scpUserCollectDO.getSpuCode());
            // SKU商品信息赋值
            List<ScpUserCollectRespVO.ItemSpecObjectVO> itemSpecObjectVOS = new ArrayList<>();
            for (ScpUserCollectDO collectDO : storeCartDOS) {
                ScpUserCollectRespVO.ItemSpecObjectVO detailVo = new ScpUserCollectRespVO.ItemSpecObjectVO();
                detailVo.setUom(collectDO.getUom());
                detailVo.setUomName(collectDO.getUomName());
                detailVo.setItemCode(collectDO.getItemCode());
                detailVo.setItemId(collectDO.getItemId());
                detailVo.setItemName(collectDO.getItemName());
                detailVo.setItemAttrName(collectDO.getItemAttrName());
                AppItemPriceRespVO priceRespVO = priceMap.get(SysUtils.getItemKey(collectDO.getCombineItemCode(), collectDO.getItemCode()));
                if (priceRespVO != null) {
                    detailVo.setItemPrice(priceRespVO.getPrice());
                    detailVo.setSuppCode(priceRespVO.getSuppCode());
                    detailVo.setSuppName(priceRespVO.getSuppName());
                    detailVo.setSuppId(priceRespVO.getSuppId());
                    detailVo.setCostPrice(priceRespVO.getCostPrice());
                    detailVo.setPurPrice(priceRespVO.getPurPrice());
                    detailVo.setIsProjFeeCharged(priceRespVO.getIsProjFeeCharged());
                    detailVo.setStoreCode(priceRespVO.getStoreCode());
                    detailVo.setTefPrice(priceRespVO.getTefPrice());
                    detailVo.setMefPrice(priceRespVO.getMefPrice());
                    detailVo.setOefPrice(priceRespVO.getOefPrice());
                    detailVo.setSalePrice(priceRespVO.getSalePrice());
                    detailVo.setTefFeeOuCode(priceRespVO.getTefFeeOuCode());
                    detailVo.setTefFeeOuName(priceRespVO.getTefFeeOuName());
                    detailVo.setMefFeeOuCode(priceRespVO.getMefFeeOuCode());
                    detailVo.setMefFeeOuName(priceRespVO.getMefFeeOuName());
                    detailVo.setOefFeeOuCode(priceRespVO.getOefFeeOuCode());
                    detailVo.setOefFeeOuName(priceRespVO.getOefFeeOuName());
                    vo.setCombineQty(priceRespVO.getCombineQty());
                }
                //查询购物车商品数量
                ScpStoreCartDO storeCartItem = cartRedisUtil.getStoreCartItem(SysUtils.getItemKey(collectDO.getCombineItemCode() , collectDO.getItemCode()), paramVO.getDemandWhStCode(), collectDO.getDocType(), currentUserId);
                if (storeCartItem != null) {
                    detailVo.setQty(storeCartItem.getQty());
                } else {
                    detailVo.setQty(BigDecimal.ZERO);
                }
                detailVo.setUom2(collectDO.getUom2());
                detailVo.setUom2Name(collectDO.getUom2Name());
                detailVo.setDecimalPlaces(collectDO.getDecimalPlaces());
                detailVo.setUomRatio(collectDO.getUomRatio());
                detailVo.setItemType(collectDO.getItemType());

                // 设置scp商品品类
                if (collectDO.getItemId() != null) {
                    ScpCateItemDTO scpCateItemDTO = scpCateItemMap.get(collectDO.getItemId());
                    if (scpCateItemDTO != null) {
                        detailVo.setScpItemCateCode(scpCateItemDTO.getCateCode());
                        ItmCateCodeAndNameRpcDTO itmCateCodeAndNameRpcDTO = cateMap.get(scpCateItemDTO.getCateCode());
                        if (itmCateCodeAndNameRpcDTO != null) {
                            detailVo.setScpItemCateName(String.join(">", itmCateCodeAndNameRpcDTO.getCateNameList()));
                        }
                    }
                }
                // 最小起订量
                if (CollUtil.isNotEmpty(moqList)) {
                    detailVo.setMoq(moqList.get(0).getMoq());
                }
                itemSpecObjectVOS.add(detailVo);
            }
            vo.setItemSpecObjectVOS(itemSpecObjectVOS);
            resultList.add(vo);
        }

        // 组合商品处理
        List<ScpUserCollectRespVO> result = resultList.stream().filter(d -> StringUtils.isBlank(d.getCombineItemCode())).collect(Collectors.toList());
        Map<String, List<ScpUserCollectRespVO>> subItemMap = resultList.stream().filter(d -> StringUtils.isNotBlank(d.getCombineItemCode())).collect(Collectors.groupingBy(ScpUserCollectRespVO::getCombineItemCode));
        if (!subItemMap.isEmpty()) {
            subItemMap.forEach((k, v) -> {
                ScpUserCollectRespVO combineOrderDRespVO = new ScpUserCollectRespVO();
                combineOrderDRespVO.setCombineItemCode(k);
                combineOrderDRespVO.setCombineItemName(v.get(0).getCombineItemName());
                combineOrderDRespVO.setCombineItemFlag(Boolean.TRUE);
                combineOrderDRespVO.setSubItemList(v);
                result.add(combineOrderDRespVO);
            });
        }
        if(CollectionUtils.isNotEmpty(result)){
            List<Long> spuIds = result.stream().map(ScpUserCollectRespVO::getSpuId)
                    .filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<ItmItemAttachmentProviderDTO> skuImgByItemIds = itmItemRpcService.findSkuImgByItemIds(spuIds);
            if(CollectionUtils.isNotEmpty(skuImgByItemIds)){
                Map<Long, List<ItmItemAttachmentProviderDTO>> listMap = skuImgByItemIds.stream().collect(Collectors.groupingBy(ItmItemAttachmentProviderDTO::getItemId));
                result.forEach(d -> {
                    if(CollectionUtils.isNotEmpty(listMap.get(d.getSpuId()))){
                        d.setFileCode(listMap.get(d.getSpuId()).get(0).getFileCode());
                    }
                });
            }
        }

        return result;
    }

    /**
     * 获取商品价格
     *
     * @param paramVO
     * @param userCollectItems
     * @return
     */
    private Map<String, AppItemPriceRespVO>  getItemPrice(ScpUserCollectParamVO paramVO, List<ScpUserCollectDO> userCollectItems) {
        Map<String, AppItemPriceRespVO> resultMap = new HashMap<>();
        //实时获取价格
        Map<String, List<ScpUserCollectDO>> businessTypeMap = userCollectItems.stream()
                .filter(i -> i.getBusinessType() != null).collect(Collectors.groupingBy(ScpUserCollectDO::getBusinessType));
        businessTypeMap.forEach((businessType, userCollectDOS) -> {
            //获取单据类型配置
            ScpOrderSettingRespVO orderSetting = scpOrderSettingDomainService.findCacheByBusinessType(businessType, ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            var priceParamVOS = userCollectDOS.stream().map(row -> {
                AppItemActivityItemPriceParamVO priceParamVO = new AppItemActivityItemPriceParamVO();
                priceParamVO.setItemCode(row.getItemCode());
                priceParamVO.setItemId(row.getItemId());
                priceParamVO.setItemCateCode(row.getItemCateCode());
                priceParamVO.setUom(row.getUom());
                priceParamVO.setItemType2(row.getItemType2());
                priceParamVO.setCombineItemCode(row.getCombineItemCode());
                priceParamVO.setCombineItemFlag(StringUtils.isNotEmpty(row.getCombineItemCode()));
                return priceParamVO;
            }).collect(Collectors.toList());
            Map<String, AppItemPriceRespVO>  priceMap = commonPriceService.getNewPriceAndStockDetails(priceParamVOS, paramVO.getDemandWhStCode(), orderSetting,
                    ScpUdcEnum.DEMAND_SET_TYPE_0.getValueCode());
            resultMap.putAll(priceMap);
        });
        return resultMap;
    }

    @Override
    public Long add(ScpUserCollectSaveVO saveVO) {
        // 获取当前登录人信息
        Long currentUserId = UserService.currentUserId();
        // 要操作的收藏信息
        var cartOps = collectRedisUtil.getUserCollectOps(saveVO.getDemandWhStCode(), currentUserId);
        // 判断Redis是否有该商品的信息
        String product = (String) cartOps.get(SysUtils.generateRedisKey(ScpConstant.SPU, saveVO.getCombineItemCode(), saveVO.getItemCode()));
        if (StrUtil.isBlank(product)) {
            ScpStoreItemParamVO scpStoreItemParamVO = new ScpStoreItemParamVO();
            scpStoreItemParamVO.setSpuId(saveVO.getSpuId());
            scpStoreItemParamVO.setOuCode(saveVO.getOuCode());
            List<ScpStoreItemDO> itemDOS = scpCacheService.getItem(scpStoreItemParamVO);
            if (CollUtil.isEmpty(itemDOS)) {
                throw new BusinessException("未查询到商品");
            }
            // 编辑收藏夹商品
            List<ScpUserCollectDO> userCollectDOS = itemDOS.stream().map(row -> {
                ScpUserCollectDO scpUserCollectDO = ScpUserCollectConvert.INSTANCE.itemDoToCollectDo(row);
                scpUserCollectDO.setDocType(saveVO.getDocType());
                scpUserCollectDO.setBusinessType(saveVO.getBusinessType());
                scpUserCollectDO.setUserId(currentUserId);
                scpUserCollectDO.setDemandWhStCode(saveVO.getDemandWhStCode());
                scpUserCollectDO.setCreateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                scpUserCollectDO.setSkuAttchmentList(row.getSkuAttachmentList());
                scpUserCollectDO.setSpuAttchmentList(row.getSpuAttachmentList());
                scpUserCollectDO.setItemType2(row.getItemType2());
                scpUserCollectDO.setCombineItemCode(saveVO.getCombineItemCode());
                scpUserCollectDO.setCombineItemName(saveVO.getCombineItemName());
                scpUserCollectDO.setItemCode(row.getItemCode());
                return scpUserCollectDO;
            }).collect(Collectors.toList());
            // 收藏夹保存
            cartOps.put(SysUtils.generateRedisKey(ScpConstant.SPU, saveVO.getCombineItemCode(), saveVO.getItemCode()), JSON.toJSONString(userCollectDOS));
        }
        return 1L;
    }

    @Override
    public Boolean deleteBySpuIdAndUid(ScpUserCollectCancelVO cancelVO) {
        // 获取当前登录人信息
        Long currentUserId = UserService.currentUserId();
        // 要操作的收藏信息
        var cartOps = collectRedisUtil.getUserCollectOps(cancelVO.getDemandWhStCode(), currentUserId);
        Long delete = cartOps.delete(SysUtils.generateRedisKey(ScpConstant.SPU, cancelVO.getCombineItemCode(), cancelVO.getItemCode()));
        return delete > 0;
    }

    @Override
    public void batchSave(List<ScpUserCollectSaveVO> saveVOList) {
        if (CollUtil.isEmpty(saveVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "收藏品不能为空");
        }
        saveVOList.forEach(this::add);
    }
}
