package com.elitesland.scp.application.service.template;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.template.ScpDemandTemplateExportParamVO;
import com.elitesland.scp.application.facade.vo.template.ScpDemandTemplateExportRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @Auther: Mark
 * @Date: 2024/5/9 14:43
 * @Description:
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class DemandOrderTemplateExportService implements DataExport<ScpDemandTemplateExportRespVO,
        ScpDemandTemplateExportParamVO> {

    private final DemandOrderTemplateService demandOrderTemplateService;

    @Override
    public String getTmplCode() {
        return "yst_scp_demand_template_export";
    }

    @Override
    public PagingVO<ScpDemandTemplateExportRespVO> executeExport(ScpDemandTemplateExportParamVO queryParamVO) {
        return demandOrderTemplateService.queryTemplateExport(queryParamVO);
    }
}
