package com.elitesland.scp.application.web.scpsman;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectSub;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.authority.ScpsmanRegionPageQueryParam;
import com.elitesland.scp.application.facade.vo.scpsman.*;
import com.elitesland.scp.application.service.scpsman.ScpsmanInfoService;
import com.elitesland.scp.application.web.BaseController;
import com.elitesland.scp.common.ScpBusinessObjectConstant;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanInfoDO;
import com.elitesland.scp.domain.entity.scpsman.ScpsmanRegionDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 17:18
 * @Description:
 */
@RestController
@RequestMapping(value = "/scpsmanInfo", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "计划员信息", tags = {"计划员信息"})
@BusinessObject(businessType = ScpBusinessObjectConstant.SCPSMAN, businessDescription = "计划员信息", businessDoClass = ScpsmanInfoDO.class,
    subBusinessObject = {
        @BusinessObjectSub(businessDoClass = ScpsmanRegionDO.class, fieldNamePrefix = "mngRegion", fieldDescriptionPrefix = "[管理区域]")
    }
)
public class ScpsmanInfoController extends BaseController {

    @Autowired
    private ScpsmanInfoService scpsmanInfoService;
   /* @Autowired
    private SalesmanRpcServiceImpl salesmanRpcService;*/

    @PostMapping(value = "/save")
    @ApiOperation(value = "计划员信息保存更新")
    public ApiResult<Long> save(@RequestBody @Validated SalesmanInfoSaveVO salesmanInfoSaveVO) {
        var scpsmanInfo = scpsmanInfoService.save(salesmanInfoSaveVO).computeData();
        return ApiResult.ok(scpsmanInfo == null ? null : scpsmanInfo.getId());
    }

    @PostMapping(value = "/query")
    @ApiOperation(value = "计划员信息查询")
    public ApiResult<PagingVO<SalesmanInfoRespVO>> query(@RequestBody SalesmanInfoQueryVO salesmanInfoQueryVO) {
        return scpsmanInfoService.query(salesmanInfoQueryVO);
    }

    @GetMapping(value = "/queryDetail/{id}")
    @ApiOperation(value = "计划员详情信息查询")
    public ApiResult<SalesmanInfoDetailRespVO> queryDetail(@PathVariable("id") Long id) {
        return scpsmanInfoService.queryDetail(id);
    }

    @PostMapping(value = "/changeStatus")
    @ApiOperation(value = "计划员信息状态更新")
    public ApiResult<Object> changeStatus(@RequestBody @Validated SalesmanInfoChangeVO salesmanInfoChangeVO) {
        return scpsmanInfoService.changeStatus(salesmanInfoChangeVO);
    }

    @PostMapping(value = "/querySubordinate")
    @ApiOperation(value = "业务员下级信息查询")
    public ApiResult<PagingVO<SalesmanInfoRespVO>> querySubordinate(@RequestBody SalesmanSubordinateQueryVO salesmanSubordinateQueryVO) {
        return scpsmanInfoService.querySubordinate(salesmanSubordinateQueryVO);
    }

    @PostMapping(value = "/region/add")
    @ApiOperation(value = "新增管理区域")
    @ApiOperationSupport(order = 11)
    public ApiResult<Boolean> addRegion(@RequestBody ScpsmanRegionSaveVO save) {
        return scpsmanInfoService.addRegion(save);
    }

    @PostMapping(value = "/region/saveAll")
    @ApiOperation(value = "保存所有管理区域")
    @ApiOperationSupport(order = 12)
    public ApiResult<Boolean> saveAllRegion(@RequestBody ScpsmanRegionSaveVO save) {
        return scpsmanInfoService.saveRegion(save);
    }

    @PostMapping(value = "/region/remove")
    @ApiOperation(value = "删除管理区域")
    @ApiOperationSupport(order = 13)
    public ApiResult<Boolean> removeRegion(@RequestBody ScpsmanRegionSaveVO save) {
        return scpsmanInfoService.removeRegion(save);
    }

    @PostMapping(value = "/region/pageQuery")
    @ApiOperation(value = "分页查询管理区域")
    @ApiOperationSupport(order = 14)
    public ApiResult<PagingVO<SalesmanRegionVO>> pageQuery(@RequestBody ScpsmanRegionPageQueryParam queryParam) {
        return scpsmanInfoService.pageQuery(queryParam);
    }

    @GetMapping(value = "/auth/migrate")
    @ApiOperation(value = "迁移权限")
    @ApiOperationSupport(order = 19)
    ApiResult<Boolean> migrateAuthority(@RequestParam(name = "id", required = false) Long id,
                                        @RequestParam(name = "opType") Integer opType) {
        return scpsmanInfoService.migrateAuthority(id, opType);
    }
}
