package com.elitesland.scp.common;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Auther: Mark
 * @Date: 2024/3/18 17:23
 * @Description:
 */
@Data
public class UserDTO implements Serializable {
    private static final long serialVersionUID = -653632350370808311L;

    /**
     * 用户ID
     */
    private Long id;
    /**
     * 租户ID
     */
    private Long tenantId;
    /**
     * 备注
     */
    private String remark;
    /**
     * 记录创建者ID
     */
    private Long createUserId;
    /**
     * 记录创建者
     */
    private String creator;
    /**
     * 记录创建时间
     */
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    private Long modifyUserId;
    /**
     * 记录最后更新者
     */
    private String updater;
    /**
     * 记录最后更新时间
     */
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    private Integer deleteFlag;
    /**
     * 用户账号名称
     */
    private String username;
    /**
     * 用户姓氏
     */
    private String lastName;
    /**
     * 用户名称
     */
    private String firstName;
    /**
     * 用户手机号码
     */
    private String mobile;
    /**
     * 用户邮箱地址
     */
    private String email;
    /**
     * password
     */
    private String password;
    /**
     * 账号来源, sys： 系统创建；wec：微信创建；oth：其他方式
     */
    private String sourceType;
    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 员工ID
     */
    private Long employeeId;
}
