package com.elitesland.scp.domain.convert.order;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.inv.dto.invTro.InvTroPayRpcDTO;
import com.elitesland.pur.dto.po.PurPoPayRpcDTO;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderImportEntity;
import com.elitesland.scp.application.facade.vo.param.order.ScpDemandOrderItemParamVO;
import com.elitesland.scp.application.facade.vo.resp.app.ScpOrderPayRespVO;
import com.elitesland.scp.application.facade.vo.resp.order.ScpDemandOrderRespVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSaveVO;
import com.elitesland.scp.application.facade.vo.save.order.ScpDemandOrderSubmitVO;
import com.elitesland.scp.domain.entity.order.ScpDemandOrderDO;
import com.elitesland.scp.dto.order.ScpDemandOrderDRpcDTO;
import com.elitesland.scp.dto.order.ScpDemandOrderRpcDTO;
import com.elitesland.scp.infr.dto.order.ScpDemandOrderDTO;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2024/03/18
 */
@Mapper(config = BaseMapperConfig.class)
public interface ScpDemandOrderConvert {
    ScpDemandOrderConvert INSTANCE = Mappers.getMapper(ScpDemandOrderConvert.class);

    ScpDemandOrderRespVO dtoToRespVO(ScpDemandOrderDTO orderDTO);

    ScpDemandOrderDTO doToDto(ScpDemandOrderDO orderDO);
    List<ScpDemandOrderRpcDTO> dos2RPCDtos(List<ScpDemandOrderDO> orderDOList);
    ScpDemandOrderDO saveVoToDO(ScpDemandOrderSaveVO saveVO);

    ScpDemandOrderSaveVO submitVoToSaveVO(ScpDemandOrderSubmitVO submitVO);

    @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
    void copySaveParamToDo(ScpDemandOrderSaveVO saveVO, @MappingTarget ScpDemandOrderDO intentDO);

    List<ScpOrderPayRespVO.PayItem> troDtosToRespVOS(List<InvTroPayRpcDTO> troPayList);

    List<ScpOrderPayRespVO.PayItem> purDtosToRespVOS(List<PurPoPayRpcDTO> purPoPayRpcDTOList);

    ScpDemandOrderRpcDTO dto2RpcDTO(ScpDemandOrderDTO scpDemandOrderDTO);

    List<ScpDemandOrderItemParamVO> importEntityToParamVO(List<ScpDemandOrderImportEntity> itemList);
}
