package com.elitesland.scp.domain.entity.calendar;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * @Author: ryan.xu
 * @since 2024/12/23
 */
@Data
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "scp_store_calendar_set_line")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@org.hibernate.annotations.Table(appliesTo = "scp_store_calendar_set_line", comment = "门店订货日历配置明细表")
public class ScpStoreCalendarSetLineDO extends BaseModel implements Serializable {

    @Column()
    @Comment("主表ID")
    private Long masId;

    @Column()
    @Comment("星期x")
    private Integer todayWeek;

    @ApiModelProperty("门店ID")
    @Comment("门店ID")
    @Column()
    private Long storeId;

    @ApiModelProperty("门店编码")
    @Comment("门店编码")
    @Column()
    private String storeCode;

    @ApiModelProperty("门店名称")
    @Comment("门店名称")
    @Column()
    private String storeName;

    @ApiModelProperty("公司ID")
    @Comment("公司ID")
    @Column()
    private Long ouId;

    @ApiModelProperty("公司编码")
    @Comment("公司编码")
    @Column()
    private String ouCode;

    @ApiModelProperty("客户ID")
    @Comment("客户ID")
    @Column()
    private Long custId;

    @ApiModelProperty("客户编码")
    @Comment("客户编码")
    @Column()
    private String custCode;

    @ApiModelProperty("品牌编码")
    @Comment("品牌编码")
    @Column()
    private String brandCode;

    @ApiModelProperty("区域编码")
    @Comment("区域编码")
    @Column()
    private String regionCode;

    @ApiModelProperty("经营性质")
    @Comment("经营性质")
    @Column()
    private String storeType2;

}