/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.application.web.calendar;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.calendar.ScpStoreCalendarSetPageParamVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetPageRespVO;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetRespVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetApproveVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetSaveVO;
import com.elitesland.scp.application.facade.vo.save.calendar.ScpStoreCalendarSetSubmitVO;
import com.elitesland.scp.application.service.calendar.ScpStoreCalendarSetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/calendar/setting"}, produces={"application/json"})
public class ScpStoreCalendarSetController {
    private static final Logger log = LoggerFactory.getLogger(ScpStoreCalendarSetController.class);
    private final ScpStoreCalendarSetService scpStoreCalendarSetService;

    @ApiOperation(value="\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e-  \u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<ScpStoreCalendarSetPageRespVO>> queryCalendarSet(@RequestBody ScpStoreCalendarSetPageParamVO paramVO) {
        log.info("[SCP-STORE-CALENDAR-SET] queryCalendarSet  param ={}", (Object)JSONUtil.toJsonStr((Object)((Object)paramVO)));
        return ApiResult.ok(this.scpStoreCalendarSetService.page(paramVO));
    }

    @ApiOperation(value="\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e - \u67e5\u8be2\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/findIdOne/{id}"})
    public ApiResult<ScpStoreCalendarSetRespVO> findIdOne(@PathVariable Long id) {
        log.info("[SCP-STORE-CALENDAR-SET] findIdOne, id ={}", (Object)id);
        return this.scpStoreCalendarSetService.findCalendarSetById(id).map(ApiResult::ok).orElse(ApiResult.fail((ApiCode)ApiCode.NOT_FOUND));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e - \u4fdd\u5b58")
    public ApiResult<Long> saveCalendarSet(@RequestBody @Validated ScpStoreCalendarSetSaveVO saveVO) {
        log.info("[SCP-STORE-CALENDAR-SET] saveCalendarSet  saveVO ={}", (Object)JSONUtil.toJsonStr((Object)saveVO));
        return ApiResult.ok((Object)this.scpStoreCalendarSetService.saveCalendarSet(saveVO));
    }

    @ApiOperation(value="\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e - \u5220\u9664")
    @PostMapping(value={"/delete"})
    public ApiResult<Object> delete(@RequestBody List<Long> ids) {
        log.info("[SCP-STORE-CALENDAR-SET] delete ids = {}", (Object)JSONUtil.toJsonStr(ids));
        this.scpStoreCalendarSetService.deleteByIds(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u95e8\u5e97\u8ba2\u8d27\u65e5\u5386\u914d\u7f6e - \u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public ApiResult<Object> submit(@RequestBody @Validated ScpStoreCalendarSetSubmitVO submitVO) {
        log.info("[SCP-STORE-CALENDAR-SET-LINE] submit paramVO = {}", (Object)JSONUtil.toJsonStr((Object)submitVO));
        this.scpStoreCalendarSetService.submit(submitVO);
        return ApiResult.ok();
    }

    @PostMapping(value={"/batch/approve"})
    @ApiOperation(value="\u6279\u91cf\u5ba1\u6279\u901a\u8fc7")
    public ApiResult<Object> batchApprove(@RequestBody ScpStoreCalendarSetApproveVO approveSaveParam) {
        this.scpStoreCalendarSetService.batchApprove(approveSaveParam);
        return ApiResult.ok();
    }

    @PostMapping(value={"/batch/reject"})
    @ApiOperation(value="\u6279\u91cf\u5ba1\u6279\u62d2\u7edd")
    public ApiResult<Object> batchReject(@RequestBody ScpStoreCalendarSetApproveVO approveSaveParam) {
        this.scpStoreCalendarSetService.batchReject(approveSaveParam);
        return ApiResult.ok();
    }

    public ScpStoreCalendarSetController(ScpStoreCalendarSetService scpStoreCalendarSetService) {
        this.scpStoreCalendarSetService = scpStoreCalendarSetService;
    }
}

