/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.scp.job.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.domain.vo.survey.SurveyPagingParam;
import com.elitesland.scp.domain.vo.survey.SurveyRespVO;
import com.elitesland.scp.enums.ScpUdcEnum;
import com.elitesland.scp.infr.repo.survey.SurveyRepoProc;
import com.elitesland.scp.job.service.ScpSurveyInvalidJobService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScpSurveyInvalidJobServiceImpl
implements ScpSurveyInvalidJobService {
    private static final Logger log = LoggerFactory.getLogger(ScpSurveyInvalidJobServiceImpl.class);
    private final SurveyRepoProc surveyRepoProc;

    @Override
    public void autoInvalid() {
        SurveyPagingParam pagingParam = new SurveyPagingParam();
        pagingParam.setSize(10000);
        pagingParam.setNotSurveyStatus(ScpUdcEnum.SURVEY_STATUS_40.getValueCode());
        pagingParam.setNeedFilterInvalidTime("Y");
        PagingVO<SurveyRespVO> search = this.surveyRepoProc.search(pagingParam);
        if (CollectionUtils.isNotEmpty((Collection)search.getRecords())) {
            List<Long> suvIdList = search.getRecords().stream().map(SurveyRespVO::getId).toList();
            this.surveyRepoProc.invalid(suvIdList);
        }
    }

    public ScpSurveyInvalidJobServiceImpl(SurveyRepoProc surveyRepoProc) {
        this.surveyRepoProc = surveyRepoProc;
    }
}

