package com.elitesland.scp.application.facade.vo.param.app;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@Data
@ApiModel(value = "商品库存查询入参")
public class AppInvStkPageParamVO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -8387700128516698775L;

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    @ApiModelProperty(value = "商品品类编码集合")
    private List<String> itemCateCodes;

    @ApiModelProperty(name = "关键词")
    private String keyword;

    @ApiModelProperty(name = "仓库ID")
    private String whCode;

}
