package com.elitesland.scp.application.facade.vo.resp.app;

import com.elitesland.support.provider.item.dto.ItmItemAttachmentRpcDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel("商品详情")
public class AppItmSpuRespVO implements Serializable {
    private static final long serialVersionUID = 5187411894221252125L;

    @ApiModelProperty(value = "spuId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty(value = "spu编码")
    private String spuCode;

    @ApiModelProperty(value = "spu名称")
    private String spuName;

    @ApiModelProperty(value = "商品别名")
    private String anotherName;

    @ApiModelProperty("商品SKU条码")
    private String barCode;

    @ApiModelProperty("规格型号")
    private String spec;

    @ApiModelProperty(value = "类型")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty(value = "品牌")
    private String brand;
    private String brandName;

    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    @ApiModelProperty(value = "商品品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品品类名称")
    private String itemCateName;

    @ApiModelProperty(name = "详细描述")
    private String itemDescribe;

    @ApiModelProperty("重量")
    private String weight;

    @ApiModelProperty("是否收藏，是：true, 否：false")
    private Boolean collectFlag;

    @ApiModelProperty(value = "SPU商品图片")
    private List<ItmItemAttachmentRpcDTO> spuAttchmentList;

    @ApiModelProperty(value = "SKU商品图片")
    private List<ItmItemAttachmentRpcDTO> skuAttchmentList;

}
