package com.elitesland.scp.application.facade.vo.resp.minOrder;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("订货强配详情返回")
public class ScpMinOrderSettingRespVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -7429845441661010333L;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("活动名称")
    private String activityName;

    @ApiModelProperty("活动类型")
    @SysCode(sys = "yst-suplan", mod = "MINORDER_SETTING_TYPE")
    private String activityType;
    private String activityTypeName;

    @ApiModelProperty("单据类型")
    private String docType;

    private List<String> docTypes;

    @ApiModelProperty("单据类型名称集合")
    private List<String> docTypeNames;

    @ApiModelProperty(value = "生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "是否全部门店，true:是，false：否")
    private Boolean allStoreFlag;

    @ApiModelProperty(value = "最大强配次数")
    private Integer maxAllocNum;

    @ApiModelProperty("商品列表")
    private List<ScpMinOrderSettingItemRespVO> itemRespVOList;

    @ApiModelProperty("强配区域列表")
    private List<ScpMinOrderSettingRegionRespVO> regionRespVOList;

    @ApiModelProperty("强配门店列表")
    private List<ScpMinOrderSettingStoreRespVO> storeRespVOList;

}
