package com.elitesland.scp.application.facade.vo.resp.mrp;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;


/**
  * 千元用量商品关联
  *
  * @author wangly
  * @date 2025-03-29
  */
@Getter
@Setter
public class ScpThousandUseRefVO extends BaseViewModel implements Serializable {
    /** 主表id */
    @ApiModelProperty("主表id")
    private Long masId;
    /** 商品id */
    @ApiModelProperty("商品id")
    private Long itemId;
    /** 类型 */
    @ApiModelProperty("类型")
    private String itemType;
    /** 商品编码 */
    @ApiModelProperty("商品编码")
    private String itemCode;
    /** 商品名称 */
    @ApiModelProperty("商品名称")
    private String itemName;
    /** 商品规格 */
    @ApiModelProperty("商品规格")
    private String itemAttr;

    /** 商品状态 */
    @ApiModelProperty("商品状态")
    private String itemStatus;

    /** 商品基本单位 */
    @ApiModelProperty("商品基本单位")
    private String uom;

    /** 商品辅助单位 [UDC]COM:UOM */
    @ApiModelProperty("商品辅助单位 [UDC]COM:UOM")
    private String uom2;

    /** 预估千元用量 */
    @ApiModelProperty("预估千元用量")
    private BigDecimal estimateThousNum;
    /** 调整千元用量 */
    @ApiModelProperty("调整千元用量")
    private BigDecimal adjustThousNum;

    @ApiModelProperty(value = "拓展字段1")
    private String ext1;

    @ApiModelProperty(value = "拓展字段2")
    private String ext2;

    @ApiModelProperty(value = "拓展字段3")
    private String ext3;

    @ApiModelProperty(value = "门店id")
    private Long stWhId;

    @ApiModelProperty(value = "门店编码	")
    private String stWhCode;

    @ApiModelProperty(value = "门店名称")
    private String stWhName;


    @ApiModelProperty(value = "参考日期开始")
    private Date referenceDataStart;

    @ApiModelProperty(value = "参考日期结束")
    private Date referenceDataEnd;

    @ApiModelProperty(value = "有效日期开始")
    private Date validDataStart;

    @ApiModelProperty(value = "有效日期结束")
    private Date validDataEnd;
}
