package com.elitesland.scp.application.facade.vo.resp.order;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("订货订单计算实体")
public class ScpDemandOrderComputeVO implements Serializable {
    private static final long serialVersionUID = 9083982178660690049L;

    @ApiModelProperty("订货订单明细主键ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("订货订单编码")
    private String docCode;

    @ApiModelProperty("订货订单状态")
    private String docStatus;

    @ApiModelProperty("需求门店/仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long demandWhStId;

    @ApiModelProperty("需求门店/仓库编码")
    private String demandWhStCode;

    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("供应仓库id、供应商id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppWhId;

    @ApiModelProperty("供应仓库编码、供应商编码")
    private String suppWhCode;

    @ApiModelProperty("供应仓库名称、供应商名称")
    private String suppWhName;

    @ApiModelProperty("采购公司ID")
    private Long ouId;

    @ApiModelProperty("采购公司编码")
    private String ouCode;

    @ApiModelProperty("订货单位")
    private String unit;

    @ApiModelProperty("拆分需求数量")
    private BigDecimal allocationDeQuantity;

    @ApiModelProperty("计划数量")
    private BigDecimal planQuantity;

    @ApiModelProperty("是否推送")
    private Boolean isPushed;

    @ApiModelProperty("是否已计算")
    private Boolean isCalculated;

    @ApiModelProperty(value = "是否允许支付超时")
    private Boolean allowPayTimeout;
}
