package com.elitesland.scp.application.facade.vo.save.calendar;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.scp.application.facade.vo.resp.calendar.ScpStoreCalendarSetLineRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel("门店订货日历配置分页返回")
public class ScpStoreCalendarSetImportDTO extends BaseViewModel implements Serializable {

    @ApiModelProperty("起始年份")
    private Integer startYear;

    @ApiModelProperty("结束年份")
    private Integer endYear;

    @ApiModelProperty(value = "类型")
    private String type;

    @ApiModelProperty("配送类型")
    private String deliveryType;

    @ApiModelProperty("门店区域编码列表")
    private List<String> storeRegionCodeList;

    @ApiModelProperty(value = "星期一启用")
    private List<ScpStoreCalendarSetLineRespVO> monday;

    @ApiModelProperty(value = "星期一不启用")
    private List<ScpStoreCalendarSetLineRespVO> monday2;

    @ApiModelProperty(value = "星期二")
    private List<ScpStoreCalendarSetLineRespVO> tuesday;

    @ApiModelProperty(value = "星期二不启用")
    private List<ScpStoreCalendarSetLineRespVO> tuesday2;

    @ApiModelProperty(value = "星期三")
    private List<ScpStoreCalendarSetLineRespVO> wednesday;

    @ApiModelProperty(value = "星期三不启用")
    private List<ScpStoreCalendarSetLineRespVO> wednesday2;

    @ApiModelProperty(value = "星期四")
    private List<ScpStoreCalendarSetLineRespVO> thursday;

    @ApiModelProperty(value = "星期四不启用")
    private List<ScpStoreCalendarSetLineRespVO> thursday2;

    @ApiModelProperty(value = "星期五")
    private List<ScpStoreCalendarSetLineRespVO> friday;

    @ApiModelProperty(value = "星期五不启用")
    private List<ScpStoreCalendarSetLineRespVO> friday2;

    @ApiModelProperty(value = "星期六")
    private List<ScpStoreCalendarSetLineRespVO> saturday;

    @ApiModelProperty(value = "星期六不启用")
    private List<ScpStoreCalendarSetLineRespVO> saturday2;

    @ApiModelProperty(value = "星期日")
    private List<ScpStoreCalendarSetLineRespVO> sunday;

    @ApiModelProperty(value = "星期日不启用")
    private List<ScpStoreCalendarSetLineRespVO> sunday2;
}
