package com.elitesland.scp.application.web.mrp;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.scp.application.facade.vo.param.mrp.ScpThousandUseRefParam;
import com.elitesland.scp.application.facade.vo.resp.mrp.ScpThousandUseRefVO;
import com.elitesland.scp.application.service.mrp.ScpThousandUseRefService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 *
 * 千元用量商品关联
 * @author wangly
 * @since 2025-03-29
 */
@RestController
@RequestMapping("/mrp/scpThousandUseRef")
@RequiredArgsConstructor
@Api(tags = {""})
public class ScpThousandUseRefController {
    private final ScpThousandUseRefService scpThousandUseRefService;

    /**
     * 千元用量商品关联-新增
     *
     * @folder 千元用量商品关联
     * @param param 有效载荷
     * @return {@link ApiResult}
     */
    @PostMapping("/save")
    @ApiOperation("千元用量商品关联-保存")
    public ApiResult<ScpThousandUseRefVO> insert(@RequestBody ScpThousandUseRefParam param){
        return ApiResult.ok(scpThousandUseRefService.insert(param));
    }

    /**
     * 千元用量商品关联-更新
     *
     * @folder 千元用量商品关联
     * @param param 有效载荷
     * @return {@link ApiResult}
     */
    @PostMapping("/update")
    @ApiOperation("千元用量商品关联-更新")
    public ApiResult<ScpThousandUseRefVO> update(@RequestBody ScpThousandUseRefParam param){
        return ApiResult.ok(scpThousandUseRefService.update(param));
    }

    /**
     * 千元用量商品关联-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 千元用量商品关联
     * @param param 有效载荷
     * @return {@link ApiResult}
     */
    @PostMapping("/updateByKeyDynamic")
    @ApiOperation("千元用量商品关联-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public ApiResult<Long> updateByKeyDynamic(@RequestBody ScpThousandUseRefParam param){
        return ApiResult.ok(scpThousandUseRefService.updateByKeyDynamic(param));
    }

    /**
     * 千元用量商品关联-主键查询
     *
     * @folder 千元用量商品关联
     * @param key 关键
     * @return {@link ApiResult}
     */
    @GetMapping("/{key}")
    @ApiOperation("千元用量商品关联-主键查询")
    public ApiResult<ScpThousandUseRefVO> queryOneByKey(@PathVariable Long key) {
        return ApiResult.ok(scpThousandUseRefService.queryByKey(key));
    }

    /**
     * 千元用量商品关联-分页
     *
     * @folder 千元用量商品关联
     * @param param 查询
     * @return {@link ApiResult}
     */
    @PostMapping("/paging")
    @ApiOperation("千元用量商品关联-分页")
    public ApiResult<PagingVO<ScpThousandUseRefVO>> paging(@RequestBody ScpThousandUseRefParam param) {
        return ApiResult.ok(scpThousandUseRefService.queryPaging(param));
    }

    /**
     * 千元用量商品关联-查询列表
     *
     * @folder 千元用量商品关联
     * @param param 查询
     * @return {@link ApiResult}
     */
    @PostMapping("/list")
    @ApiOperation("千元用量商品关联-查询列表")
    public ApiResult<List<ScpThousandUseRefVO>> queryList(@RequestBody ScpThousandUseRefParam param) {
        return ApiResult.ok(scpThousandUseRefService.queryListDynamic(param));
    }

    /**
     * 千元用量商品关联-删除
     *
     * @folder 千元用量商品关联
     * @param keys 主键id
     * @return result
     */
    @PostMapping("/delete")
    @ApiOperation("千元用量商品关联 - 删除")
    public ApiResult deleteByIds(@RequestBody List<Long> keys) {
        scpThousandUseRefService.deleteSoft(keys);
        return ApiResult.ok();
    }

}
