package com.elitesland.scp.domain.entity.order;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.jpa.common.PartitionField;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name = "scp_demand_order")
@org.hibernate.annotations.Table(appliesTo = "scp_demand_order", comment = "订货订单")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "订货订单", description = "订货订单")
@Where(clause = "delete_flag = 0")
public class ScpDemandOrderDO extends BaseModel implements Serializable {

    @ApiModelProperty("订货集ID")
    @Comment("订货集ID")
    @Column()
    private Long demandId;

    @ApiModelProperty("订货集编码")
    @Comment("订货集编码")
    @Column()
    private String demandCode;

    @ApiModelProperty("订货集名称")
    @Comment("订货集名称")
    @Column()
    private String demandName;

    @ApiModelProperty("订货单编码")
    @Comment("订货单编码")
    @Column()
    private String docCode;

    @ApiModelProperty("单据类别")
    @Comment("单据类别")
    @Column()
    private String docCls;

    @ApiModelProperty("单据状态")
    @Comment("单据状态")
    @Column()
    private String docStatus;

    @ApiModelProperty("类型")
    @Comment("类型")
    @Column()
    private String type;

    @ApiModelProperty("需求仓库id/门店id")
    @Comment("需求仓库id/门店id")
    @Column()
    private Long demandWhStId;

    @ApiModelProperty("需求仓库编码/门店编码")
    @Comment("需求仓库编码/门店编码")
    @Column()
    private String demandWhStCode;

    @ApiModelProperty("需求仓库名称/门店名称")
    @Comment("需求仓库名称/门店名称")
    @Column()
    private String demandWhStName;

    @ApiModelProperty("需求日期")
    @Comment("需求日期")
    @Column()
    private LocalDateTime demandDate;

    @ApiModelProperty("经营性质")
    @Comment("经营性质")
    @Column()
    private String storeType2;

    @ApiModelProperty("店面等级")
    @Comment("店面等级")
    @Column()
    private String storeLevel;

    @ApiModelProperty("付款状态")
    @Comment("付款状态")
    @Column()
    private String payStatus;

    @ApiModelProperty("单据类型")
    @Comment("单据类型")
    @Column()
    private String docType;

    @ApiModelProperty("业务类型")
    @Comment("业务类型")
    @Column()
    private String businessType;

    @ApiModelProperty("是否已计算")
    @Comment("是否已计算")
    @Column()
    private Boolean isCalculated;

    @ApiModelProperty("是否已推送")
    @Comment("是否已推送")
    @Column()
    private Boolean isPushed;

    @ApiModelProperty("收货地址号")
    @Comment("收货地址号")
    @Column()
    private Long recvAddrNo;

    @ApiModelProperty("收货联系人")
    @Comment("收货联系人")
    @Column()
    private String recvContactName;

    @ApiModelProperty("收货联系电话")
    @Comment("收货联系电话")
    @Column()
    private String recvContactTel;

    @ApiModelProperty("收货国家")
    @Comment("收货国家")
    @Column()
    private String recvCountry;

    @ApiModelProperty("收货省")
    @Comment("收货省")
    @Column()
    private String recvProvince;

    @ApiModelProperty("收货市")
    @Comment("收货市")
    @Column()
    private String recvCity;

    @ApiModelProperty("收货区县")
    @Comment("收货区县")
    @Column()
    private String recvCounty;

    @ApiModelProperty("收货详细地址")
    @Comment("收货详细地址")
    @Column()
    private String recvDetailaddr;

    @ApiModelProperty("是否评价，true已评价，false未评价")
    @Comment("是否评价，true已评价，false未评价")
    @Column()
    private Boolean replyFlag;

    @ApiModelProperty("表分区字段：月")
    @Comment("表分区字段：月")
    @Column(updatable = false)
    @PartitionField(PartitionField.PartitionType.YEAR_MONTH)
    private Integer ym;

    @ApiModelProperty("装修门店")
    @Comment("装修门店")
    @Column(name = "renovation_store", columnDefinition = "varchar(64) comment '装修门店'")
    private String renovationStore;
    @ApiModelProperty("装修门店名称")
    @Comment("装修门店名称")
    @Column(name = "renovation_store_name", columnDefinition = "varchar(64) comment '装修门店名称'")
    private String renovationStoreName;

    /**
     * 审批状态
     */
    @ApiModelProperty(value = "审批状态")
    @Comment("审批状态")
    @Column(columnDefinition = "varchar(32)")
    private String apprStatus;

    /**
     * 审批时间
     */
    @ApiModelProperty(value = "审批时间")
    @Comment("审批时间")
    @Column(columnDefinition = "datetime")
    private LocalDateTime apprTime;

    /**
     * 审批人ID
     */
    @ApiModelProperty(value = "审批人ID")
    @Comment("审批人ID")
    @Column(columnDefinition = "bigint ")
    private Long applyUserId;

    /**
     * 审批意见
     */
    @ApiModelProperty(value = "审批意见")
    @Comment("审批意见")
    @Column(columnDefinition = "varchar(128)")
    private String applyComment;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    @Column
    @Comment("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    @Comment("提交时间")
    @Column
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    @Comment("审批通过时间")
    @Column
    private LocalDateTime approvedTime;

    @ApiModelProperty(value = "在线账户支付金额")
    @Comment("在线账户支付金额")
    @Column
    @BusinessParam(dataPermissionEnabled = false)
    private BigDecimal creditAccAmt;

    @ApiModelProperty(value = "补贴账户支付金额")
    @Comment("补贴账户支付金额")
    @Column
    @BusinessParam(dataPermissionEnabled = false)
    private BigDecimal flzhAccAmt;

    @ApiModelProperty(value = "储值账户支付金额")
    @Comment("储值账户支付金额")
    @Column
    @BusinessParam(dataPermissionEnabled = false)
    private BigDecimal storeAccAmt;

    @ApiModelProperty(value = "全部推送时间")
    @Comment("全部推送时间")
    @Column
    private LocalDateTime pushedTime;

    @ApiModelProperty(value = "是否允许支付超时")
    @Column
    @Comment("是否允许支付超时")
    private Boolean allowPayTimeout;

    @ApiModelProperty("订单取消操作人")
    @Comment("订单取消操作人")
    @Column
    private String cancelOperator;

    @ApiModelProperty("预计到货日期")
    @Column
    @Comment("预计到货日期")
    private LocalDateTime etaDate;

    @ApiModelProperty("支付时间")
    @Column
    @Comment("支付时间")
    private LocalDateTime payDateTime;
}
