package com.elitesland.scp.domain.service.alloc;

import com.elitesland.scp.application.facade.vo.resp.alloc.ScpAllocSettingBrandRespVO;
import com.elitesland.scp.application.facade.vo.save.alloc.ScpAllocSettingBrandSaveVO;

import java.util.List;
import java.util.Set;

public interface ScpAllocSettingBrandDomainService {


    /**
     * 订货强配活动明细查询
     *
     * @param masId
     * @return
     */
    List<ScpAllocSettingBrandRespVO> findByMasId(Long masId);

    /**
     * 订货强配活动品牌保存
     *
     * @param saveVOS 保存单据类型配置的值对象
     * @return 返回保存后的单据类型配置的ID
     */
    void batchSaveAllocSettingBrand(List<ScpAllocSettingBrandSaveVO> saveVOS);

    /**
     * 删除订货强配活动明细
     *
     * @param masId
     */
    void deleteByMasId(Long masId);

    /**
     * 删除订货强配活动明细
     *
     * @param ids
     */
    void deleteByIds(List<Long> ids);

    /**
     * 根据品牌编码查询
     * @param brand
     * @return
     */
    List<Long> findMasIdByBrand(String brand, Set<Long> masIds);
}
